#define MAXPTS	40
#define MAXPOLY 50
#define MAXEDGE 20
#define MAXPT	40

typedef POINTFX4D PNT;

typedef struct 
{
    VECTORFX  nvec;	    /* Normal vector */
    BYTE      len;	    /* number of edges */
    int       ied[MAXPT];   /* list of edge index's, should be variable!! */
    int       ipt[MAXPT];   /* list of edge index's, should be variable!! */
    FIXED     zmin,zmax;
    FIXED     xmin,xmax;
    FIXED     ymin,ymax;

    HBITMAP   hbmTexture;
    DWORD     rgb;
}   POLY, *PPOLY, far *LPPOLY;

typedef struct 
{
    int     p1,p2;	/* two point indexes make a edge */
    BOOL    f;
}   EDGE;

typedef struct 
{
    PSTR        szTexture;    // surface picture
    HBITMAP     hbmTexture;
    DWORD       rgb;
}   SURFACE;

/* ---------------------------------------------------- */
/*              STATIC VARIABLE DEFINITIONS             */
/* ---------------------------------------------------- */

//typedef POLY  FAR * PPOLY;
//typedef PNT   FAR * PPNT;
//typedef EDGE  FAR * PEDGE;

extern  POINTFX4D FAR *POINTSQ;          // original 3d points
extern	POINTFX4D FAR *CPOINTSQ;         // converted 3d points
extern	POINT FAR *PNTS;            // projected 2d points
extern	EDGE  FAR *EDGES;           // all edges in the scene
extern	POLY  FAR *POLYS;           // all polys in the scene

int macPoint;
int macPoly;
int macEdge;

TRANSFORM  M;           /* Object to World transform */
TRANSFORM  V;           /* Viewing transform */
POINTFX4D    light;       /* light source position */
POINTFX4D    color;       /* Current color */
POINTFX4D    background;  /* background color */

DWORD      rgbBackground;

extern RECT    rcExtent;

int fDebug;

/* ---------------------------------------------------- */
/*		PROCEDURE DEFINITIONS			*/
/* ---------------------------------------------------- */

VECTORFX PolyNormal(LPPOLY pPoly, POINTFX4D FAR *pp);
