/**************************************************************************

    DRAWDIB.H   - routines for drawing DIBs to the screen.
	
    Copyright (c) 1990-1993, Microsoft Corp.  All rights reserved. 

    this code handles stretching and dithering with custom code

    the following DIB formats are supported:

        8bpp
        16bpp
        24bpp

    drawing to:

        16 color DC         (will dither 8bpp down)
        256 (palletized) DC (will dither 16 and 24bpp down)
        Full-color DC       (will just draw it!)

**************************************************************************/

#ifndef _LOADDS
    #define _LOADDS _loadds
#endif

typedef HANDLE HDRAWDIB; /* hdd */

/*********************************************************************

  DrawDib Flags
      
**********************************************************************/
#define DDF_PAL_COLORS      0x0001          /* ? */
#define DDF_UPDATE          0x0002          /* re-draw the last DIB */
#define DDF_SAME_HDC        0x0004          /* HDC same as last call (all setup) */
#define DDF_SAME_DRAW       0x0008          /* draw params are the same */
#define DDF_DONTDRAW        0x0010          /* dont draw frame, just decompress */
#define DDF_ANIMATE         0x0020          /* allow palette animation */
#define DDF_BUFFER          0x0040          /* always buffer image */
#define DDF_JUSTDRAWIT      0x0080          /* just draw it with GDI */
#define DDF_FULLSCREEN      0x0100          /* use DisplayDib */

#define DDF_SAME_DIB        DDF_SAME_DRAW
#define DDF_SAME_SIZE       DDF_SAME_DRAW

#define HDRAWDIB_DEFAULT    ((HDRAWDIB)1)


/*********************************************************************

    DrawDib functions
	
*********************************************************************/
/*
**  DrawDibOpen()
**
*/
extern HDRAWDIB FAR _LOADDS PASCAL DrawDibOpen(void);

/*
**  DrawDibClose()
**
*/
extern BOOL FAR _LOADDS PASCAL DrawDibClose(HDRAWDIB hdd);

/*
**  DrawDibError()
*/
extern UINT FAR _LOADDS PASCAL DrawDibError(HDRAWDIB hdd);

/*
**  DrawDibGetPalette()
**
**  get the palette used for drawing DIBs
**
*/
extern HPALETTE FAR _LOADDS PASCAL DrawDibGetPalette(HDRAWDIB hdd);


/*
**  DrawDibSetPalette()
**
**  get the palette used for drawing DIBs
**
*/
extern BOOL FAR _LOADDS PASCAL DrawDibSetPalette(HDRAWDIB hdd, HPALETTE hpal);

/*
**  DrawDibChangePalette()
*/
extern BOOL FAR _LOADDS PASCAL DrawDibChangePalette(HDRAWDIB hdd, int iStart, int iLen, LPPALETTEENTRY lppe);

/*
**  DrawDibRealize()
**
**  realize the palette in a HDD
**
*/
extern UINT FAR _LOADDS PASCAL DrawDibRealize(HDRAWDIB hdd, HDC hdc, BOOL fBackground);

/*
**  DrawDibBegin()
**
**  prepare to draw
**
*/
extern BOOL FAR _LOADDS PASCAL DrawDibBegin(HDRAWDIB hdd,
                                    HDC      hdc,
                                    int      dxDst,
                                    int      dyDst,
                                    LPBITMAPINFOHEADER lpbi,
                                    int      dxSrc,
                                    int      dySrc,
                                    UINT     wFlags);
/*
**  DrawDibDraw()
**
**  actualy draw a DIB to the screen.
**
*/
extern BOOL FAR _LOADDS PASCAL DrawDibDraw(HDRAWDIB hdd,
                                   HDC      hdc,
                                   int      xDst,
                                   int      yDst,
                                   int      dxDst,
                                   int      dyDst,
                                   LPBITMAPINFOHEADER lpbi,
                                   LPVOID   lpBits,
                                   int      xSrc,
                                   int      ySrc,
                                   int      dxSrc,
                                   int      dySrc,
                                   UINT     wFlags);

/*
**  DrawDibEnd()
*/
extern BOOL FAR _LOADDS PASCAL DrawDibEnd(HDRAWDIB hdd);

/*
**  DrawDibTime()  [for debugging purposes only]
*/
typedef struct {
    LONG    timeCount;
    LONG    timeDraw;
    LONG    timeDecompress;
    LONG    timeDither;
    LONG    timeStretch;
    LONG    timeBlt;
    LONG    timeSetDIBits;
}   DRAWDIBTIME, FAR *LPDRAWDIBTIME;

BOOL FAR _LOADDS PASCAL DrawDibTime(HDRAWDIB hdd, LPDRAWDIBTIME lpddtime);


/* display profiling */
#define PD_CAN_DRAW_DIB         0x0001      /* if you can draw at all */
#define PD_CAN_STRETCHDIB       0x0002      /* basicly RC_STRETCHDIB */
#define PD_STRETCHDIB_1_1_OK    0x0004      /* is it fast? */
#define PD_STRETCHDIB_1_2_OK    0x0008      /* ... */
#define PD_STRETCHDIB_1_N_OK    0x0010      /* ... */

DWORD FAR PASCAL _LOADDS DrawDibProfileDisplay(LPBITMAPINFOHEADER lpbi);
