/*----------------------------------------------------------------------------*\
 *
 *  MCIWnd
 *
 *    MCIWnd window class header file.
 *
 *    the MCIWnd window class is a window class for controling MCI devices
 *    MCI devices include, wave files, midi files, AVI Video, cd audio,
 *    vcr, video disc, and others..
 *
 *    to learn more about MCI and mci command sets see the
 *    "Microsoft Multimedia Programmers's guide" in the Win31 SDK
 *
 *    the easiest use of the MCIWnd class is like so:
 *
 *          hwnd = MCIWndCreate(hwndParent, hInstance, 0, "smag.wav");
 *          ...
 *          MCIWndPlay(hwnd);
 *          MCIWndStop(hwnd);
 *          MCIWndPause(hwnd);
 *          ....
 *          MCIWndDestroy(hwnd);
 *
 *    this will create a window with a play/pause, stop and a playbar
 *    and start the wave file playing.
 *
 *    mciwnd.h defines macros for all the most common MCI commands, but
 *    any string command can be used if needed.  Note unlike the
 *    mciSendString() API, no alias or file name needs to be specifed.
 *
 *          MCIWndSendString(hwnd, "set hue to bright");
 *
 *
 *    NOTE NOTE NOTE this library is in pre-release not all functionality
 *    is complete.
 *
 *    (C) Copyright Microsoft Corp. 1991, 1992, 1993.  All rights reserved.
 *
 *    You have a royalty-free right to use, modify, reproduce and
 *    distribute the Sample Files (and/or any modified version) in
 *    any way you find useful, provided that you agree that
 *    Microsoft has no warranty obligations or liability for any
 *    Sample Application Files.
 *
 *    If you did not get this from Microsoft Sources, then it may not be the
 *    most current version.  This sample code in particular will be updated
 *    and include more documentation.
 *
 *    Sources are:
 *       CompuServe: WINSDK forum, MDK section.
 *       Anonymous FTP from ftp.uu.net vendor\microsoft\multimedia
 *
 *----------------------------------------------------------------------------*/

#define MCIWND_WINDOW_CLASS "MCIWndClass"

HWND FAR MCIWndCreate(HWND hwndParent, HINSTANCE hInstance,
		      DWORD dwStyle,LPSTR szFile);

BOOL FAR MCIWndRegisterClass(HINSTANCE hInstance);

// window styles
#define MCIWND_NOAUTOSIZE	    0x00000001	// no auto size on OPEN
#define MCIWND_NOPLAYBAR	    0x00000002	// no toolbar
#define MCIWND_NORESIZETOWINDOW     0x00000004	// no resize movie size to window
#define MCIWND_NOTRACKMENU	    0x00000008	// no popup menu
#define MCIWND_NOTIFYSTATE          0x00000010  // tell parent of state change
#define MCIWND_NOTIFYPOS            0x00000020  // tell parent of pos change
#define MCIWND_SHOWNAME             0x00000100  // show name in caption
#define MCIWND_SHOWPOS              0x00000200  // show position in caption
#define MCIWND_SHOWSTATE            0x00000400  // show state in caption
#define MCIWND_SHOWALL              0x00000F00  // show all

#define MCIWndOpen(hwnd, sz, f)     (LONG)SendMessage(hwnd, MCI_OPEN, (WPARAM)(UINT)(f),(LPARAM)(LPVOID)(sz))
#define MCIWndClose(hwnd)           (LONG)SendMessage(hwnd, MCI_CLOSE, 0, 0)
#define MCIWndPlay(hwnd)            (LONG)SendMessage(hwnd, MCI_PLAY, 0, 0)
#define MCIWndStop(hwnd)            (LONG)SendMessage(hwnd, MCI_STOP, 0, 0)
#define MCIWndPause(hwnd)           (LONG)SendMessage(hwnd, MCI_PAUSE, 0, 0)
#define MCIWndResume(hwnd)          (LONG)SendMessage(hwnd, MCI_RESUME, 0, 0)
#define MCIWndSeek(hwnd, lPos)      (LONG)SendMessage(hwnd, MCI_SEEK, 0, (LPARAM)(LONG)(lPos))

#define MCIWndHome(hwnd)            MCIWndSeek(hwnd, MCIWND_START)
#define MCIWndEnd(hwnd)             MCIWndSeek(hwnd, MCIWND_END)

#define MCIWndPlayReverse(hwnd)	    MCIWndPlayTo(hwnd, MCIWND_START)
#define MCIWndPlayFrom(hwnd, lPos)  (LONG)SendMessage(hwnd, MCIWNDM_PLAYFROM, 0, (LPARAM)(LONG)(lPos))
#define MCIWndPlayTo(hwnd, lPos)    (LONG)SendMessage(hwnd, MCIWNDM_PLAYTO,   0, (LPARAM)(LONG)(lPos))
#define MCIWndPlayFromTo(hwnd, lStart, lEnd) (MCIWndSeek(hwnd, lStart), MCIWndPlayTo(hwnd, lEnd))

#define MCIWndGetDeviceID(hwnd)     (UINT)SendMessage(hwnd, MCIWNDM_GETDEVICEID, 0, 0)
#define MCIWndGetMode(hwnd)         (LONG)SendMessage(hwnd, MCIWNDM_GETMODE, 0, 0)
#define MCIWndGetPosition(hwnd)     (LONG)SendMessage(hwnd, MCIWNDM_GETPOSITION, 0, 0)
#define MCIWndGetStart(hwnd)        (LONG)SendMessage(hwnd, MCIWNDM_GETSTART, 0, 0)
#define MCIWndGetLength(hwnd)       (LONG)SendMessage(hwnd, MCIWNDM_GETLENGTH, 0, 0)
#define MCIWndGetEnd(hwnd)          (LONG)SendMessage(hwnd, MCIWNDM_GETEND, 0, 0)

#define MCIWndStep(hwnd, n)         (LONG)SendMessage(hwnd, MCI_STEP, 0,(LPARAM)(long)(n))

#define MCIWndDestroy(hwnd)         (VOID)SendMessage(hwnd, WM_CLOSE, 0, 0)
#define MCIWndSetZoom(hwnd,iZoom)   (VOID)SendMessage(hwnd, MCIWNDM_SETZOOM, 0, iZoom)
#define MCIWndSetVolume(hwnd,iVol)  (LONG)SendMessage(hwnd, MCIWNDM_SETVOLUME, 0, iVol)
#define MCIWndGetVolume(hwnd)       (LONG)SendMessage(hwnd, MCIWNDM_GETVOLUME, 0, 0)
#define MCIWndSetSpeed(hwnd,iSpeed) (LONG)SendMessage(hwnd, MCIWNDM_SETSPEED, 0, iSpeed)
#define MCIWndGetSpeed(hwnd)        (LONG)SendMessage(hwnd, MCIWNDM_GETSPEED, 0, 0)
#define MCIWndSetRepeat(hwnd,f)     (LONG)SendMessage(hwnd, MCIWNDM_SETREPEAT, 0, f)
#define MCIWndGetRepeat(hwnd)       (LONG)SendMessage(hwnd, MCIWNDM_GETREPEAT, 0, 0)
#define MCIWndSetTimeFormat(hwnd, n) (LONG)SendMessage(hwnd, MCIWNDM_SETTIMEFORMAT, 0, n)
#define MCIWndGetTimeFormat(hwnd)   (LONG)SendMessage(hwnd, MCIWNDM_GETTIMEFORMAT, 0, 0)
#define MCIWndValidateMedia(hwnd)   (VOID)SendMessage(hwnd, MCIWNDM_VALIDATEMEDIA, 0, 0)

#define MCIWndUseFrames(hwnd)       MCIWndSetTimeFormat(hwnd,MCIWND_TIMEFORMAT_FRAMES)
#define MCIWndUseTime(hwnd)         MCIWndSetTimeFormat(hwnd,MCIWND_TIMEFORMAT_MS)

#define MCIWndRealize(hwnd, fBkgnd) (LONG)SendMessage(hwnd, MCIWNDM_REALIZE,(WPARAM)(BOOL)(fBkgnd),0)

#define MCIWndSendString(hwnd, sz)  (LONG)SendMessage(hwnd, MCIWNDM_SENDSTRING, 0, (LPARAM) sz)

// Our new Window Messages
#define MCIWNDM_GETDEVICEID	(WM_USER + 0)
#define MCIWNDM_SENDSTRING	(WM_USER + 1)
#define MCIWNDM_GETPOSITION	(WM_USER + 2)
#define MCIWNDM_GETSTART	(WM_USER + 3)
#define MCIWNDM_GETLENGTH	(WM_USER + 4)
#define MCIWNDM_GETEND		(WM_USER + 5)
#define MCIWNDM_GETMODE		(WM_USER + 6)
#define MCIWNDM_SETZOOM		(WM_USER + 8)
#define MCIWNDM_SETVOLUME	(WM_USER + 10)
#define MCIWNDM_GETVOLUME	(WM_USER + 11)
#define MCIWNDM_SETSPEED	(WM_USER + 12)
#define MCIWNDM_GETSPEED	(WM_USER + 13)
#define MCIWNDM_SETREPEAT	(WM_USER + 14)
#define MCIWNDM_GETREPEAT	(WM_USER + 15)
#define MCIWNDM_NOTIFYSTATE	(WM_USER + 16)
#define MCIWNDM_NOTIFYPOS	(WM_USER + 17)
#define MCIWNDM_REALIZE         (WM_USER + 18)
#define MCIWNDM_SETTIMEFORMAT   (WM_USER + 19)
#define MCIWNDM_GETTIMEFORMAT   (WM_USER + 20)
#define MCIWNDM_VALIDATEMEDIA   (WM_USER + 21)
#define MCIWNDM_PLAYFROM	(WM_USER + 22)
#define MCIWNDM_PLAYTO		(WM_USER + 23)

// special seek values for START and END
#define MCIWND_START                -1
#define MCIWND_END                  -2
// special values for setting the time format
#define MCIWND_TIMEFORMAT_MS		1
#define MCIWND_TIMEFORMAT_FRAMES	2
// error code for setting the format
#define MCIWND_ERROR_INVALIDFORMAT	0xF000	// !!!

#ifndef MCI_PLAY
    /* MCI command message identifiers */
    #define MCI_OPEN                        0x0803
    #define MCI_CLOSE                       0x0804
    #define MCI_PLAY                        0x0806
    #define MCI_SEEK                        0x0807
    #define MCI_STOP                        0x0808
    #define MCI_PAUSE                       0x0809
    #define MCI_STEP                        0x080E
    #define MCI_CUT                         0x0851
    #define MCI_COPY                        0x0852
    #define MCI_PASTE                       0x0853
    #define MCI_RESUME                      0x0855
    #define MCI_DELETE                      0x0856
#endif

#ifndef MCI_MODE_NOT_READY
    /* return values for 'status mode' command */
    #define MCI_MODE_NOT_READY      (524)
    #define MCI_MODE_STOP           (525)
    #define MCI_MODE_PLAY           (526)
    #define MCI_MODE_RECORD         (527)
    #define MCI_MODE_SEEK           (528)
    #define MCI_MODE_PAUSE          (529)
    #define MCI_MODE_OPEN           (530)
#endif
