///////////////////////////////////////////////////////////////////////////////
//
//  ICM.H
//
//      helper routines for compressing/decompressing/and choosing compressors.
//
//      in order to use the ICChooseCompressor() function you need to include
//      ICM.DLG into your apps resource file.
//
//      (C) Copyright Microsoft Corp. 1991, 1992, 1993.  All rights reserved.
//
//      You have a royalty-free right to use, modify, reproduce and
//      distribute the Sample Files (and/or any modified version) in
//      any way you find useful, provided that you agree that
//      Microsoft has no warranty obligations or liability for any
//      Sample Application Files.
//
//      If you did not get this from Microsoft Sources, then it may not be the
//      most current version.  This sample code in particular will be updated
//      and include more documentation.
//
//      Sources are:
//         CompuServe: WINSDK forum, MDK section.
//         Anonymous FTP from ftp.uu.net vendor\microsoft\multimedia
//
///////////////////////////////////////////////////////////////////////////////

HANDLE FAR ICCompressImage(
        HIC                 hic,        // compressor to use
        UINT                uiFlags,    // flags (none yet)
        LPBITMAPINFOHEADER  lpbiIn,     // format to compress from
        LPVOID              lpBits,     // data to compress
        LPBITMAPINFOHEADER  lpbiOut,    // format to compress to (NULL ==> default)
        LONG                lQuality);  // quality to use

HANDLE FAR ICDecompressImage(
        HIC                 hic,        // compressor to use
        UINT                uiFlags,    // flags (none yet)
        LPBITMAPINFOHEADER  lpbiIn,     // format to decompress from
        LPVOID              lpBits,     // data to decompress
        LPBITMAPINFOHEADER  lpbiOut,    // format to decompress to (NULL ==> default)
        LONG                lQuality);  // quality to use

//
//  allows user to choose compressor, quality etc...
//
BOOL FAR ICChooseCompressor(
        HWND        hwnd,               // parent window for dialog
        DWORD       fccType,            // compressor type to choose
        UINT        uiFlags,            // flags.
        LPVOID      pvIn,               // input format (optional)
        LPVOID      lpData,             // input data (optional)
        HIC         FAR *phic,          // return HIC (caller must free)
        LONG        FAR *plQuality);    // return quality
