/****************************************************************************
 *
 *   icsample.h
 *
 *   Copyright (c) 1991-1993 Microsoft Corporation.  All Rights Reserved.
 *
 *    You have a royalty-free right to use, modify, reproduce and 
 *    distribute the Sample Files (and/or any modified version) in 
 *    any way you find useful, provided that you agree that 
 *    Microsoft has no warranty obligations or liability for any 
 *    Sample Application Files which are modified. 
 *
 ***************************************************************************/

typedef struct {
    DWORD       fccHandler;             // this should be your handler
    WORD        wPixelKeepRatio ;
    WORD        wColorBitsToDrop ;
} ICSTATE;

typedef struct {
/********************************************************************/
//
//  These two fields MUST be first and in this order.
//
    DWORD       fccType;        // gives type of our state info ('vidc')
                                // this allows us to combine 'vcap' or other
                                // stream/ICM types into one driver
    DRIVERPROC  DriverProc;     // driver proc for the instance
/********************************************************************/
    DWORD       dwFlags;        // flags from ICOPEN
    ICSTATE     CurrentState;	// current state of compressor.
    int         nCompress;      // count of COMPRESS_BEGIN calls
    int         nDecompress;    // count of DECOMPRESS_BEGIN calls
    int 	nDraw;	        // count of DRAW_BEGIN calls
} INSTINFO, *PINSTINFO;

BOOL       NEAR PASCAL Load(void);
void       NEAR PASCAL Free(void);
INSTINFO * NEAR PASCAL Open(ICOPEN FAR *icinfo);
DWORD      NEAR PASCAL Close(INSTINFO * pinst);
DWORD	   NEAR PASCAL GetState(INSTINFO * pinst, LPVOID pv, DWORD dwSize);
DWORD      NEAR PASCAL SetState(INSTINFO * pinst, LPVOID pv, DWORD dwSize);
DWORD	   NEAR PASCAL GetInfo(INSTINFO * pinst, ICINFO FAR *icinfo, DWORD dwSize);

BOOL	   NEAR PASCAL QueryAbout(INSTINFO * pinst);
DWORD      NEAR PASCAL About(INSTINFO * pinst, HWND hwnd);
BOOL	   NEAR PASCAL QueryConfigure(INSTINFO * pinst);
DWORD	   NEAR PASCAL Configure(INSTINFO * pinst, HWND hwnd);

LRESULT    NEAR PASCAL CompressBegin(INSTINFO * pinst, LPBITMAPINFOHEADER lpbiIn, LPBITMAPINFOHEADER lpbiOut);
LRESULT    NEAR PASCAL CompressQuery(INSTINFO * pinst, LPBITMAPINFOHEADER lpbiIn,LPBITMAPINFOHEADER lpbiOut);
LRESULT    NEAR PASCAL CompressGetFormat(INSTINFO * pinst, LPBITMAPINFOHEADER lpbiIn, LPBITMAPINFOHEADER lpbiOut);
LRESULT    NEAR PASCAL Compress(INSTINFO * pinst,ICCOMPRESS FAR *icinfo, DWORD dwSize);
LRESULT    NEAR PASCAL CompressGetSize(INSTINFO * pinst, LPBITMAPINFOHEADER lpbiIn, LPBITMAPINFOHEADER lpbiOut);
LRESULT    NEAR PASCAL CompressEnd(INSTINFO * lpinst);

LRESULT    NEAR PASCAL DecompressBegin(INSTINFO * pinst, LPBITMAPINFOHEADER lpbiIn, LPBITMAPINFOHEADER lpbiOut);
LRESULT    NEAR PASCAL DecompressQuery(INSTINFO * pinst, LPBITMAPINFOHEADER lpbiIn,LPBITMAPINFOHEADER lpbiOut);
LRESULT    NEAR PASCAL DecompressGetFormat(INSTINFO * pinst, LPBITMAPINFOHEADER lpbiIn, LPBITMAPINFOHEADER lpbiOut);
LRESULT    NEAR PASCAL DecompressGetPalette(INSTINFO * pinst, LPBITMAPINFOHEADER lpbiIn, LPBITMAPINFOHEADER lpbiOut);
LRESULT    NEAR PASCAL Decompress(INSTINFO * pinst,ICDECOMPRESS FAR *icinfo, DWORD dwSize);
LRESULT    NEAR PASCAL DecompressEnd(INSTINFO * pinst);

BOOL       NEAR PASCAL DrawQuery(INSTINFO * pinst, LPBITMAPINFOHEADER lpbiInput);
LRESULT    NEAR PASCAL DrawBegin(INSTINFO * pinst,ICDRAWBEGIN FAR *icinfo, DWORD dwSize);
LRESULT    NEAR PASCAL Draw(INSTINFO * pinst,ICDRAW FAR *icinfo, DWORD dwSize);
LRESULT    NEAR PASCAL DrawEnd(INSTINFO * pinst);

/********************************************************************
 ********************************************************************/

#define ID_SCROLL   101
#define ID_TEXT     102
#define ID_SCROLL2  103
#define ID_TEXT2    104 

/********************************************************************
 ********************************************************************/

#ifdef DEBUG
    extern void FAR CDECL dprintf(LPSTR, ...);
    #define DPF dprintf
#else
    #define DPF / ## /
#endif
