/****************************************************************************
 *
 *  AVIEASY.H
 *
 *  basic routines for writing Standard AVI files
 *
 *  Copyright (c) 1992-1993 Microsoft Corporation.  All Rights Reserved.
 *
 *  You have a royalty-free right to use, modify, reproduce and
 *  distribute the Sample Files (and/or any modified version) in
 *  any way you find useful, provided that you agree that
 *  Microsoft has no warranty obligations or liability for any
 *  Sample Application Files which are modified.
 *
 ***************************************************************************/

//
// if you dont include avi_fmt.h we will define what we need.
//
#ifndef _INC_AVIFMT

#ifndef mmioFOURCC
    #define mmioFOURCC( ch0, ch1, ch2, ch3 ) \
		( (DWORD)(BYTE)(ch0) | ( (DWORD)(BYTE)(ch1) << 8 ) |    \
		( (DWORD)(BYTE)(ch2) << 16 ) | ( (DWORD)(BYTE)(ch3) << 24 ) )
#endif

#define streamtypeVIDEO         mmioFOURCC('v', 'i', 'd', 's')
#define streamtypeAUDIO         mmioFOURCC('a', 'u', 'd', 's')
#define streamtypeMIDI          mmioFOURCC('m', 'i', 'd', 's')
#define streamtypeTEXT          mmioFOURCC('t', 'x', 't', 's')

/* Flags for index */
#define AVIIF_KEYFRAME      0x00000010L // this frame is a key frame.

/* This is the structure of the main AVI header found in the "avih" chunk */
/* of the "hdrl" list of the RIFF file.                                   */
typedef struct 
{
    DWORD		dwMicroSecPerFrame;	// frame display rate (or 0L)
    DWORD		dwMaxBytesPerSec;	// max. transfer rate
    DWORD		dwPaddingGranularity;	// pad to multiples of this
                                                // size; normally 2K.
    DWORD		dwFlags;		// the ever-present flags
    DWORD		dwTotalFrames;		// # frames in file
    DWORD		dwInitialFrames;
    DWORD		dwStreams;
    DWORD		dwSuggestedBufferSize;
    
    DWORD		dwWidth;
    DWORD		dwHeight;
    
    DWORD		dwReserved[4];
} MainAVIHeader;

/* This is the structure of each stream header found in the "strh" chunk */
/* of the "strl" list of the "hdrl" list of the RIFF file.               */
typedef struct {
    DWORD               fccType;
    DWORD               fccHandler;
    DWORD               dwFlags;        /* Contains AVITF_* flags */
    DWORD               dwPriority;
    DWORD               dwInitialFrames;
    DWORD               dwScale;        
    DWORD               dwRate; /* dwRate / dwScale == samples/second */
    DWORD               dwStart;
    DWORD               dwLength; /* In units above... */
    DWORD               dwSuggestedBufferSize;
    DWORD               dwQuality;
    DWORD               dwSampleSize;
    RECT                rcFrame;
} AVIStreamHeader;

#endif

#ifndef AVIERR_OK
#define AVIERR_OK                0L
#define AVIERR_UNSUPPORTED      -1L
#define AVIERR_BADFORMAT        -2L
#define AVIERR_MEMORY           -3L
#define AVIERR_INTERNAL         -4L
#define AVIERR_BADFLAGS         -5L
#define AVIERR_BADPARAM         -6L
#define AVIERR_BADSIZE          -7L
#define AVIERR_BADHANDLE        -8L
#define AVIERR_FILEREAD         -9L
#define AVIERR_FILEWRITE        -10L
#define AVIERR_FILEOPEN         -11L
#define AVIERR_COMPRESSOR       -12L
#define AVIERR_NOCOMPRESSOR     -13L
#define AVIERR_USERABORT        -99L
#define AVIERR_ERROR            -100L
#endif

DECLARE_HANDLE32(HAVI);

/* These are the function prototypes of the functions provided by AVIEASY.C  */

LONG FAR avifileOpen(HAVI FAR *lphfile, LPSTR lpFileName, MainAVIHeader FAR *lphdr);

LONG FAR avifileAddStream(HAVI hfile, int FAR *lpstream,
	     AVIStreamHeader FAR *lphdr,
	     LPVOID lpFormat,
	     LONG   cbFormat);

// !!! This function is not implemented
LONG FAR avifileWriteToHeader(HAVI hfile,
			  int stream,
			  DWORD ckid,
			  LPVOID lpData,
			  LONG cbData);

LONG FAR avifileWrite(HAVI	hfile,
		      int	stream,
		      LPVOID	lpData,
		      LONG	cbData,
		      WORD	cktype,
		      DWORD	dwFlags);

LONG FAR avifileEndRecord(HAVI hfile);

LONG FAR avifileClose(HAVI hfile);


LONG FAR aviVideoOpen(HAVI FAR *lphfile,
		      LPSTR lpFileName,
		      LPBITMAPINFOHEADER lpbi,
		      DWORD dwMicroSecPerFrame);

LONG FAR aviVideoWriteFrame(HAVI hfile,
			    LPBITMAPINFOHEADER lpbi,
			    LPVOID lp,
			    DWORD dwFlags);

