/*
 * DOCWIN.CPP
 * Sample Code Class Libraries
 *
 * Window procedure for document windows.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */



#include <windows.h>
#include "classlib.h"




/*
 * DocumentWndProc
 *
 * Purpose:
 *  Document window class that contains a polyline but does not own
 *  things like the gizmobar.
 *
 *  We handle all commands from menus and gizmobars as well as
 *  notifications from the polyline itself.  The frame Schmoo
 *  window just makes sure that commands and such are dispatched
 *  here as necessary, especially in an MDI case.
 */

LRESULT __export FAR PASCAL DocumentWndProc(HWND hWnd, UINT iMsg
    , WPARAM wParam, LPARAM lParam)
    {
    LPCDocument     pDoc;
    BOOL            fOK=FALSE;
    LPARAM          lTemp;
    LRESULT         lRet;

    //This will be valid for all messages except WM_NCCREATE
    pDoc=(LPCDocument)GetWindowLong(hWnd, DOCWL_STRUCTURE);


    if (NULL!=pDoc)
        {
        //Call the hook and return its value if it tells us to.
        if (pDoc->FMessageHook(hWnd, iMsg, wParam, lParam, &lRet))
            return lRet;
        }


    switch (iMsg)
        {
        case WM_CREATE:
            /*
             * Save our object pointer with this window.  We have to
             * do this inside this message since we don't get the
             * MDICREATESTRUCT anywhere else.
             */

            lTemp=(LPARAM)((LPCREATESTRUCT)lParam)->lpCreateParams;
            pDoc=(LPCDocument)((LONG)((LPMDICREATESTRUCT)lTemp)->lParam);

            //Store with the window--UINT converts to 32-bits.
            SetWindowLong(hWnd, DOCWL_STRUCTURE, (LONG)(LPSTR)pDoc);
            break;


        case WM_CLOSE:
            //Tell our main window to close us
            if (NULL!=pDoc->m_pAdv)
                pDoc->m_pAdv->OnCloseRequest(pDoc);

            break;


        case WM_QUERYENDSESSION:
            return TRUE;    //Right now we can always close.


        case DOCM_PDOCUMENT:
            //Return our object pointer
            return (LONG)(LPSTR)pDoc;

        case WM_MDIACTIVATE:
            if (0!=wParam && NULL!=pDoc->m_pAdv)
                pDoc->m_pAdv->OnActivate(pDoc);

            break;


        default:
            return DEFDOCUMENTPROC(hWnd, iMsg, wParam, lParam);
        }

    return 0L;
    }
