/*
 * IPOLY6.H
 * Chapter 6 Polyline Object
 *
 * Definition of an IPolyline interface for a Polyline object used
 * in the Schmoo implementation.  This interface is custom and is
 * only supported from DLL-based objects.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _IPOLY6_H_
#define _IPOLY6_H_


//Versioning.
#define VERSIONMAJOR                2
#define VERSIONMINOR                0
#define VERSIONCURRENT              0x00020000

#define CPOLYLINEPOINTS             20

//Version 2.0 Polyline Structure
typedef struct __far tagPOLYLINEDATA
    {
    WORD        wVerMaj;                //Major version number.
    WORD        wVerMin;                //Minor version number.
    WORD        cPoints;                //Number of points.
    BOOL        fReserved;              //Previously fDrawEntire, obsoleted
    RECT        rc;                     //Rectangle of this figure (client)
    POINT       rgpt[CPOLYLINEPOINTS];  //Array of points on 0-32767 grid.

    //Version 2.0 additions
    COLORREF    rgbBackground;          //Background color
    COLORREF    rgbLine;                //Line color
    int         iLineStyle;             //Line style
    } POLYLINEDATA, *PPOLYLINEDATA, FAR *LPPOLYLINEDATA;

#define CBPOLYLINEDATA   sizeof(POLYLINEDATA)


/*
 * !!Addition:  Clipboard format shared with using applications
 * This name matches those in the stringtable of all Schmoo and CoSchmoo
 * versions.  All data is interchangable.
 */
#define SZPOLYLINECLIPFORMAT        "Polyline Figure"



//We use the OLE 2.0 macro to define a new interface
#undef  INTERFACE
#define INTERFACE IPolylineAdviseSink6


/*
 * When someone initializes a polyline and is interested in receiving
 * notifications on events, then they provide one of these objects.
 */

DECLARE_INTERFACE_(IPolylineAdviseSink6, IUnknown)
    {
    //IUnknown members
    STDMETHOD(QueryInterface) (THIS_ REFIID, LPVOID FAR *) PURE;
    STDMETHOD_(ULONG,AddRef)  (THIS) PURE;
    STDMETHOD_(ULONG,Release) (THIS) PURE;

    //Advise members.
    STDMETHOD_(void,OnPointChange)     (THIS) PURE;
    STDMETHOD_(void,OnSizeChange)      (THIS) PURE;
    STDMETHOD_(void,OnColorChange)     (THIS) PURE;
    STDMETHOD_(void,OnLineStyleChange) (THIS) PURE;

    //OnDataChange replaced with IAdviseSink
    };

typedef IPolylineAdviseSink6 FAR * LPPOLYLINEADVISESINK;




//We use the OLE 2.0 macro to define a new interface
#undef  INTERFACE
#define INTERFACE IPolyline6


DECLARE_INTERFACE_(IPolyline6, IUnknown)
    {
    //IUnknown members
    STDMETHOD(QueryInterface) (THIS_ REFIID, LPVOID FAR *) PURE;
    STDMETHOD_(ULONG,AddRef)  (THIS) PURE;
    STDMETHOD_(ULONG,Release) (THIS) PURE;

    //IPolyline members

    //File-related members use IPersistStorage
    //Data transfer members use IDataObject

    //Manipulation members:
    STDMETHOD(Init)   (THIS_ HWND, LPRECT, DWORD, UINT) PURE;
    STDMETHOD(New)    (THIS) PURE;
    STDMETHOD(Undo)   (THIS) PURE;
    STDMETHOD(Window) (THIS_ HWND FAR *) PURE;

    STDMETHOD(SetAdvise) (THIS_ LPPOLYLINEADVISESINK) PURE;
    STDMETHOD(GetAdvise) (THIS_ LPPOLYLINEADVISESINK FAR *) PURE;

    STDMETHOD(RectGet) (THIS_ LPRECT) PURE;
    STDMETHOD(SizeGet) (THIS_ LPRECT) PURE;
    STDMETHOD(RectSet) (THIS_ LPRECT, BOOL) PURE;
    STDMETHOD(SizeSet) (THIS_ LPRECT, BOOL) PURE;

    STDMETHOD(ColorSet) (THIS_ UINT, COLORREF, COLORREF FAR *) PURE;
    STDMETHOD(ColorGet) (THIS_ UINT, COLORREF FAR *) PURE;

    STDMETHOD(LineStyleSet) (THIS_ UINT, UINT FAR *) PURE;
    STDMETHOD(LineStyleGet) (THIS_ UINT FAR *) PURE;
    };


typedef IPolyline6 FAR * LPPOLYLINE;



//Error values for data transfer functions, in SCODEs instead of #defines
#define POLYLINE_E_INVALIDPOINTER      MAKE_SCODE(SEVERITY_ERROR, FACILITY_ITF, 1)


//Color indices for color member functions
#define POLYLINECOLOR_BACKGROUND    0
#define POLYLINECOLOR_LINE          1


#endif //_IPOLY6_H_
