/*
 * ICLASSF.H
 *
 * Definitions and function prototypes for a template IClassFactory
 * interface implementation.  This class provides standard IUnknown
 * and IClassFactory members.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _ICLASSF_H_
#define _ICLASSF_H_


class __far CImpIClassFactory : public IClassFactory
    {
    protected:
        ULONG           m_cRef;         //Reference count on object

    public:
        CImpIClassFactory(void);
        ~CImpIClassFactory(void);

        //IUnknown interface members
        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //IClassFactory members
        STDMETHODIMP CreateInstance(LPUNKNOWN, REFIID, LPVOID FAR *);
        STDMETHODIMP LockServer(BOOL);
    };


typedef CImpIClassFactory FAR * LPIMPICLASSFACTORY;


#endif _ICLASSF_H_
