/*
 * IVIEWOBJ.CPP
 *
 * Template implementation of the IViewObject interface.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#include "iviewobj.h"


/*
 * CImpIViewObject::CImpIViewObject
 * CImpIViewObject::~CImpIViewObject
 *
 * Parameters (Constructor):
 *  pObj            LPVOID of the object we're in.
 *  punkOuter       LPUNKNOWN to which we delegate.
 */

CImpIViewObject::CImpIViewObject(LPVOID pObj, LPUNKNOWN punkOuter)
    {
    m_cRef=0;
    m_pObj=pObj;
    m_punkOuter=punkOuter;
    return;
    }

CImpIViewObject::~CImpIViewObject(void)
    {
    return;
    }




/*
 * CImpIViewObject::QueryInterface
 * CImpIViewObject::AddRef
 * CImpIViewObject::Release
 *
 * Purpose:
 *  IUnknown members for CImpIViewObject object.
 */

STDMETHODIMP CImpIViewObject::QueryInterface(REFIID riid, LPVOID FAR *ppv)
    {
    return m_punkOuter->QueryInterface(riid, ppv);
    }


STDMETHODIMP_(ULONG) CImpIViewObject::AddRef(void)
    {
    ++m_cRef;
    return m_punkOuter->AddRef();
    }

STDMETHODIMP_(ULONG) CImpIViewObject::Release(void)
    {
    --m_cRef;
    return m_punkOuter->Release();
    }






/*
 * CImpIViewObject::Draw
 *
 * Purpose:
 *  Draws the object on the given hDC specifically for the requested
 *  aspect, device, and within the appropriate bounds.
 *
 * Parameters:
 *  dwAspect        DWORD aspect to draw.
 *  lindex          LONG index of the piece to draw.
 *  pvAspect        LPVOID for extra information, always NULL.
 *  ptd             DVTARGETDEVICE FAR * containing device information.
 *  hICDev          HDC containing the IC for the device.
 *  hDC             HDC on which to draw.
 *  pRectBounds     LPRECTL describing the rectangle in which to draw.
 *  pRectWBounds    LPRECTL describing the placement rectangle if part
 *                  of what you draw is another metafile.
 *  pfnContinue     Function to call periodically during long repaints.
 *  dwContinue      DWORD extra information to pass to the pfnContinue.
 *
 * Return Value:
 *  HRESULT         NOERROR on success, error code otherwise.
 */

STDMETHODIMP CImpIViewObject::Draw(DWORD dwAspect, LONG lindex
    , void FAR * pvAspect, DVTARGETDEVICE FAR * ptd, HDC hICDev
    , HDC hDC, const LPRECTL pRectBounds, const LPRECTL pRectWBounds
    , BOOL (CALLBACK * pfnContinue) (DWORD), DWORD dwContinue)
    {

    return NOERROR;
    }




/*
 * CImpIViewObject::GetColorSet
 *
 * Purpose:
 *
 * Parameters:
 *  dwAspect        DWORD aspect of interest.
 *  lindex          LONG piece of interest.
 *  pvAspect        LPVOID containing extra information, always NULL.
 *  ptd             DVTARGETDEVICE FAR * containing device information.
 *  hICDev          HDC containing the IC for the device.
 *  ppColorSet      LPLOGPALETTE FAR * into which to return the pointer
 *                  to the palette in this color set.
 *
 * Return Value:
 *  HRESULT         NOERROR on success, error code otherwise.
 */

STDMETHODIMP CImpIViewObject::GetColorSet(DWORD dwDrawAspect, LONG lindex
    , LPVOID pvAspect, DVTARGETDEVICE FAR * ptd
    , HDC hICDev, LPLOGPALETTE FAR * ppColorSet)
    {
    return ResultFromScode(E_NOTIMPL);
    }






/*
 * CImpIViewObject::Freeze
 *
 * Purpose:
 *
 *
 *
 * Parameters:
 *  dwAspect        DWORD aspect to freeze.
 *  lindex          LONG piece index under consideration.
 *  pvAspect        LPVOID for further information, always NULL.
 *  pdwFreeze       LPDWORD in which to return the key.
 *
 * Return Value:
 *  HRESULT         NOERROR on success, error code otherwise.
 */

STDMETHODIMP CImpIViewObject::Freeze(DWORD dwAspect, LONG lindex
    , LPVOID pvAspect, LPDWORD pdwFreeze)
    {
    return NOERROR;
    }






/*
 * CImpIViewObject::Unfreeze
 *
 * Purpose:
 *  Thaws an aspect frozen in ::Freeze.
 *
 * Parameters:
 *  dwFreeze        DWORD key returned from ::Freeze.
 *
 * Return Value:
 *  HRESULT         NOERROR on success, error code otherwise.
 */

STDMETHODIMP CImpIViewObject::Unfreeze(DWORD dwFreeze)
    {
    return NOERROR;
    }





/*
 * CImpIViewObject::SetAdvise
 *
 * Purpose:
 *  Provides an advise sink to the view object enabling notifications
 *  for a specific aspect.
 *
 * Parameters:
 *  dwAspects       DWORD describing the aspects of interest.
 *  dwAdvf          DWORD containing advise flags.
 *  pIAdviseSink    LPADVISESINK to notify.
 *
 * Return Value:
 *  HRESULT         NOERROR on success, error code otherwise.
 */

STDMETHODIMP CImpIViewObject::SetAdvise(DWORD dwAspects, DWORD dwAdvf
    , LPADVISESINK pIAdviseSink)
    {
    return NOERROR;
    }




/*
 * CImpIViewObject::GetAdvise
 *
 * Purpose:
 *  Returns the last known IAdviseSink seen by ::SetAdvise.
 *
 * Parameters:
 *  pdwAspects      LPDWORD in which to store the last requested aspects.
 *  pdwAdvf         LPDWORD in which to store the last requested flags.
 *  ppIAdvSink      LPADVISESINK FAR * in which to store the IAdviseSink.
 *
 * Return Value:
 *  HRESULT         NOERROR on success, error code otherwise.
 */

STDMETHODIMP CImpIViewObject::GetAdvise(DWORD FAR* pAspects
    , DWORD FAR* pAdvf, LPADVISESINK FAR* ppAdvSink)
    {
    return NOERROR;
    }
