/*
 * STDEMO.C
 * StatStrip Test Version 1.00, March 1993
 *
 * Main entry code for application.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#include <windows.h>
#include <commdlg.h>
#include <memory.h>
#include <stastrip.h>
#include "stdemo.h"




/*
 * WinMain
 *
 * Purpose:
 *  Main entry point of application.
 */

int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hInstPrev
    , LPSTR pszCmdLine, int nCmdShow)
    {
    MSG         msg;
    BOOL        fSuccess=TRUE;
    PAPPVARS    pAV;

    //Attempt to allocate and initialize the application
    pAV=AppPAllocate(&fSuccess, hInst, hInstPrev, pszCmdLine, nCmdShow);

    if (NULL==pAV || !fSuccess)
        return (int)AppPFree(pAV);

    while (GetMessage(&msg, NULL, 0,0 ))
        {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
        }

    AppPFree(pAV);
    return msg.wParam;
    }





/*
 * StatDemoWndProc
 *
 * Purpose:
 *  Window class procedure.  Standard callback.
 */

LRESULT FAR PASCAL StatDemoWndProc(HWND hWnd, UINT iMsg
    , WPARAM wParam, LPARAM lParam)
    {
    PAPPVARS    pAV;
    char        szTemp[128];
    UINT        dx, dy;
    CHOOSEFONT  cf;
    LOGFONT     lf;
    HFONT       hFontT;

    COMMANDPARAMS(wID, wCode, hWndMsg);

    //This will be valid for all messages except WM_NCCREATE
    pAV=(PAPPVARS)GetWindowWord(hWnd, 0);

    switch (iMsg)
        {
        case WM_NCCREATE:
            //CreateWindow passed pAV to us.
            pAV=(PAPPVARS)((LONG)((LPCREATESTRUCT)lParam)->lpCreateParams);

            //Store with the window--UINT converts to 32-bits.
            SetWindowWord(hWnd, 0, (UINT)pAV);
            return (DefWindowProc(hWnd, iMsg, wParam, lParam));


        case WM_DESTROY:
            PostQuitMessage(0);
            break;


        case WM_COMMAND:
            switch (wID)
                {
                case IDM_MESSAGESET:
                    SetWindowText(pAV->hWndST, "This is a message");
                    break;

                case IDM_MESSAGEGET:
                    GetWindowText(pAV->hWndST, szTemp, sizeof(szTemp));
                    MessageBox(hWnd, szTemp, "StatStrip Message", MB_OK);
                    break;

                case IDM_MESSAGEGETLENGTH:
                    dx=GetWindowTextLength(pAV->hWndST);
                    wsprintf(szTemp, "Length=%d", dx);
                    MessageBox(hWnd, szTemp, "StatStrip Message Length", MB_OK);
                    break;


                case IDM_MESSAGEENABLE:
                    EnableWindow(pAV->hWndST, TRUE);
                    break;


                case IDM_MESSAGEDISABLE:
                    EnableWindow(pAV->hWndST, FALSE);
                    break;


                case IDM_MESSAGESETFONT:
                    hFontT=(HFONT)SendMessage(pAV->hWndST, WM_GETFONT, 0, 0L);

                    memset(&cf, 0, sizeof(CHOOSEFONT));
                    memset(&lf, 0, sizeof(LOGFONT));
                    GetObject(hFontT, sizeof(LOGFONT), (LPVOID)&lf);

                    cf.lStructSize=sizeof(CHOOSEFONT);
                    cf.hwndOwner=hWnd;
                    cf.lpLogFont=&lf;
                    cf.Flags=CF_SCREENFONTS | CF_INITTOLOGFONTSTRUCT;

                    if (ChooseFont(&cf))
                        {
                        hFontT=pAV->hFont;

                        pAV->hFont=CreateFontIndirect(&lf);

                        if (NULL!=pAV->hFont)
                            {
                            SendMessage(pAV->hWndST, WM_SETFONT
                                , (WPARAM)pAV->hFont, 1L);

                            if (NULL!=hFontT && IsGDIObject(hFontT))
                            DeleteObject(hFontT);
                            }
                        else
                            pAV->hFont=hFontT;
                        }

                    break;
                }
            break;


        case WM_MENUSELECT:
            StatStripMenuSelect(pAV->hWndST, wParam, lParam);
            break;


        case WM_SIZE:
            dx=LOWORD(lParam);
            dy=HIWORD(lParam);

            //Change the StatStrip's size and position
            SetWindowPos(pAV->hWndST, NULL, 0, dy-CYSTATSTRIP, dx, CYSTATSTRIP, SWP_NOZORDER);
            break;


        default:
            return (DefWindowProc(hWnd, iMsg, wParam, lParam));
        }

    return 0L;
    }
