/*
 * ENUM.C
 *
 * Example enumerator interface user in C
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#include <windows.h>
#include <malloc.h>
#include "enumc.h"




/*
 * WinMain
 *
 * Purpose:
 *  Main entry point of application.
 */

int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hInstPrev
    , LPSTR pszCmdLine, int nCmdShow)
    {
    MSG         msg;
    LPAPPVARS   pAV;

    //Create and initialize the application.
    pAV=AppVarsConstructor(hInst, hInstPrev, nCmdShow);

    if (NULL==pAV)
        return -1;

    if (AppVarsFInit(pAV))
        {
        while (GetMessage(&msg, NULL, 0,0 ))
            {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
            }
        }

    AppVarsDestructor(pAV);
    return msg.wParam;
    }







/*
 * EnumWndProc
 *
 * Purpose:
 *  Standard window class procedure.
 */

LRESULT FAR PASCAL __export EnumWndProc(HWND hWnd, UINT iMsg
    , WPARAM wParam, LPARAM lParam)
    {
    LPAPPVARS   pAV;
    RECT        rc;
    DWORD       cRect;

    COMMANDPARAMS(wID, wCode, hWndMsg);

    //This will be valid for all messages except WM_NCCREATE
    pAV=(LPAPPVARS)GetWindowLong(hWnd, ENUMWL_STRUCTURE);

    switch (iMsg)
        {
        case WM_NCCREATE:
            //CreateWindow passed pAV to us.
            pAV=(LPAPPVARS)((LONG)((LPCREATESTRUCT)lParam)->lpCreateParams);

            SetWindowLong(hWnd, ENUMWL_STRUCTURE, (LONG)pAV);
            return (DefWindowProc(hWnd, iMsg, wParam, lParam));


        case WM_DESTROY:
            PostQuitMessage(0);
            break;


        case WM_COMMAND:
            switch (wID)
                {
                case IDM_ENUMCREATE:
                    if (NULL!=pAV->m_pIEnumRect)
                        pAV->m_pIEnumRect->lpVtbl->Release(pAV->m_pIEnumRect);

                    CreateRECTEnumerator(&pAV->m_pIEnumRect);
                    break;


                case IDM_ENUMRELEASE:
                    if (NULL==pAV->m_pIEnumRect)
                        break;

                    if (0==pAV->m_pIEnumRect->lpVtbl->Release(pAV->m_pIEnumRect))
                        pAV->m_pIEnumRect=NULL;

                    break;


                case IDM_ENUMRUNTHROUGH:
                    if (NULL==pAV->m_pIEnumRect)
                        break;

                    while (pAV->m_pIEnumRect->lpVtbl->Next(pAV->m_pIEnumRect
                        , 1, &rc, &cRect))
                        ;

                    break;


                case IDM_ENUMEVERYTHIRD:
                    if (NULL==pAV->m_pIEnumRect)
                        break;

                    while (pAV->m_pIEnumRect->lpVtbl->Next(pAV->m_pIEnumRect
                        , 1, &rc, &cRect))
                        {
                        if (!pAV->m_pIEnumRect->lpVtbl->Skip(pAV->m_pIEnumRect, 2))
                            break;
                        }
                    break;


                case IDM_ENUMRESET:
                    if (NULL==pAV->m_pIEnumRect)
                        break;

                    pAV->m_pIEnumRect->lpVtbl->Reset(pAV->m_pIEnumRect);
                    break;


                case IDM_ENUMEXIT:
                    PostMessage(hWnd, WM_CLOSE, 0, 0L);
                    break;
                }
            break;

        default:
            return (DefWindowProc(hWnd, iMsg, wParam, lParam));
        }

    return 0L;
    }




/*
 * AppVarsConstructor
 *
 * Purpose:
 *  Constructor for the APPVARS structure that just stores vital application
 *  information in the class structure.  Initialization prone to failure
 *  happens in CAppVars::Init.
 *
 * Parameters:
 *  hInst           HINSTANCE of the Application from WinMain
 *  hInstPrev       HINSTANCE of a previous instance from WinMain
 *  nCmdShow        UINT specifying how to show the app window, from WinMain.
 *
 * Return Value:
 *  LPAPPVARS       Pointer to usable APPVARS structure or NULL.
 */

LPAPPVARS AppVarsConstructor(HINSTANCE hInst, HINSTANCE hInstPrev
    , UINT nCmdShow)
    {
    LPAPPVARS       pAV;

    pAV=(LPAPPVARS)_fmalloc(sizeof(APPVARS));

    if (NULL==pAV)
        return NULL;

    //Initialize WinMain parameter holders.
    pAV->m_hInst     =hInst;
    pAV->m_hInstPrev =hInstPrev;
    pAV->m_nCmdShow  =nCmdShow;

    pAV->m_hWnd=NULL;
    pAV->m_pIEnumRect=NULL;

    return pAV;
    }







/*
 * AppVarsDestructor
 *
 * Purpose:
 *  AppVars destructor cleaning up any previous allocations.
 *
 * Parameters:
 *  pAV             LPAPPVARS to clean up.
 */

void AppVarsDestructor(LPAPPVARS pAV)
    {
    //Free any object we still hold on to
    if (NULL!=pAV->m_pIEnumRect)
        pAV->m_pIEnumRect->lpVtbl->Release(pAV->m_pIEnumRect);

    if (IsWindow(pAV->m_hWnd))
        DestroyWindow(pAV->m_hWnd);

    _ffree((LPVOID)pAV);

    return;
    }







/*
 * AppVarsFInit
 *
 * Purpose:
 *  Initializes an APPVARS structure by registering window classes,
 *  creating the main window, and doing anything else prone to failure.
 *  If this function fails the caller should guarantee that the destructor
 *  is called.
 *
 * Parameters:
 *  pAV             LPAPPVARS to initialize.
 *
 * Return Value:
 *  BOOL            TRUE if successful, FALSE otherwise.
 */

BOOL AppVarsFInit(LPAPPVARS pAV)
    {
    WNDCLASS    wc;


    //Register our window classes.
    if (!pAV->m_hInstPrev)
        {
        wc.style          = CS_HREDRAW | CS_VREDRAW;
        wc.lpfnWndProc    = (WNDPROC)EnumWndProc;
        wc.cbClsExtra     = 0;
        wc.cbWndExtra     = CBWNDEXTRA;
        wc.hInstance      = pAV->m_hInst;
        wc.hIcon          = LoadIcon(pAV->m_hInst, "Icon");
        wc.hCursor        = LoadCursor(NULL, IDC_ARROW);
        wc.hbrBackground  = (HBRUSH)(COLOR_WINDOW + 1);
        wc.lpszMenuName   = MAKEINTRESOURCE(IDR_MENU);
        wc.lpszClassName  = "CEnum";

        if (!RegisterClass(&wc))
            return FALSE;
        }

    //Create the main window.
    pAV->m_hWnd=CreateWindow("CEnum", "Enumerator in C"
        , WS_MINIMIZEBOX | WS_OVERLAPPEDWINDOW
        ,35, 35, 350, 250, NULL, NULL, pAV->m_hInst, pAV);

    if (NULL==pAV->m_hWnd)
        return FALSE;

    ShowWindow(pAV->m_hWnd, pAV->m_nCmdShow);
    UpdateWindow(pAV->m_hWnd);

    return TRUE;
    }
