/*
 * ENUM.H
 *
 * Definitions, structures, and prototypes for Enumerator interface
 * example implemented in C.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _ENUM_H_
#define _ENUM_H_


#include <ienum0.h>      //Found in shared include directory.
#include <win1632.h>


//Menu Resource ID and Commands
#define IDR_MENU                    1

#define IDM_ENUMCREATE              100
#define IDM_ENUMRELEASE             101
#define IDM_ENUMRUNTHROUGH          102
#define IDM_ENUMEVERYTHIRD          103
#define IDM_ENUMRESET               104
#define IDM_ENUMEXIT                105



//ENUM.C
LRESULT FAR PASCAL __export EnumWndProc(HWND, UINT, WPARAM, LPARAM);

typedef struct tagAPPVARS
    {
    HINSTANCE       m_hInst;            //WinMain parameters
    HINSTANCE       m_hInstPrev;
    UINT            m_nCmdShow;

    HWND            m_hWnd;             //Main window handle
    LPENUMRECT      m_pIEnumRect;       //Enumerator interface we have.
    } APPVARS, FAR * LPAPPVARS;


LPAPPVARS AppVarsConstructor(HINSTANCE, HINSTANCE, UINT);
void      AppVarsDestructor(LPAPPVARS);
BOOL      AppVarsFInit(LPAPPVARS);


#define CBWNDEXTRA          sizeof(LONG)
#define ENUMWL_STRUCTURE    0


//Number of rectangles that objects with IEnumRECT support (for demo)
#define CRECTS      15


/*
 * In C we make a class by reusing the elements of IEnumRECT
 * thereby inheriting from it, albeit manually.
 */
typedef struct tagIMPIENUMRECT
    {
    IEnumRECTVtbl FAR * lpVtbl;
    DWORD           m_cRef;         //Interface reference count.
    DWORD           m_iCur;         //Current enumeration position
    RECT            m_rgrc[CRECTS]; //Rectangles we contain for enumeration
    } IMPIENUMRECT, FAR * LPIMPIENUMRECT;


/*
 * And, of course, in C we have to separately declare member functions
 * with globally unique names, so prefixing with the class name should
 * remove any conflicts.
 */

LPIMPIENUMRECT  IMPIEnumRect_Constructor(void);
void            IMPIEnumRect_Destructor(LPIMPIENUMRECT);

DWORD           IMPIEnumRect_AddRef(LPENUMRECT);
DWORD           IMPIEnumRect_Release(LPENUMRECT);
BOOL            IMPIEnumRect_Next(LPENUMRECT, DWORD, LPRECT, LPDWORD);
BOOL            IMPIEnumRect_Skip(LPENUMRECT, DWORD);
void            IMPIEnumRect_Reset(LPENUMRECT);


//Function that creates one of these objects
BOOL CreateRECTEnumerator(LPENUMRECT FAR *);


#endif //_ENUM_H_
