/*
 * DKOALA.H
 *
 * Definitions, classes, and prototypes for a DLL that
 * provides Koala objects to any other object user.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _DKOALA_H_
#define _DKOALA_H_


//Get the object definitions that also includes windows.h, et. al.
#include "koala.h"


void FAR PASCAL ObjectDestroyed(void);


//DKOALA.CPP
//This class factory object creates Koala objects.

class __far CKoalaClassFactory : public IClassFactory
    {
    protected:
        ULONG           m_cRef;         //Reference count on class object

    public:
        CKoalaClassFactory(void);
        ~CKoalaClassFactory(void);

        //IUnknown members
        STDMETHODIMP         QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //IClassFactory members
        STDMETHODIMP         CreateInstance(LPUNKNOWN, REFIID, LPVOID FAR *);
        STDMETHODIMP         LockServer(BOOL);
    };

typedef CKoalaClassFactory FAR * LPCKoalaClassFactory;


#endif //_DKOALA_H_
