/*
 * KOALA.H
 *
 * Classes that implement the Koala object independent of whether
 * we live in a DLL or EXE.
 *
 * Copyright (c)1993 Microsoft Corporation, All Right Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _KOALA_H_
#define _KOALA_H_


#include <windows.h>
#include <ole2.h>       //ole2.h has IPersist, compobj.h doesn't

//This defines all GUIDs used in this book so we can track them easily.
#include <bookguid.h>


//Type for an object-destroyed callback
typedef void (FAR PASCAL *LPFNDESTROYED)(void);



/*
 * The Koala object is implemented in its own class with its own
 * IUnknown to support aggregation.  It contains one CImpIPersist
 * object that we use to implement the externally exposed interfaces.
 */

class __far CKoala : public IUnknown
    {
    //Make any contained interfaces your friends so they can get at you
    friend class CImpIPersist;

    protected:
        ULONG           m_cRef;         //Object reference count.
        LPUNKNOWN       m_punkOuter;    //Controlling Unknown for aggregation

        LPFNDESTROYED   m_pfnDestroy;   //Function to call on closure.
        LPPERSIST       m_pIPersist;    //Contained interface implemetation

    public:
        CKoala(LPUNKNOWN, LPFNDESTROYED);
        ~CKoala(void);

        BOOL FInit(void);

        //Non-delegating object IUnknown
        STDMETHODIMP         QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);
    };

typedef CKoala FAR * LPCKoala;


/*
 * Interface implementations for the CKoala object.
 */

class __far CImpIPersist : public IPersist
    {
    private:
        ULONG           m_cRef;         //Interface reference count.
        LPVOID          m_pObj;         //Back pointer to the object.
        LPUNKNOWN       m_punkOuter;    //Controlling unknown for delegation

    public:
        CImpIPersist(LPVOID, LPUNKNOWN);
        ~CImpIPersist(void);

        //IUnknown members that delegate to m_punkOuter.
        STDMETHODIMP         QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //IPersist members
        STDMETHODIMP         GetClassID(LPCLSID);
    };


typedef CImpIPersist FAR * LPIMPIPERSIST;


#endif //_KOALA_H_
