/*
 * EKOALA.H
 *
 * Definitions, classes, and prototypes for an application that
 * provides Koala objects to any other object user.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _EKOALA_H_
#define _EKOALA_H_


//Get the object definitions that also includes windows.h, et. al.
#include "koala.h"


//EKOALA.CPP
LRESULT FAR PASCAL __export KoalaWndProc(HWND, UINT, WPARAM, LPARAM);

class __far CAppVars
    {
    friend LRESULT FAR PASCAL __export KoalaWndProc(HWND, UINT, WPARAM, LPARAM);

    protected:
        HINSTANCE       m_hInst;            //WinMain parameters
        HINSTANCE       m_hInstPrev;
        LPSTR           m_pszCmdLine;
        UINT            m_nCmdShow;

        HWND            m_hWnd;             //Main window handle

        BOOL            m_fInitialized;     //Did CoInitialize work?
        LPCLASSFACTORY  m_pIClassFactory;   //The class factory we own.
        DWORD           m_dwRegCO;          //Key from CoRegisterClassObject.

    public:
        CAppVars(HINSTANCE, HINSTANCE, LPSTR, UINT);
        ~CAppVars(void);
        BOOL FInit(void);
    };


typedef CAppVars FAR * LPAPPVARS;

#define CBWNDEXTRA              sizeof(LONG)
#define KOALAWL_STRUCTURE     0


void FAR PASCAL ObjectDestroyed(void);



//This class factory object creates Koala objects.

class __far CKoalaClassFactory : public IClassFactory
    {
    protected:
        ULONG           m_cRef;         //Reference count on class object

    public:
        CKoalaClassFactory(void);
        ~CKoalaClassFactory(void);

        //IUnknown members
        STDMETHODIMP         QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //IClassFactory members
        STDMETHODIMP         CreateInstance(LPUNKNOWN, REFIID, LPVOID FAR *);
        STDMETHODIMP         LockServer(BOOL);
    };

typedef CKoalaClassFactory FAR * LPCKoalaClassFactory;


#endif //_EKOALA_H_
