/*
 * MALLOC.CPP
 *
 * Demostration of IMalloc object use.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#include <windows.h>
#include <ole2.h>
#include <initguid.h>
#include <ole2ver.h>
#include "malloc.h"


/*
 * WinMain
 *
 * Purpose:
 *  Main entry point of application.
 */

int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hInstPrev
    , LPSTR pszCmdLine, int nCmdShow)
    {
    MSG         msg;
    LPAPPVARS   pAV;

   #ifdef WIN32
    //Recommended for all OLE 2.0 applications.
    SetMessageQueue(96);
   #endif

    //Create and initialize the application.
    pAV=new CAppVars(hInst, hInstPrev, nCmdShow);

    if (NULL==pAV)
        return -1;

    if (pAV->FInit())
        {
        while (GetMessage(&msg, NULL, 0,0 ))
            {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
            }
        }

    delete pAV;
    return msg.wParam;
    }







/*
 * MallocWndProc
 *
 * Purpose:
 *  Standard window class procedure.
 */

LRESULT FAR PASCAL __export MallocWndProc(HWND hWnd, UINT iMsg
    , WPARAM wParam, LPARAM lParam)
    {
    LPAPPVARS       pAV;
    LPVOID          pv;
    ULONG           cb;
    UINT            i;
    BOOL            fResult=TRUE;
    HRESULT         hr;

    //This will be valid for all messages except WM_NCCREATE
    pAV=(LPAPPVARS)GetWindowLong(hWnd, MALLOCWL_STRUCTURE);

    switch (iMsg)
        {
        case WM_NCCREATE:
            //CreateWindow passed pAV to us.
            pAV=(LPAPPVARS)((LONG)((LPCREATESTRUCT)lParam)->lpCreateParams);

            SetWindowLong(hWnd, MALLOCWL_STRUCTURE, (LONG)pAV);
            return (DefWindowProc(hWnd, iMsg, wParam, lParam));

        case WM_DESTROY:
            PostQuitMessage(0);
            break;

        case WM_COMMAND:
            switch (LOWORD(wParam))
                {
                case IDM_IMALLOCCOGETMALLOCTASK:
                    pAV->FreeAllocations(TRUE);

                    hr=CoGetMalloc(MEMCTX_TASK, &pAV->m_pIMalloc);
                    fResult=SUCCEEDED(hr);

                    MessageBox(hWnd, ((fResult) ? "CoGetMalloc(task) succeeded."
                        : "CoGetMalloc(task) failed."), "Malloc", MB_OK);

                    break;


                case IDM_IMALLOCCOGETMALLOCSHARED:
                    pAV->FreeAllocations(TRUE);
                    hr=CoGetMalloc(MEMCTX_SHARED, &pAV->m_pIMalloc);
                    fResult=SUCCEEDED(hr);

                    MessageBox(hWnd, ((fResult) ? "CoGetMalloc(shared) succeeded."
                        : "CoGetMalloc(shared) failed."), "Malloc", MB_OK);
                    break;


                case IDM_IMALLOCRELEASE:
                    pAV->FreeAllocations(TRUE);
                    break;


                case IDM_IMALLOCALLOC:
                    if (NULL==pAV->m_pIMalloc)
                        break;

                    pAV->FreeAllocations(FALSE);

                    for (i=0; i < CALLOCS; i++)
                        {
                        LPBYTE    pb;
                        ULONG     iByte;

                        cb=pAV->m_rgcb[i];
                        pAV->m_rgpv[i]=pAV->m_pIMalloc->Alloc(cb);

                        //Fill the memory with letters.
                        pb=(LPBYTE)pAV->m_rgpv[i];

                        if (NULL!=pb)
                            {
                            for (iByte=0; iByte < cb; iByte++)
                                *pb++=('a'+i);
                            }

                        fResult &= (NULL!=pAV->m_rgpv[i]);
                        }

                    MessageBox(hWnd, ((fResult) ? "IMalloc::Alloc succeeded."
                        : "IMalloc::Alloc failed."), "Malloc", MB_OK);
                    break;


                case IDM_IMALLOCFREE:
                    pAV->FreeAllocations(FALSE);

                    MessageBox(hWnd, "IMalloc::Free finished.", "Malloc", MB_OK);
                    break;


                case IDM_IMALLOCREALLOC:
                    if (NULL==pAV->m_pIMalloc)
                        break;

                    for (i=0; i < CALLOCS; i++)
                        {
                        LPBYTE      pb;
                        ULONG       iByte;

                        pAV->m_rgcb[i]+=128;

                        //Old memory is not freed is Realloc fails here.
                        pv=pAV->m_pIMalloc->Realloc(pAV->m_rgpv[i]
                            , pAV->m_rgcb[i]);

                        if (NULL!=pv)
                            {
                            pAV->m_rgpv[i]=pv;

                            //Fill the new memory with something we can see.
                            pb=(LPBYTE)pAV->m_rgpv[i];
                            cb=pAV->m_rgcb[i];

                            if (NULL!=pb)
                                {
                                for (iByte=cb-128; iByte < cb; iByte++)
                                    *pb++=('a'+i);
                                }
                            }
                        else
                            fResult=FALSE;
                        }

                    MessageBox(hWnd, ((fResult) ? "IMalloc::Realloc succeeded."
                        : "IMalloc::Realloc failed."), "Malloc", MB_OK);


                    break;


                case IDM_IMALLOCGETSIZE:
                    if (NULL==pAV->m_pIMalloc)
                        break;

                    for (i=0; i < CALLOCS; i++)
                        {
                        cb=pAV->m_pIMalloc->GetSize(pAV->m_rgpv[i]);

                        //We test that the size is *at least* what we wanted.
                        fResult &= (pAV->m_rgcb[i] <= cb);
                        }

                    MessageBox(hWnd, ((fResult) ? "IMalloc::GetSize matched."
                        : "IMalloc::GetSize mismatch."), "Malloc", MB_OK);

                    break;


                case IDM_IMALLOCDIDALLOC:
                    if (NULL==pAV->m_pIMalloc)
                        break;

                    /*
                     * DidAlloc may return -1 if it does not know whether
                     * or not it actually allocated something.  In that
                     * case we just blindly & in a -1 with no affect.
                     */
                    for (i=0; i < CALLOCS; i++)
                        fResult &= pAV->m_pIMalloc->DidAlloc(pAV->m_rgpv[i]);

                    MessageBox(hWnd, ((fResult) ? "IMalloc::DidAlloc is TRUE."
                        : "IMalloc::DidAlloc is FALSE."), "Malloc", MB_OK);

                    break;


                case IDM_IMALLOCHEAPMINIMIZE:
                    if (NULL!=pAV->m_pIMalloc)
                        pAV->m_pIMalloc->HeapMinimize();

                    MessageBox(hWnd, "IMalloc::HeapMinimize finished."
                        , "Malloc", MB_OK);

                    break;


                case IDM_IMALLOCEXIT:
                    PostMessage(hWnd, WM_CLOSE, 0, 0L);
                    break;
                }
            break;

        default:
            return (DefWindowProc(hWnd, iMsg, wParam, lParam));
        }

    return 0L;
    }





/*
 * CAppVars::CAppVars
 * CAppVars::~CAppVars
 *
 * Constructor Parameters: (from WinMain)
 *  hInst           HINSTANCE of the application.
 *  hInstPrev       HINSTANCE of a previous instance.
 *  nCmdShow        UINT specifying how to show the app window.
 */

CAppVars::CAppVars(HINSTANCE hInst, HINSTANCE hInstPrev, UINT nCmdShow)
    {
    UINT        i;
    ULONG       cb;

    m_hInst       =hInst;
    m_hInstPrev   =hInstPrev;
    m_nCmdShow    =nCmdShow;

    m_hWnd        =NULL;
    m_pIMalloc    =NULL;
    m_fInitialized=FALSE;


    /*
     * 100 is arbitrary--the task IMalloc can handle in indivudal allocs
     * from 0 to 65535 bytes.  The shared IMalloc can handle larger size
     * since it uses GlobalAlloc.
     */

    cb=100;

    for (i=0; i < CALLOCS; i++)
        {
        m_rgcb[i]=cb;
        m_rgpv[i]=NULL;

        cb*=2;
        }

    return;
    }



CAppVars::~CAppVars(void)
    {
    FreeAllocations(TRUE);

    if (m_fInitialized)
        CoUninitialize();

    return;
    }







/*
 * CAppVars::FInit
 *
 * Purpose:
 *  Initializes an CAppVars object by registering window classes,
 *  creating the main window, and doing anything else prone to failure
 *  such as calling CoInitialize.  If this function fails the caller
 *  should insure that the destructor is called.
 *
 * Parameters:
 *  None
 *
 * Return Value:
 *  BOOL            TRUE if successful, FALSE otherwise.
 */

BOOL CAppVars::FInit(void)
    {
    WNDCLASS    wc;
    DWORD       dwVer;

    //Make sure COMPOBJ.DLL is the right version
    dwVer=CoBuildVersion();

    if (rmm!=HIWORD(dwVer))
        return FALSE;

    //Call CoInitialize so we can call other Co* functions
    if (FAILED(CoInitialize(NULL)))
        return FALSE;

    m_fInitialized=TRUE;

    //Register our window classes.
    if (!m_hInstPrev)
        {
        wc.style          = CS_HREDRAW | CS_VREDRAW;
        wc.lpfnWndProc    = MallocWndProc;
        wc.cbClsExtra     = 0;
        wc.cbWndExtra     = CBWNDEXTRA;
        wc.hInstance      = m_hInst;
        wc.hIcon          = LoadIcon(m_hInst, "Icon");
        wc.hCursor        = LoadCursor(NULL, IDC_ARROW);
        wc.hbrBackground  = (HBRUSH)(COLOR_WINDOW + 1);
        wc.lpszMenuName   = MAKEINTRESOURCE(IDR_MENU);
        wc.lpszClassName  = "MALLOC";

        if (!RegisterClass(&wc))
            return FALSE;
        }

    //Create the main window.
    m_hWnd=CreateWindow("MALLOC", "IMalloc Object Demo"
        , WS_OVERLAPPEDWINDOW, 35, 35, 350, 250, NULL, NULL, m_hInst, this);

    if (NULL==m_hWnd)
        return FALSE;

    ShowWindow(m_hWnd, m_nCmdShow);
    UpdateWindow(m_hWnd);

    return TRUE;
    }



/*
 * CAppVars::FreeAllocations
 *
 * Purpose:
 *  Centralized place to clean up allocations made on the current IMalloc.
 *
 * Parameters:
 *  fRelease        BOOL indicating if we're to IMalloc::Release as well.
 *
 * Return Value:
 *  None
 */

void CAppVars::FreeAllocations(BOOL fRelease)
    {
    UINT    i;

    if (NULL==m_pIMalloc)
        return;

    for (i=0; i < CALLOCS; i++)
        {
        if (NULL!=m_rgpv[i])
            m_pIMalloc->Free(m_rgpv[i]);

        m_rgpv[i]=NULL;
        }

    if (fRelease)
        {
        m_pIMalloc->Release();
        m_pIMalloc=NULL;
        }

    return;
    }
