/*
 * POLYLINE.H
 *
 * Definitions and function prototypes for the PolyLine DLL object.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _POLYLINE_H_
#define _POLYLINE_H_

#include <windows.h>
#include <ole2.h>
#include <bookguid.h>

//Pull in the interface and interface definitions
#include <ipoly4.h>


//Classname
#define SZCLASSPOLYLINE             "polyline"

#define HIMETRIC_PER_INCH           2540

//Window extra bytes and offsets
#define CBPOLYLINEWNDEXTRA          (sizeof(LONG))
#define PLWL_STRUCTURE              0


//DLLPOLY.CPP

//This class factory object creates Polyline objects.

class __far CPolylineClassFactory : public IClassFactory
    {
    protected:
        ULONG           m_cRef;         //Reference count on object

    public:
        CPolylineClassFactory(void);
        ~CPolylineClassFactory(void);

        //IUnknown members
        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //IClassFactory members
        STDMETHODIMP         CreateInstance(LPUNKNOWN, REFIID, LPVOID FAR *);
        STDMETHODIMP         LockServer(BOOL);
    };

typedef CPolylineClassFactory FAR * LPCPolylineClassFactory;



//POLYWIN.CPP
LRESULT __export FAR PASCAL PolylineWndProc(HWND, UINT, WPARAM, LPARAM);


//Type for an object-destroyed callback
typedef void (FAR PASCAL *LPFNDESTROYED)(void);



//POLYLINE.CPP
class __far CPolyline : public IUnknown
    {
    friend LRESULT __export FAR PASCAL PolylineWndProc(HWND, UINT, WPARAM, LPARAM);

    //Make any contained interfaces your friends so they can get at privates
    friend class CImpIPolyline;

    protected:
        HWND            m_hWnd;
        HINSTANCE       m_hInst;

        ULONG           m_cRef;         //Object reference count.
        LPUNKNOWN       m_punkOuter;    //Controlling Unknown for aggregation
        LPFNDESTROYED   m_pfnDestroy;   //Function to call on closure.
        BOOL            m_fDirty;       //Have we changed?
        POLYLINEDATA    m_pl;           //Our actual data.

        //Contained interfaces
        LPPOLYLINE      m_pIPolyline;

        LPPOLYLINEADVISESINK    m_pAdv;

    protected:
        void      PointScale(LPRECT, LPPOINT, BOOL);
        void      Draw(HDC, BOOL, BOOL);
        void      RectConvertMappings(LPRECT, BOOL);

    public:
        CPolyline(LPUNKNOWN, LPFNDESTROYED, HINSTANCE);
        ~CPolyline(void);

        BOOL      FInit(void);

        //Non-delegating object IUnknown
        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);
    };

typedef CPolyline FAR * LPCPolyline;




//Interface implementation contained in the Polyline.

class __far CImpIPolyline : public IPolyline4
    {
    protected:
        ULONG               m_cRef;      //Interface reference count.
        LPVOID              m_pObj;      //Back pointer to the object.
        LPUNKNOWN           m_punkOuter; //Controlling unknown for delegation.

    public:
        CImpIPolyline(LPVOID, LPUNKNOWN);
        ~CImpIPolyline(void);

        //IUnknown members.
        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //File-related members:
        STDMETHODIMP ReadFromFile(LPSTR);
        STDMETHODIMP WriteToFile (LPSTR);

        //Data transfer members:
        STDMETHODIMP DataSet(LPPOLYLINEDATA, BOOL, BOOL);
        STDMETHODIMP DataGet(LPPOLYLINEDATA);
        STDMETHODIMP DataSetMem(HGLOBAL, BOOL, BOOL, BOOL);
        STDMETHODIMP DataGetMem(HGLOBAL FAR *);

        STDMETHODIMP RenderBitmap(HBITMAP FAR *);
        STDMETHODIMP RenderMetafile(HMETAFILE FAR *);
        STDMETHODIMP RenderMetafilePict(HGLOBAL FAR *);

        //Manipulation members:
        STDMETHODIMP Init(HWND, LPRECT, DWORD, UINT);
        STDMETHODIMP New(void);
        STDMETHODIMP Undo(void);
        STDMETHODIMP Window(HWND FAR *);

        STDMETHODIMP SetAdvise(LPPOLYLINEADVISESINK);
        STDMETHODIMP GetAdvise(LPPOLYLINEADVISESINK FAR *);

        STDMETHODIMP RectGet(LPRECT);
        STDMETHODIMP SizeGet(LPRECT);
        STDMETHODIMP RectSet(LPRECT, BOOL);
        STDMETHODIMP SizeSet(LPRECT, BOOL);

        STDMETHODIMP ColorSet(UINT, COLORREF, COLORREF FAR *);
        STDMETHODIMP ColorGet(UINT, COLORREF FAR *);

        STDMETHODIMP LineStyleSet(UINT, UINT FAR *);
        STDMETHODIMP LineStyleGet(UINT FAR *);
    };

typedef CImpIPolyline * LPCImpIPolyline;


#endif  //_POLYLINE_H_
