/*
 * FREELOAD.CPP
 *
 * Freeloader application that uses the OLE 2.0 Default Object Handler
 * to provide free drawing and serialization services for bitmaps and
 * metafiles.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */



#define INITGUIDS
#include "freeload.h"


/*
 * WinMain
 *
 * Purpose:
 *  Main entry point of application.   Should register the app class
 *  if a previous instance has not done so and do any other one-time
 *  initializations.
 */

int PASCAL WinMain (HINSTANCE hInst, HINSTANCE hPrev, LPSTR pszCmdLine, int nCmdShow)
    {
    LPCFreeloaderFrame  pFR;
    FRAMEINIT           fi;
    WPARAM              wRet;

   #ifndef WIN32
    SetMessageQueue(96);
   #endif

    //Attempt to allocate and initialize the application
    pFR=new CFreeloaderFrame(hInst, hPrev, pszCmdLine, nCmdShow);

    fi.idsMin=IDS_STANDARDFRAMEMIN;
    fi.idsMax=IDS_STANDARDFRAMEMAX;
    fi.idsStatMin=IDS_STANDARDSTATMESSAGEMIN;
    fi.idsStatMax=IDS_STANDARDSTATMESSAGEMAX;
    fi.idStatMenuMin=ID_MENUFILE;
    fi.idStatMenuMax=ID_MENUHELP;
    fi.iPosWindowMenu=WINDOW_MENU;
    fi.cMenus=CMENUS;

    //If we can initialize pFR, start chugging messages
    if (pFR->FInit(&fi))
        wRet=pFR->MessageLoop();

    delete pFR;
    return wRet;
    }





/*
 * CFreeloaderFrame::CFreeloaderFrame
 * CFreeloaderFrame::~CFreeloaderFrame
 *
 * Constructor Parameters:
 *  hInst           HINSTANCE from WinMain
 *  hInstPrev       HINSTANCE from WinMain
 *  pszCmdLine      LPSTR from WinMain
 *  nCmdShow        int from WInMain
 */

CFreeloaderFrame::CFreeloaderFrame(HINSTANCE hInst, HINSTANCE hInstPrev
    , LPSTR pszCmdLine, int nCmdShow)
    : CFrame(hInst, hInstPrev, pszCmdLine, nCmdShow)
    {
    m_fInitialized=FALSE;
    return;
    }


CFreeloaderFrame::~CFreeloaderFrame(void)
    {
    if (m_fInitialized)
        OleUninitialize();

    return;
    }




/*
 * CFreeloaderFrame::FInit
 *
 * Purpose:
 *  Call CoInitialize then calling down into the base class
 *  initialization.
 *
 * Parameters:
 *  pFI             LPFRAMEINIT containing initialization parameters.
 *
 * Return Value:
 *  BOOL            TRUE if initialization succeeded, FALSE otherwise.
 */

BOOL CFreeloaderFrame::FInit(LPFRAMEINIT pFI)
    {
    DWORD       dwVer;

    dwVer=OleBuildVersion();

    if (rmm!=HIWORD(dwVer))
        return FALSE;

    if (FAILED(OleInitialize(NULL)))
        return FALSE;

    m_fInitialized=TRUE;

    return CFrame::FInit(pFI);
    }





/*
 * CFreeloaderFrame::CreateCClient
 *
 * Purpose:
 *  Constructs a new client specific to the application.
 *
 * Parameters:
 *  None
 *
 * Return Value:
 *  LPCClient       Pointer to the new client object.
 */

LPCClient CFreeloaderFrame::CreateCClient(void)
    {
    return (LPCClient)(new CFreeloaderClient(m_hInst));
    }
