/*
 * POLYLINE.H
 * Polyline Component Object Chapter 6
 *
 * Definitions and function prototypes for the PolyLine DLL object.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _POLYLINE_H_
#define _POLYLINE_H_

#include <windows.h>
#include <ole2.h>
#include <classlib.h>
#include <bookguid.h>
#include <ipoly6.h>
#include "resource.h"


//Classname
#define SZCLASSPOLYLINE             "polyline"

#define HIMETRIC_PER_INCH           2540

//Window extra bytes and offsets
#define CBPOLYLINEWNDEXTRA          (sizeof(LONG))
#define PLWL_STRUCTURE              0


//DLLPOLY.CPP

//This class factory object creates Polyline objects.

class __far CPolylineClassFactory : public IClassFactory
    {
    protected:
        ULONG           m_cRef;         //Reference count on object

    public:
        CPolylineClassFactory(void);
        ~CPolylineClassFactory(void);

        //IUnknown members
        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //IClassFactory members
        STDMETHODIMP         CreateInstance(LPUNKNOWN, REFIID, LPVOID FAR *);
        STDMETHODIMP         LockServer(BOOL);
    };

typedef CPolylineClassFactory FAR * LPCPolylineClassFactory;



//POLYWIN.CPP
LRESULT __export FAR PASCAL PolylineWndProc(HWND, UINT, WPARAM, LPARAM);


//Type for an object-destroyed callback
typedef void (FAR PASCAL *LPFNDESTROYED)(void);


#define CFORMATETCGET       3
#define CFORMATETCSET       1


//POLYLINE.CPP
class __far CPolyline : public IUnknown
    {
    friend LRESULT __export FAR PASCAL PolylineWndProc(HWND, UINT, WPARAM, LPARAM);

    //Make any contained interfaces your friends so they can get at privates
    friend class CImpIPolyline;
    friend class CImpIPersistStorage;
    friend class CImpIDataObject;

    protected:
        HWND            m_hWnd;
        HINSTANCE       m_hInst;

        ULONG           m_cRef;         //Object reference count.
        LPUNKNOWN       m_punkOuter;    //Controlling Unknown for aggregation
        LPFNDESTROYED   m_pfnDestroy;   //Function to call on closure.
        BOOL            m_fDirty;       //Have we changed?
        POLYLINEDATA    m_pl;           //Our actual data.

        LPCStringTable  m_pST;          //Object strings
        UINT            m_cf;           //Object clipboard format.
        CLSID           m_clsID;        //Current CLSID
        IID             m_iID;          //Custom interface IID.

        //Contained interfaces
        LPPOLYLINE          m_pIPolyline;
        LPPERSISTSTORAGE    m_pIPersistStorage;

        //CHAPTER6MOD
        LPDATAOBJECT        m_pIDataObject;
        LPDATAADVISEHOLDER  m_pIDataAdviseHolder;

        //Arrays for IDataObject::EnumFormatEtc
        ULONG               m_cfeGet;
        FORMATETC           m_rgfeGet[CFORMATETCGET];

        ULONG               m_cfeSet;
        FORMATETC           m_rgfeSet[CFORMATETCSET];

        //End CHAPTER6MOD

        LPPOLYLINEADVISESINK    m_pAdv;

    protected:
        void      PointScale(LPRECT, LPPOINT, BOOL);
        void      Draw(HDC, BOOL, BOOL);
        void      RectConvertMappings(LPRECT, BOOL);

        //CHAPTER6MOD
        /*
         * These members pulled from IPolyline now serve as a central
         * store for this functionality to be used from other interfaces
         * like IPersistStorage and IDataObject.  Other interfaces later
         * may also use them.
         */
        STDMETHODIMP DataSet(LPPOLYLINEDATA, BOOL, BOOL);
        STDMETHODIMP DataGet(LPPOLYLINEDATA);
        STDMETHODIMP DataSetMem(HGLOBAL, BOOL, BOOL, BOOL);

        STDMETHODIMP RenderNative(HGLOBAL FAR *);
        STDMETHODIMP RenderBitmap(HBITMAP FAR *);
        STDMETHODIMP RenderMetafilePict(HGLOBAL FAR *);
        //End CHAPTER6MOD

    public:
        CPolyline(LPUNKNOWN, LPFNDESTROYED, HINSTANCE);
        ~CPolyline(void);

        BOOL      FInit(void);

        //Non-delegating object IUnknown
        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);
    };

typedef CPolyline FAR * LPCPolyline;


//Interface implementation contained in the Polyline.

//IPOLYLIN.CPP
class __far CImpIPolyline : public IPolyline6
    {
    protected:
        ULONG               m_cRef;      //Interface reference count.
        LPVOID              m_pObj;      //Back pointer to the object.
        LPUNKNOWN           m_punkOuter; //Controlling unknown for delegation.

    public:
        CImpIPolyline(LPVOID, LPUNKNOWN);
        ~CImpIPolyline(void);

        //IUnknown members.
        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //CHAPTER6MOD
        //::Data* and ::Render* replaced with IDataObject
        //End CHAPTER6MOD

        //Manipulation members:
        STDMETHODIMP Init(HWND, LPRECT, DWORD, UINT);
        STDMETHODIMP New(void);
        STDMETHODIMP Undo(void);
        STDMETHODIMP Window(HWND FAR *);

        STDMETHODIMP SetAdvise(LPPOLYLINEADVISESINK);
        STDMETHODIMP GetAdvise(LPPOLYLINEADVISESINK FAR *);

        STDMETHODIMP RectGet(LPRECT);
        STDMETHODIMP SizeGet(LPRECT);
        STDMETHODIMP RectSet(LPRECT, BOOL);
        STDMETHODIMP SizeSet(LPRECT, BOOL);

        STDMETHODIMP ColorSet(UINT, COLORREF, COLORREF FAR *);
        STDMETHODIMP ColorGet(UINT, COLORREF FAR *);

        STDMETHODIMP LineStyleSet(UINT, UINT FAR *);
        STDMETHODIMP LineStyleGet(UINT FAR *);
    };

typedef CImpIPolyline * LPCImpIPolyline;


//IPersistStorage Interface implementation contained in the Polyline.

//IPERSTOR.CPP
class __far CImpIPersistStorage : public IPersistStorage
    {
    protected:
        ULONG               m_cRef;      //Interface reference count.
        LPVOID              m_pObj;      //Back pointer to the object.
        LPUNKNOWN           m_punkOuter; //Controlling unknown for delegation.

    public:
        CImpIPersistStorage(LPVOID, LPUNKNOWN);
        ~CImpIPersistStorage(void);

        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        STDMETHODIMP GetClassID(LPCLSID);

        STDMETHODIMP IsDirty(void);
        STDMETHODIMP InitNew(LPSTORAGE);
        STDMETHODIMP Load(LPSTORAGE);
        STDMETHODIMP Save(LPSTORAGE, BOOL);
        STDMETHODIMP SaveCompleted(LPSTORAGE);
        STDMETHODIMP HandsOffStorage(void);
    };



//IDataObject Interface implementation contained in the Polyline.
//IDATAOBJ.CPP
class __far CImpIDataObject : public IDataObject
    {
    private:
        ULONG           m_cRef;         //Interface reference count.
        LPVOID          m_pObj;         //Back pointer to the object.
        LPUNKNOWN       m_punkOuter;    //Controlling unknown for delegation

    public:
        CImpIDataObject(LPVOID, LPUNKNOWN);
        ~CImpIDataObject(void);

        //IUnknown members that delegate to m_punkOuter.
        STDMETHODIMP         QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //IDataObject members
        STDMETHODIMP GetData(LPFORMATETC, LPSTGMEDIUM);
        STDMETHODIMP GetDataHere(LPFORMATETC, LPSTGMEDIUM);
        STDMETHODIMP QueryGetData(LPFORMATETC);
        STDMETHODIMP GetCanonicalFormatEtc(LPFORMATETC, LPFORMATETC);
        STDMETHODIMP SetData(LPFORMATETC, STGMEDIUM FAR *, BOOL);
        STDMETHODIMP EnumFormatEtc(DWORD, LPENUMFORMATETC FAR *);
        STDMETHODIMP DAdvise(FORMATETC FAR *, DWORD,  LPADVISESINK, DWORD FAR *);
        STDMETHODIMP DUnadvise(DWORD);
        STDMETHODIMP EnumDAdvise(LPENUMSTATDATA FAR *);
    };



/*
 * IEnumFORMATETC object that is created from IDataObject::EnumFormatEtc.
 * This object lives on its own, that is, QueryInterface only knowns
 * IUnknown and IEnumFormatEtc, nothing more.  We still use an outer
 * unknown for reference counting, because as long as this enumerator
 * lives, the data object should live, thereby keeping the application up.
 */

//IENUMFE.CPP
class __far CEnumFormatEtc : public IEnumFORMATETC
    {
    private:
        ULONG           m_cRef;         //Object reference count.
        LPUNKNOWN       m_punkRef;      //IUnknown for reference counting.
        ULONG           m_iCur;         //Current element.
        ULONG           m_cfe;          //Number of FORMATETCs in us
        LPFORMATETC     m_prgfe;        //Source of FORMATETCs

    public:
        CEnumFormatEtc(LPUNKNOWN, ULONG, LPFORMATETC);
        ~CEnumFormatEtc(void);

        //IUnknown members that delegate to m_punkOuter.
        STDMETHODIMP         QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //IEnumFORMATETC members
        STDMETHODIMP Next(ULONG, LPFORMATETC, ULONG FAR *);
        STDMETHODIMP Skip(ULONG);
        STDMETHODIMP Reset(void);
        STDMETHODIMP Clone(IEnumFORMATETC FAR * FAR *);
    };


typedef CEnumFormatEtc FAR * LPCEnumFormatEtc;



#endif  //_POLYLINE_H_
