/*
 * DATATRAN.H
 *
 * Definitions, classes, and prototypes for a DLL that provides
 * data transfer objects.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _DATATRAN_H_
#define _DATATRAN_H_


#include "dataobj.h"


void FAR PASCAL ObjectDestroyed(void);


//DATATRAN.CPP
//This class factory object creates Data Transfer Objects.

class __far CDataTransferClassFactory : public IClassFactory
    {
    protected:
        ULONG           m_cRef;         //Reference count on class object

    public:
        CDataTransferClassFactory(void);
        ~CDataTransferClassFactory(void);

        //IUnknown members
        STDMETHODIMP         QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //IClassFactory members
        STDMETHODIMP         CreateInstance(LPUNKNOWN, REFIID, LPVOID FAR *);
        STDMETHODIMP         LockServer(BOOL);
    };

typedef CDataTransferClassFactory FAR * LPCDataTransferClassFactory;


#endif //_DATATRAN_H_
