/*
 * IOLEOBJ.CPP
 * Schmoo Figure Handler Chapter 11
 *
 * Implementation of the IOleObject interface for Polyline.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#include "hschmoo.h"



/*
 * CImpIOleObject::CImpIOleObject
 * CImpIOleObject::~CImpIOleObject
 *
 * Parameters (Constructor):
 *  pObj            LPVOID of the object we're in.
 *  punkOuter       LPUNKNOWN to which we delegate.
 */

CImpIOleObject::CImpIOleObject(LPCFigure pObj, LPUNKNOWN punkOuter)
    {
    m_cRef=0;
    m_pObj=pObj;
    m_punkOuter=punkOuter;
    return;
    }

CImpIOleObject::~CImpIOleObject(void)
    {
    return;
    }



/*
 * CImpIOleObject::QueryInterface
 * CImpIOleObject::AddRef
 * CImpIOleObject::Release
 *
 * Purpose:
 *  IUnknown members for CImpIOleObject object.
 */

STDMETHODIMP CImpIOleObject::QueryInterface(REFIID riid, LPVOID FAR *ppv)
    {
    return m_punkOuter->QueryInterface(riid, ppv);
    }


STDMETHODIMP_(ULONG) CImpIOleObject::AddRef(void)
    {
    ++m_cRef;
    return m_punkOuter->AddRef();
    }

STDMETHODIMP_(ULONG) CImpIOleObject::Release(void)
    {
    --m_cRef;
    return m_punkOuter->Release();
    }



/*
 * The only member function we need to implement in a handler is
 * IOleObject::GetExtent since we know exactly how large our data is.
 * All others can be delegated.
 */


/*
 * CImpIOleObject::GetExtent
 *
 * Purpose:
 *  Retrieves the size of the object in HIMETRIC units.
 *
 * Parameters:
 *  dwAspect        DWORD of the aspect requested
 *  pszl            LPSIZEL into which to store the size.
 *
 * Return Value:
 *  HRESULT         NOERROR if successful, error code otherwise.
 */

STDMETHODIMP CImpIOleObject::GetExtent(DWORD dwAspect, LPSIZEL pszl)
    {
    HDC         hDC;
    int         iXppli, iYppli;
    LPRECT      prc;

    /*
     * We can answer for CONTENT/THUMBNAIL, but try the server for others.
     * In addition, always delegate is the server is running since
     * it has a window to define the size.
     */
    if (!((DVASPECT_CONTENT | DVASPECT_THUMBNAIL) & dwAspect)
        || OleIsRunning(m_pObj->m_pDefIOleObject))
        return m_pObj->m_pDefIOleObject->GetExtent(dwAspect, pszl);

    /*
     * The size is in the rc field of the POLYLINEDATA structure
     * which we now have to convert to HIMETRIC.
     */
    hDC=GetDC(NULL);
    iXppli=GetDeviceCaps(hDC, LOGPIXELSX);
    iYppli=GetDeviceCaps(hDC, LOGPIXELSY);

    prc=&m_pObj->m_pl.rc;
    pszl->cx=(long)MulDiv(HIMETRIC_PER_INCH, (prc->right-prc->left), iXppli);
    pszl->cy=(long)MulDiv(HIMETRIC_PER_INCH, (prc->bottom-prc->top), iYppli);

    ReleaseDC(NULL, hDC);

    return NOERROR;
    }


/*
 * CImpIOleObject::DoVerb
 *
 * An example of displaying a message when the local server is not
 * present.  This is a good way to get some free advertising if you
 * allow free redistribution of your handler with documents containing
 * your objects.
 */

STDMETHODIMP CImpIOleObject::DoVerb(LONG iVerb, LPMSG pMSG
    , LPOLECLIENTSITE pSite, LONG lIndex, HWND hWnd, LPCRECT prc)
    {
    HRESULT     hr;

    hr=m_pObj->m_pDefIOleObject->DoVerb(iVerb, pMSG, pSite, lIndex, hWnd, prc);

    if (FAILED(hr))
        {
        MessageBox(hWnd, "Local server not present.\nIf I wanted to make money\nI would put some advertising here."
            , "Schmoo Handler", MB_OK);
        }

    return hr;
    }





STDMETHODIMP CImpIOleObject::SetClientSite(LPOLECLIENTSITE pIOleClientSite)
    {
    return m_pObj->m_pDefIOleObject->SetClientSite(pIOleClientSite);
    }

STDMETHODIMP CImpIOleObject::GetClientSite(LPOLECLIENTSITE FAR * ppSite)
    {
    return m_pObj->m_pDefIOleObject->GetClientSite(ppSite);
    }

STDMETHODIMP CImpIOleObject::SetHostNames(LPCSTR pszApp, LPCSTR pszObj)
    {
    return m_pObj->m_pDefIOleObject->SetHostNames(pszApp, pszObj);
    }

STDMETHODIMP CImpIOleObject::Close(DWORD dwSaveOption)
    {
    return m_pObj->m_pDefIOleObject->Close(dwSaveOption);
    }

STDMETHODIMP CImpIOleObject::SetMoniker(DWORD dwWhich, LPMONIKER pmk)
    {
    return m_pObj->m_pDefIOleObject->SetMoniker(dwWhich, pmk);
    }

STDMETHODIMP CImpIOleObject::GetMoniker(DWORD dwAssign, DWORD dwWhich
    , LPMONIKER FAR * ppmk)
    {
    return m_pObj->m_pDefIOleObject->GetMoniker(dwAssign, dwWhich, ppmk);
    }

STDMETHODIMP CImpIOleObject::InitFromData(LPDATAOBJECT pIDataObject
    , BOOL fCreation, DWORD dw)
    {
    return m_pObj->m_pDefIOleObject->InitFromData(pIDataObject, fCreation, dw);
    }

STDMETHODIMP CImpIOleObject::GetClipboardData(DWORD dwReserved
    , LPDATAOBJECT FAR * ppIDataObj)
    {
    return m_pObj->m_pDefIOleObject->GetClipboardData(dwReserved, ppIDataObj);
    }

STDMETHODIMP CImpIOleObject::EnumVerbs(LPENUMOLEVERB FAR * ppEnum)
    {
    return m_pObj->m_pDefIOleObject->EnumVerbs(ppEnum);
    }

STDMETHODIMP CImpIOleObject::Update(void)
    {
    return m_pObj->m_pDefIOleObject->Update();
    }

STDMETHODIMP CImpIOleObject::IsUpToDate(void)
    {
    return m_pObj->m_pDefIOleObject->IsUpToDate();
    }

STDMETHODIMP CImpIOleObject::GetUserClassID(LPCLSID pClsID)
    {
    return m_pObj->m_pDefIOleObject->GetUserClassID(pClsID);
    }

STDMETHODIMP CImpIOleObject::GetUserType(DWORD dwForm, LPSTR FAR * ppszType)
    {
    return m_pObj->m_pDefIOleObject->GetUserType(dwForm, ppszType);
    }

STDMETHODIMP CImpIOleObject::SetExtent(DWORD dwAspect, LPSIZEL pszl)
    {
    return m_pObj->m_pDefIOleObject->SetExtent(dwAspect, pszl);
    }

STDMETHODIMP CImpIOleObject::Advise(LPADVISESINK pIAdviseSink, LPDWORD pdwConn)
    {
    return m_pObj->m_pDefIOleObject->Advise(pIAdviseSink, pdwConn);
    }

STDMETHODIMP CImpIOleObject::Unadvise(DWORD dwConn)
    {
    return m_pObj->m_pDefIOleObject->Unadvise(dwConn);
    }

STDMETHODIMP CImpIOleObject::EnumAdvise(LPENUMSTATDATA FAR * ppEnum)
    {
    return m_pObj->m_pDefIOleObject->EnumAdvise(ppEnum);
    }

STDMETHODIMP CImpIOleObject::GetMiscStatus(DWORD dwAspect, LPDWORD pdwStatus)
    {
    return m_pObj->m_pDefIOleObject->GetMiscStatus(dwAspect, pdwStatus);
    }

STDMETHODIMP CImpIOleObject::SetColorScheme(LPLOGPALETTE pLP)
    {
    return m_pObj->m_pDefIOleObject->SetColorScheme(pLP);
    }
