/*
 * POLYLINE.H
 * Polyline Component Object Chapter 11
 *
 * Definitions and function prototypes for the PolyLine DLL object.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _POLYLINE_H_
#define _POLYLINE_H_

#include <windows.h>
#include <ole2.h>
#include <classlib.h>
#include <bookguid.h>
#include <ipoly6.h>
#include "resource.h"

//CHAPTER11MOD
#include <ole2ui.h>
//End CHAPTER11MOD


//Classname
#define SZCLASSPOLYLINE             "polyline"

//CHAPTER11MOD
#define SZPOLYFRAMETITLE            "Polyline Figure in %s"

//Some magic number to add to aspects for returns from IViewObject::Freeze
#define FREEZE_KEY_OFFSET           0x0723
//End CHAPTER11MOD


#define HIMETRIC_PER_INCH           2540

//Window extra bytes and offsets
#define CBPOLYLINEWNDEXTRA          (sizeof(LONG))
#define PLWL_STRUCTURE              0



//DLLPOLY.CPP
//This class factory object creates Polyline objects.

class __far CPolylineClassFactory : public IClassFactory
    {
    protected:
        ULONG           m_cRef;         //Reference count on object

    public:
        CPolylineClassFactory(void);
        ~CPolylineClassFactory(void);

        //IUnknown members
        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //IClassFactory members
        STDMETHODIMP         CreateInstance(LPUNKNOWN, REFIID, LPVOID FAR *);
        STDMETHODIMP         LockServer(BOOL);
    };

typedef CPolylineClassFactory FAR * LPCPolylineClassFactory;



//POLYWIN.CPP
LRESULT __export FAR PASCAL PolylineWndProc(HWND, UINT, WPARAM, LPARAM);

//CHAPTER11MOD
#define PROP_SELECTOR   "Selector"
#define PROP_OFFSET     "Offset"

BOOL __export FAR PASCAL PolyDlgProc(HWND, UINT, WPARAM, LPARAM);
//End CHAPTER11MOD

//Type for an object-destroyed callback
typedef void (FAR PASCAL *LPFNDESTROYED)(void);


//POLYLINE.CPP
class __far CPolyline : public IUnknown
    {
    friend LRESULT __export FAR PASCAL PolylineWndProc(HWND, UINT, WPARAM, LPARAM);

    //Make any contained interfaces your friends so they can get at privates
    friend class CImpIPolyline;
    friend class CImpIPersistStorage;
    friend class CImpIDataObject;

    //CHAPTER11MOD
    friend BOOL __export FAR PASCAL PolyDlgProc(HWND, UINT, WPARAM, LPARAM);
    friend class CImpIOleObject;
    friend class CImpIViewObject;
    //End CHAPTER11MOD

    protected:
        HWND            m_hWnd;
        HINSTANCE       m_hInst;

        ULONG           m_cRef;         //Object reference count.
        LPUNKNOWN       m_punkOuter;    //Controlling Unknown for aggregation
        LPFNDESTROYED   m_pfnDestroy;   //Function to call on closure.
        BOOL            m_fDirty;       //Have we changed?
        POLYLINEDATA    m_pl;           //Our actual data.

        LPCStringTable  m_pST;          //Object strings
        UINT            m_cf;           //Object clipboard format.
        CLSID           m_clsID;        //Current CLSID
        IID             m_iID;          //Custom interface IID.

        //Contained interfaces
        LPPOLYLINE          m_pIPolyline;           //Implemented
        LPPERSISTSTORAGE    m_pIPersistStorage;     //Implemented

        LPDATAOBJECT        m_pIDataObject;         //Implemented
        LPDATAADVISEHOLDER  m_pIDataAdviseHolder;   //Used

        //CHAPTER11MOD
        //IDataObject::EnumFormatEtc implemented by OLE for us now.
        //End CHAPTER11MOD

        LPPOLYLINEADVISESINK    m_pAdv;

        //CHAPTER11MOD
        //These are default handler interfaces we use
        LPUNKNOWN           m_pDefIUnknown;
        LPOLEOBJECT         m_pDefIOleObject;
        LPVIEWOBJECT        m_pDefIViewObject;
        LPPERSISTSTORAGE    m_pDefIPersistStorage;
        LPDATAOBJECT        m_pDefIDataObject;

        //Implemented and used interfaces
        LPOLEOBJECT         m_pIOleObject;          //Implemented
        LPOLEADVISEHOLDER   m_pIOleAdviseHolder;    //Used

        LPOLECLIENTSITE     m_pIOleClientSite;      //Used

        LPVIEWOBJECT        m_pIViewObject;         //Implemented
        LPADVISESINK        m_pIAdviseSink;         //Used
        DWORD               m_dwFrozenAspects;      //From IViewObject::Freeze
        DWORD               m_dwAdviseAspects;      //From IViewObject::SetAdvise
        DWORD               m_dwAdviseFlags;        //From IViewObject::SetAdvise

        POLYLINEDATA        m_plContent;            //For freezing
        POLYLINEDATA        m_plThumbnail;          //For freezing

        HWND                m_hDlg;                 //Editing window
        //End CHAPTER11MOD



    protected:
        void      PointScale(LPRECT, LPPOINT, BOOL);
        //CHAPTER11MOD
        void      Draw(HDC, BOOL, BOOL, LPRECT, LPPOLYLINEDATA);
        void      SendAdvise(UINT);
        //End CHAPTER11MOD
        void      RectConvertMappings(LPRECT, BOOL);

        /*
         * These members pulled from IPolyline now serve as a central
         * store for this functionality to be used from other interfaces
         * like IPersistStorage and IDataObject.  Other interfaces later
         * may also use them.
         */
        STDMETHODIMP DataSet(LPPOLYLINEDATA, BOOL, BOOL);
        STDMETHODIMP DataGet(LPPOLYLINEDATA);
        STDMETHODIMP DataSetMem(HGLOBAL, BOOL, BOOL, BOOL);

        STDMETHODIMP RenderNative(HGLOBAL FAR *);
        STDMETHODIMP RenderBitmap(HBITMAP FAR *);
        STDMETHODIMP RenderMetafilePict(HGLOBAL FAR *);

    public:
        CPolyline(LPUNKNOWN, LPFNDESTROYED, HINSTANCE);
        ~CPolyline(void);

        BOOL      FInit(void);

        //Non-delegating object IUnknown
        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);
    };

typedef CPolyline FAR * LPCPolyline;


//CHAPTER11MOD
//Codes for CPolyline::SendAdvise
//......Code........................... Method called in CPolyline::SendAdvise
#define OBJECTCODE_SAVED          0     //IOleAdviseHolder::SendOnSave
#define OBJECTCODE_CLOSED         1     //IOleAdviseHolder::SendOnClose
#define OBJECTCODE_RENAMED        2     //IOleAdviseHolder::SendOnRename
#define OBJECTCODE_SAVEOBJECT     3     //IOleClientSite::SaveObject
#define OBJECTCODE_DATACHANGED    4     //IDataAdviseHolder::SendOnDataChange
#define OBJECTCODE_SHOWWINDOW     5     //IOleClientSite::OnShowWindow(TRUE)
#define OBJECTCODE_HIDEWINDOW     6     //IOleClientSite::OnShowWindow(FALSE)
#define OBJECTCODE_SHOWOBJECT     7     //IOleClientSite::ShowObject
//End CHAPTER11MOD



//Interface implementation contained in the Polyline.

//IPOLYLIN.CPP
class __far CImpIPolyline : public IPolyline6
    {
    protected:
        ULONG               m_cRef;      //Interface reference count.
        LPCPolyline         m_pObj;      //Back pointer to the object.
        LPUNKNOWN           m_punkOuter; //Controlling unknown for delegation.

    public:
        CImpIPolyline(LPCPolyline, LPUNKNOWN);
        ~CImpIPolyline(void);

        //IUnknown members.
        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //::Data* and ::Render* replaced with IDataObject

        //Manipulation members:
        STDMETHODIMP Init(HWND, LPRECT, DWORD, UINT);
        STDMETHODIMP New(void);
        STDMETHODIMP Undo(void);
        STDMETHODIMP Window(HWND FAR *);

        STDMETHODIMP SetAdvise(LPPOLYLINEADVISESINK);
        STDMETHODIMP GetAdvise(LPPOLYLINEADVISESINK FAR *);

        STDMETHODIMP RectGet(LPRECT);
        STDMETHODIMP SizeGet(LPRECT);
        STDMETHODIMP RectSet(LPRECT, BOOL);
        STDMETHODIMP SizeSet(LPRECT, BOOL);

        STDMETHODIMP ColorSet(UINT, COLORREF, COLORREF FAR *);
        STDMETHODIMP ColorGet(UINT, COLORREF FAR *);

        STDMETHODIMP LineStyleSet(UINT, UINT FAR *);
        STDMETHODIMP LineStyleGet(UINT FAR *);
    };

typedef CImpIPolyline * LPCImpIPolyline;


//IPersistStorage Interface implementation contained in the Polyline.

//IPERSTOR.CPP
class __far CImpIPersistStorage : public IPersistStorage
    {
    protected:
        ULONG               m_cRef;      //Interface reference count.
        LPCPolyline         m_pObj;      //Back pointer to the object.
        LPUNKNOWN           m_punkOuter; //Controlling unknown for delegation.

    public:
        CImpIPersistStorage(LPCPolyline, LPUNKNOWN);
        ~CImpIPersistStorage(void);

        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        STDMETHODIMP GetClassID(LPCLSID);

        STDMETHODIMP IsDirty(void);
        STDMETHODIMP InitNew(LPSTORAGE);
        STDMETHODIMP Load(LPSTORAGE);
        STDMETHODIMP Save(LPSTORAGE, BOOL);
        STDMETHODIMP SaveCompleted(LPSTORAGE);
        STDMETHODIMP HandsOffStorage(void);
    };



//IDataObject Interface implementation contained in the Polyline.
//IDATAOBJ.CPP
class __far CImpIDataObject : public IDataObject
    {
    private:
        ULONG           m_cRef;         //Interface reference count.
        LPCPolyline     m_pObj;         //Back pointer to the object.
        LPUNKNOWN       m_punkOuter;    //Controlling unknown for delegation

    public:
        CImpIDataObject(LPCPolyline, LPUNKNOWN);
        ~CImpIDataObject(void);

        //IUnknown members that delegate to m_punkOuter.
        STDMETHODIMP         QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //IDataObject members
        STDMETHODIMP GetData(LPFORMATETC, LPSTGMEDIUM);
        STDMETHODIMP GetDataHere(LPFORMATETC, LPSTGMEDIUM);
        STDMETHODIMP QueryGetData(LPFORMATETC);
        STDMETHODIMP GetCanonicalFormatEtc(LPFORMATETC, LPFORMATETC);
        STDMETHODIMP SetData(LPFORMATETC, STGMEDIUM FAR *, BOOL);
        STDMETHODIMP EnumFormatEtc(DWORD, LPENUMFORMATETC FAR *);
        STDMETHODIMP DAdvise(FORMATETC FAR *, DWORD,  LPADVISESINK, DWORD FAR *);
        STDMETHODIMP DUnadvise(DWORD);
        STDMETHODIMP EnumDAdvise(LPENUMSTATDATA FAR *);
    };



//CHAPTER11MOD

class __far CImpIOleObject : public IOleObject
    {
    private:
        ULONG           m_cRef;         //Interface reference count.
        LPCPolyline     m_pObj;         //Back pointer to the object.
        LPUNKNOWN       m_punkOuter;    //Controlling unknown for delegation

    public:
        CImpIOleObject(LPCPolyline, LPUNKNOWN);
        ~CImpIOleObject(void);

        //IUnknown members that delegate to m_punkOuter.
        STDMETHODIMP         QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //IOleObject members
        STDMETHODIMP SetClientSite(LPOLECLIENTSITE);
        STDMETHODIMP GetClientSite(LPOLECLIENTSITE FAR *);
        STDMETHODIMP SetHostNames(LPCSTR, LPCSTR);
        STDMETHODIMP Close(DWORD);
        STDMETHODIMP SetMoniker(DWORD, LPMONIKER);
        STDMETHODIMP GetMoniker(DWORD, DWORD, LPMONIKER FAR *);
        STDMETHODIMP InitFromData(LPDATAOBJECT, BOOL, DWORD);
        STDMETHODIMP GetClipboardData(DWORD, LPDATAOBJECT FAR *);
        STDMETHODIMP DoVerb(LONG, LPMSG, LPOLECLIENTSITE, LONG, HWND, LPCRECT);
        STDMETHODIMP EnumVerbs(LPENUMOLEVERB FAR *);
        STDMETHODIMP Update(void);
        STDMETHODIMP IsUpToDate(void);
        STDMETHODIMP GetUserClassID(CLSID FAR *);
        STDMETHODIMP GetUserType(DWORD, LPSTR FAR *);
        STDMETHODIMP SetExtent(DWORD, LPSIZEL);
        STDMETHODIMP GetExtent(DWORD, LPSIZEL);
        STDMETHODIMP Advise(LPADVISESINK, DWORD FAR *);
        STDMETHODIMP Unadvise(DWORD);
        STDMETHODIMP EnumAdvise(LPENUMSTATDATA FAR *);
        STDMETHODIMP GetMiscStatus(DWORD, DWORD FAR *);
        STDMETHODIMP SetColorScheme(LPLOGPALETTE);
    };


//IVIEWOBJ.CPP
class __far CImpIViewObject : public IViewObject
    {
    private:
        ULONG           m_cRef;         //Interface reference count.
        LPCPolyline     m_pObj;         //Back pointer to the object.
        LPUNKNOWN       m_punkOuter;    //Controlling unknown for delegation

    public:
        CImpIViewObject(LPCPolyline, LPUNKNOWN);
        ~CImpIViewObject(void);

        //IUnknown members that delegate to m_punkOuter.
        STDMETHODIMP         QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //IViewObject members
        STDMETHODIMP Draw(DWORD, LONG, LPVOID, DVTARGETDEVICE FAR *, HDC, HDC
            , const LPRECTL, const LPRECTL, BOOL (CALLBACK *)(DWORD), DWORD);
        STDMETHODIMP GetColorSet(DWORD, LONG, LPVOID, DVTARGETDEVICE FAR *
            , HDC, LPLOGPALETTE FAR *);
        STDMETHODIMP Freeze(DWORD, LONG, LPVOID, LPDWORD);
        STDMETHODIMP Unfreeze(DWORD);
        STDMETHODIMP SetAdvise(DWORD, DWORD, LPADVISESINK);
        STDMETHODIMP GetAdvise(LPDWORD, LPDWORD, LPADVISESINK FAR *);
    };


//End CHAPTER11MOD

#endif  //_POLYLINE_H_
