/*
 * LNKASSIS.H
 *
 * Classes that implement the LinksAssistant object
 *
 * Copyright (c)1993 Microsoft Corporation, All Right Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _LNKASSIS_H_
#define _LNKASSIS_H_


#include <windows.h>
#include <ole2.h>
#include <ole2ui.h>
#include <bookguid.h>       //CLSID_LinksAssistant, IID_IOleUILinkContainer


typedef void (FAR PASCAL *LPFNDESTROYED)(void);


class __far CLinks : public IOleUILinkContainer
    {
    protected:
        ULONG           m_cRef;         //Object reference count.
        LPUNKNOWN       m_punkOuter;    //Controlling Unknown for aggregation
        LPFNDESTROYED   m_pfnDestroy;   //Function to call on closure.

    protected:
        //Internal functions for implementing IOleUILinkContainer
        BOOL CLinks::FValidateLinkSource(LPSTR, ULONG FAR *, LPMONIKER FAR *, LPCLSID);
        BOOL CLinks::FCreateNewSourceMoniker(LPSTR, ULONG, LPMONIKER FAR *);

    public:
        CLinks(LPUNKNOWN, LPFNDESTROYED);
        ~CLinks(void);

        STDMETHODIMP         QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        /*
         * The dwLink parameter to all of these functions is assumed
         * to be an IOleLink pointer for the object in question
         * (GetNextLink is not implelemented in us).  We can
         * QueryInterface IOleLink for anything else we need.
         */

        STDMETHODIMP_(DWORD) GetNextLink(DWORD);
        STDMETHODIMP         SetLinkUpdateOptions(DWORD, DWORD);
        STDMETHODIMP         GetLinkUpdateOptions(DWORD, LPDWORD);
        STDMETHODIMP         SetLinkSource(DWORD, LPSTR, ULONG, ULONG FAR *, BOOL);
        STDMETHODIMP         GetLinkSource(DWORD, LPSTR FAR *, ULONG FAR *
                                 , LPSTR FAR * , LPSTR FAR *, BOOL FAR *, BOOL FAR *);
        STDMETHODIMP         OpenLinkSource(DWORD);
        STDMETHODIMP         UpdateLink(DWORD, BOOL, BOOL);
        STDMETHODIMP         CancelLink(DWORD);
    };

typedef CLinks FAR * LPCLinks;


#endif //_LNKASSIS_H_
