/*
 * PAGES.H
 * Modifications for Chapter 13
 *
 * Definitions and function prototypes for the Pages window control
 * as well as the CPage class.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _PAGES_H_
#define _PAGES_H_

//We need this for UICursorLoad and new-style cursors.
#include <bttncur.h>

//CHAPTER13MOD
#include <stdlib.h>     //For atol
//End CHAPTER13MOD

//Versioning.
#define VERSIONMAJOR                2
#define VERSIONMINOR                0
#define VERSIONCURRENT              0x00020000

//Classname
#define SZCLASSPAGES                "pages"

#define HIMETRIC_PER_INCH           2540
#define LOMETRIC_PER_INCH           254
#define LOMETRIC_BORDER             60          //Border around page


//Window extra bytes and offsets
#define CBPAGESWNDEXTRA             (sizeof(LONG))
#define PAGEWL_STRUCTURE            0


//Time to break this stuff out into another file.
#include "tenant.h"


typedef struct __far tagTENANTLIST
    {
    DWORD       cTenants;
    DWORD       dwIDNext;
    } TENANTLIST, FAR *LPTENANTLIST;


/*
 * Persistent information we need to save for each tenant, which is done
 * in the tenant list instead of with each tenant.  Since this is a small
 * structure it's best not to blow another stream for it (overhead).
 */
typedef struct tagTENANTINFO
    {
    DWORD       dwID;
    RECTL       rcl;
    FORMATETC   fe;     //Excludes ptd
    } TENANTINFO, FAR *LPTENANTINFO;


#define SZSTREAMTENANTLIST        "Tenant List"




/*
 * Page class describing an individual page and what things it contains,
 * managing an IStorage for us.
 *
 * A DWORD is used to identify this page as the name of the storage
 * is the string form of this ID.  If we added a page every second,
 * it would take 136 years to overrun this counter, so we can
 * get away with saving it persistently.  I hope this software is
 * obsolete by then.
 */

class __far CPage : public IUnknown
    {
    friend class CIOleUILinkContainer;

    //CHAPTER13MOD
    friend class CImpIOleItemContainer;
    //End CHAPTER13MOD

    private:
        HWND        m_hWnd;             //Pages window, same as CPages.
        DWORD       m_dwID;             //Persistent DWORD identifier
        LPSTORAGE   m_pIStorage;        //Sub-storage for this page.
        DWORD       m_cOpens;           //Calls to FOpen.

        class CPages FAR *m_pPG;        //Pages window

        DWORD       m_dwIDNext;
        DWORD       m_cTenants;
        HWND        m_hWndTenantList;   //Listbox that manages our tenant list

        UINT        m_iTenantCur;
        LPTENANT    m_pTenantCur;

        UINT        m_uHTCode;          //Last hit-test on mouse move.
        UINT        m_uSizingFlags;     //Restrictions on sizing motion.
        BOOL        m_fTracking;        //Tracking resize?
        RECTL       m_rclOrg;           //Original before tracking
        RECTL       m_rcl;              //Tracking rectangle.
        RECTL       m_rclBounds;        //Boundaries for size tracking.
        HDC         m_hDC;              //Tracking hDC.

        //CHAPTER13MOD
        LPMONIKER           m_pmkFile;  //Document name
        ULONG               m_cRef;
        LPOLEITEMCONTAINER  m_pIOleItemContainer;
        //End CHAPTER13MOD

    protected:
        BOOL         FTenantGet(UINT, LPTENANT FAR *, BOOL);
        //CHAPTER13MOD
        BOOL         FTenantGetFromID(DWORD, LPTENANT FAR *, BOOL);
        //End CHAPTER13MOD
        BOOL         FTenantAdd(UINT, DWORD, LPTENANT FAR *);
        LPDATAOBJECT TransferObjectCreate(LPPOINTL);

        //PAGEMOUS.CPP
        BOOL         FSelectTenantAtPoint(UINT, UINT);
        UINT         TenantFromPoint(UINT, UINT, LPTENANT FAR *);
        BOOL         DragDrop(UINT, UINT, UINT);

    public:
        CPage(DWORD, HWND, class CPages FAR *);
        ~CPage(void);

        //CHAPTER13MOD
        //IUnknown for delegation
        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);
        //End CHAPTER13MOD

        DWORD       GetID(void);
        BOOL        FOpen(LPSTORAGE);
        void        Close(BOOL);
        BOOL        Update(void);
        void        Destroy(LPSTORAGE);
        UINT        GetStorageName(LPSTR);

        void        Draw(HDC, int, int, BOOL, BOOL);

        BOOL        TenantCreate(TENANTTYPE, LPVOID, LPFORMATETC
                        , LPPATRONOBJECT, DWORD);
        BOOL        TenantDestroy(void);
        BOOL        TenantClip(BOOL);
        BOOL        FQueryObjectSelected(HMENU);
        void        ActivateObject(UINT);
        void        ShowObjectTypes(BOOL);
        void        NotifyTenantsOfRename(LPSTR, LPMONIKER);
        BOOL        FQueryLinksInPage(void);

        //PAGEMOUSE.CPP
        BOOL        OnRightDown(UINT, UINT, UINT);
        BOOL        OnLeftDown(UINT, UINT, UINT);
        BOOL        OnLeftDoubleClick(UINT, UINT, UINT);
        BOOL        OnLeftUp(UINT, UINT, UINT);
        void        OnNCHitTest(UINT, UINT);
        BOOL        OnSetCursor(UINT);
        void        OnMouseMove(UINT, int, int);
    };

typedef CPage FAR * LPPAGE;



/*
 * Structures to save with the document describing the device
 * configuration and pages that we have.  This is followed by
 * a list of DWORD IDs for the individual pages.
 */

typedef struct __far tagDEVICECONFIG
    {
    DEVMODE     dm;
    char        szDriver[CCHDEVICENAME];
    char        szDevice[CCHDEVICENAME];
    char        szPort[CCHDEVICENAME];
    } DEVICECONFIG, FAR * LPDEVICECONFIG;


typedef struct __far tagPAGELIST
    {
    DWORD       cPages;
    DWORD       iPageCur;
    DWORD       dwIDNext;
    } PAGELIST, FAR *LPPAGELIST;


//PAGEWIN.CPP
LRESULT __export FAR PASCAL PagesWndProc(HWND, UINT, WPARAM, LPARAM);
BOOL    __export FAR PASCAL AbortProc(HDC, int);
BOOL    __export FAR PASCAL PrintDlgProc(HWND, UINT, WPARAM, LPARAM);
void                        RectConvertMappings(LPRECT, HDC, BOOL);



class __far CPages : public CWindow
    {
    friend LRESULT __export FAR PASCAL PagesWndProc(HWND, UINT, WPARAM, LPARAM);
    friend BOOL    __export FAR PASCAL PrintDlgProc(HWND, UINT, WPARAM, LPARAM);

    friend class CPage;
    friend class CTenant;
    friend class CDropTarget;
    friend class CImpIOleClientSite;
    friend class CImpIAdviseSink;

    //CHAPTER13MOD
    friend class CImpIOleItemContainer;
    //End CHAPTER13MOD

    protected:
        LPPAGE      m_pPageCur;             //Current page we're viewing
        UINT        m_iPageCur;
        UINT        m_cPages;               //Number of pages

        HWND        m_hWndPageList;         //Listbox that manages our page list
        HFONT       m_hFont;                //Page font.
        BOOL        m_fSystemFont;          //Is m_hFont system object?

        UINT        m_cx;                   //Usable page size in LOMETRIC
        UINT        m_cy;

        UINT        m_xMarginLeft;          //Unusable page margins, LOMETRIC
        UINT        m_xMarginRight;
        UINT        m_yMarginTop;
        UINT        m_yMarginBottom;

        UINT        m_xPos;                 //Current viewport scroll position.
        UINT        m_yPos;                 //both in *PIXELS*

        DWORD       m_dwIDNext;             //Next ID for a page.
        LPSTORAGE   m_pIStorage;            //Root storage of document.

        UINT        m_cf;                   //Application clipboard format.
        BOOL        m_fDirty;

        BOOL        m_fDragSource;          //Drag-drop source==target
        BOOL        m_fMoveInPage;          //Only moving in same page
        BOOL        m_fLinkAllowed;         //Can allow linking in drag-drop.
        POINTL      m_ptDrop;               //Where to move object to.

        BOOL        m_fDragRectShown;       //Is there a rect on the screen?
        UINT        m_uScrollInset;         //Hit-test region for drag-drop
        UINT        m_uScrollDelay;         //Time to wait before repeat
        DWORD       m_dwTimeLast;           //Ticks on last DragOver
        UINT        m_uHScrollCode;         //Left or right on scroll repeat?
        UINT        m_uVScrollCode;         //Up or down on scroll repeat?
        UINT        m_uLastTest;            //Last from UTestDroppablePoint

        BOOL        m_fShowTypes;           //Show Object active?

    private:
        void      Draw(HDC, BOOL, BOOL);
        void      UpdateScrollRanges(void);
        BOOL      ConfigureForDevice(void);
        BOOL      FPageGet(UINT, LPPAGE FAR *, BOOL);
        BOOL      FPageAdd(UINT, DWORD, BOOL);

        void      CalcBoundingRect(LPRECT, BOOL);

        //DRAGDROP.CPP
        UINT      UTestDroppablePoint(LPPOINTL);
        void      DrawDropTargetRect(LPPOINTL, LPSIZEL);
        void      AdjustPosition(LPPOINTL, LPSIZEL);

    public:
        CPages(HINSTANCE, UINT);
        ~CPages(void);

        BOOL      FInit(HWND, LPRECT, DWORD, UINT, LPVOID);

        BOOL      FIStorageSet(LPSTORAGE, BOOL, BOOL); //Was ::New previously
        BOOL      FIStorageUpdate(BOOL);

        BOOL      Print(HDC, LPSTR, DWORD, UINT, UINT, UINT);

        void      RectGet(LPRECT);
        void      RectSet(LPRECT, BOOL);
        void      SizeGet(LPRECT);
        void      SizeSet(LPRECT, BOOL);

        UINT      PageInsert(UINT);
        UINT      PageDelete(UINT);
        UINT      CurPageGet(void);
        UINT      CurPageSet(UINT);
        UINT      NumPagesGet(void);

        BOOL      DevModeSet(HGLOBAL, HGLOBAL);
        HGLOBAL   DevModeGet(void);

        BOOL      FIsDirty(void);
        BOOL      DevReadConfig(LPDEVICECONFIG, HDC FAR *);
        BOOL      TenantCreate(TENANTTYPE, LPVOID, LPFORMATETC
                      , LPPATRONOBJECT, DWORD);
        BOOL      TenantDestroy(void);
        BOOL      TenantClip(BOOL);
        BOOL      FQueryObjectSelected(HMENU);
        void      ActivateObject(UINT);

        void      ShowObjectTypes(BOOL);
        void      NotifyTenantsOfRename(LPSTR, LPMONIKER);
        BOOL      FQueryLinksInPage(void);
        BOOL      FGetUILinkContainer(class CIOleUILinkContainer FAR * FAR *);

        //CHAPTER13MOD
        UINT      IPageGetFromID(DWORD, LPPAGE FAR *, BOOL);
        //End CHAPTER13MOD
    };

typedef CPages FAR * LPCPages;


//Fixed names of streams in the Pages IStorage
#define SZSTREAMPAGELIST        "Page List"
#define SZSTREAMDEVICECONFIG    "Device Configuration"

//Return values for UTestDroppablePoint
#define UDROP_NONE              0x0000      //Exclusive
#define UDROP_CLIENT            0x0001      //Inclusive
#define UDROP_INSETLEFT         0x0002      //Left/Right are mutually excl.
#define UDROP_INSETRIGHT        0x0004
#define UDROP_INSETHORZ         (UDROP_INSETLEFT | UDROP_INSETRIGHT)

#define UDROP_INSETTOP          0x0008      //Top/Bottom are mutually excl.
#define UDROP_INSETBOTTOM       0x0010
#define UDROP_INSETVERT         (UDROP_INSETTOP | UDROP_INSETBOTTOM)


//Object used for the Links dialog

class __far CIOleUILinkContainer : public IOleUILinkContainer
    {
    private:
        ULONG                   m_cRef;
        LPPAGE                  m_pPage;
        UINT                    m_iTenant;
        LPOLEUILINKCONTAINER    m_pDelIUILinks;

    public:
        BOOL                    m_fDirty;   //No reason to hide it.

    protected:
        STDMETHODIMP GetObjectInterface(DWORD, REFIID, LPLPVOID);

    public:
        CIOleUILinkContainer(LPPAGE);
        ~CIOleUILinkContainer(void);

        BOOL FInit(void);
        BOOL IsDirty(void);

        STDMETHODIMP         QueryInterface(REFIID, LPLPVOID);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        STDMETHODIMP_(DWORD) GetNextLink(DWORD);
        STDMETHODIMP         SetLinkUpdateOptions(DWORD, DWORD);
        STDMETHODIMP         GetLinkUpdateOptions(DWORD, LPDWORD);
        STDMETHODIMP         SetLinkSource(DWORD, LPSTR, ULONG, ULONG FAR *, BOOL);
        STDMETHODIMP         GetLinkSource(DWORD, LPSTR FAR *, ULONG FAR *
                                 , LPSTR FAR * , LPSTR FAR *, BOOL FAR *, BOOL FAR *);
        STDMETHODIMP         OpenLinkSource(DWORD);
        STDMETHODIMP         UpdateLink(DWORD, BOOL, BOOL);
        STDMETHODIMP         CancelLink(DWORD);
    };

typedef CIOleUILinkContainer FAR * LPCIOleUILinkContainer;


#endif  //_PAGES_H_
