/*
 * TENANT.H
 * Modifications for Chapter 13
 *
 * Definitions and function prototypes for the CTenant class
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _TENANT_H_
#define _TENANT_H_


class __far CImpIOleClientSite : public IOleClientSite
    {
    protected:
        ULONG               m_cRef;      //Interface reference count.
        class CTenant FAR * m_pTen;      //Back pointer to the object.
        LPUNKNOWN           m_punkOuter; //Controlling unknown for delegation.

    public:
        CImpIOleClientSite(class CTenant FAR *, LPUNKNOWN);
        ~CImpIOleClientSite(void);

        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        STDMETHODIMP SaveObject(void);
        STDMETHODIMP GetMoniker(DWORD, DWORD, LPMONIKER FAR *);
        STDMETHODIMP GetContainer(LPOLECONTAINER FAR *);
        STDMETHODIMP ShowObject(void);
        STDMETHODIMP OnShowWindow(BOOL);
        STDMETHODIMP RequestNewObjectLayout(void);
    };

typedef CImpIOleClientSite FAR * LPIMPIOLECLIENTSITE;



class __far CImpIAdviseSink : public IAdviseSink
    {
    protected:
        ULONG               m_cRef;      //Interface reference count.
        class CTenant FAR * m_pTen;      //Back pointer to the object.
        LPUNKNOWN           m_punkOuter; //Controlling unknown for delegation.

    public:
        CImpIAdviseSink(class CTenant FAR *, LPUNKNOWN);
        ~CImpIAdviseSink(void);

        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        STDMETHODIMP_(void)  OnDataChange(LPFORMATETC, LPSTGMEDIUM);
        STDMETHODIMP_(void)  OnViewChange(DWORD, LONG);
        STDMETHODIMP_(void)  OnRename(LPMONIKER);
        STDMETHODIMP_(void)  OnSave(void);
        STDMETHODIMP_(void)  OnClose(void);
    };


typedef CImpIAdviseSink FAR * LPIMPIADVISESINK;






/*
 * Tenant class describing an individual piece of data in a page.
 * It knows where it sits, what object is inside of it, and what
 * its idenitifer is such that it can find it's storage within a page.
 */

//Patron Objects clipboard format
typedef struct tagPATRONOBJECT
    {
    POINTL      ptl;        //Location of object
    POINTL      ptlPick;    //Pick point from drag-drop operation.
    SIZEL       szl;        //Extents of object (absolute)
    FORMATETC   fe;         //Actual object format.
    } PATRONOBJECT, FAR * LPPATRONOBJECT;



//Values for hit-testing, drawing, and resize-tracking tenants
#define CXYHANDLE       5

//Tenant types (not persistent, but determined at load time)
typedef enum
    {
    TENANTTYPE_NULL=0,
    TENANTTYPE_STATIC,
    TENANTTYPE_EMBEDDEDOBJECT,
    TENANTTYPE_EMBEDDEDFILE,
    TENANTTYPE_EMBEDDEDOBJECTFROMDATA,
    TENANTTYPE_LINKEDOBJECT,
    TENANTTYPE_LINKEDFILE,
    TENANTTYPE_LINKEDOBJECTFROMDATA
    } TENANTTYPE, FAR * LPTENANTTYPE;


//State flags
#define TENANTSTATE_DEFAULT      0x00000000
#define TENANTSTATE_SELECTED     0x00000001
#define TENANTSTATE_OPEN         0x00000002
#define TENANTSTATE_SHOWTYPE     0x00000004


class __far CTenant : public IUnknown
    {
    friend CImpIOleClientSite;
    friend CImpIAdviseSink;

    private:
        HWND            m_hWnd;             //Pages window, same as CPages.
        DWORD           m_dwID;             //Persistent DWORD identifier
        DWORD           m_cOpens;           //Count calls to FOpen.

        BOOL            m_fInitialized;     //Something here?
        LPUNKNOWN       m_pObj;             //The object that lives here.
        LPSTORAGE       m_pIStorage;        //Sub-storage for this tenant

        FORMATETC       m_fe;               //As used to create the object.
        DWORD           m_dwState;          //State flags
        RECTL           m_rcl;              //Space of this object.

        class CPages FAR *m_pPG;            //Pages window

        TENANTTYPE      m_tType;            //Type identifier
        ULONG           m_cRef;             //We're an object now!
        LPOLEOBJECT     m_pIOleObject;      //IOleObject on m_pObj
        LPVIEWOBJECT    m_pIViewObject;     //IViewObject on m_pObj

        LPOLECLIENTSITE m_pIOleClientSite;  //Our interfaces
        LPADVISESINK    m_pIAdviseSink;

        //CHAPTER13MOD
        LPMONIKER       m_pmk;              //Relative moniker.
        LPMONIKER       m_pmkFile;          //Container document moniker.
        //End CHAPTER13MOD

    /*
     * This flag is used exculsively by the implementation of
     * IOleUILinkContainer on the page we're in for the Links Dialog.
     * Since we never use it ourselves, public here is no big deal.
     */
    public:
        BOOL            m_fLinkAvail;


    protected:
        BOOL    FObjectInitialize(LPUNKNOWN, LPFORMATETC, DWORD);
        HRESULT CreateStatic(LPDATAOBJECT, LPFORMATETC, LPUNKNOWN FAR *);

    public:
        CTenant(DWORD, HWND, CPages FAR *);
        ~CTenant(void);

        //Gotta have an IUnknown for delegation.
        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        DWORD   GetID(void);
        UINT    GetStorageName(LPSTR);
        UINT    UCreate(TENANTTYPE, LPVOID, LPFORMATETC, LPPOINTL
                    , LPSIZEL, LPSTORAGE, LPPATRONOBJECT, DWORD);
        BOOL    FLoad(LPSTORAGE, LPFORMATETC, LPRECTL);
        BOOL    FOpen(LPSTORAGE);
        void    Close(BOOL);
        BOOL    Update(void);
        void    Destroy(LPSTORAGE);

        void    Select(BOOL);
        void    ShowAsOpen(BOOL);
        void    ShowYourself(void);
        void    AddVerbMenu(HMENU, UINT);
        void    CopyEmbeddedObject(LPDATAOBJECT, LPFORMATETC, LPPOINTL);

        //CHAPTER13MOD
        void    CopyLinkedObject(LPDATAOBJECT, LPFORMATETC, LPPOINTL);
        void    NotifyOfRename(LPSTR, LPMONIKER, LPMONIKER);
        void    StorageGet(LPSTORAGE FAR *);
        //End CHAPTER13MOD

        void    ShowObjectType(BOOL);
        BOOL    Activate(DWORD);
        void    Draw(HDC, DVTARGETDEVICE FAR *, HDC, int, int, BOOL, BOOL);
        void    Repaint(void);
        void    Invalidate(void);

        TENANTTYPE  TypeGet(void);
        BOOL        FIsSelected(void);
        BOOL        FConvertToStatic(void);

        void    ObjectGet(LPUNKNOWN FAR *);
        void    FormatEtcGet(LPFORMATETC, BOOL);
        void    SizeGet(LPSIZEL, BOOL);
        void    SizeSet(LPSIZEL, BOOL);
        void    RectGet(LPRECTL, BOOL);
        void    RectSet(LPRECTL, BOOL);
    };


typedef CTenant FAR * LPTENANT;

//Return codes for UCreate
#define UCREATE_FAILED              0
#define UCREATE_GRAPHICONLY         1
#define UCREATE_PLACEDOBJECT        2



#endif //_TENANT_H_
