/*
 * POLYLINE.H
 *
 * Definitions and function prototypes for the PolyLine window class
 * that can be treated like its own control.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _POLYLINE_H_
#define _POLYLINE_H_

//Versioning.
#define VERSIONMAJOR                2
#define VERSIONMINOR                0
#define VERSIONCURRENT              0x00020000

//Classname
#define SZCLASSPOLYLINE             "polyline"

#define HIMETRIC_PER_INCH           2540
#define CPOLYLINEPOINTS             20

//Window extra bytes and offsets
#define CBPOLYLINEWNDEXTRA          (sizeof(LONG))
#define PLWL_STRUCTURE              0


//Version 2.0 Polyline Structure
typedef struct __far tagPOLYLINEDATA
    {
    WORD        wVerMaj;                //Major version number.
    WORD        wVerMin;                //Minor version number.
    WORD        cPoints;                //Number of points.
    BOOL        fReserved;              //Previously fDrawEntire, obsoleted
    RECT        rc;                     //Rectangle of this figure (client)
    POINT       rgpt[CPOLYLINEPOINTS];  //Array of points on 0-32767 grid.

    //Version 2.0 additions
    COLORREF    rgbBackground;          //Background color
    COLORREF    rgbLine;                //Line color
    int         iLineStyle;             //Line style
    } POLYLINEDATA, FAR *LPPOLYLINEDATA;

#define CBPOLYLINEDATA   sizeof(POLYLINEDATA)
#define CBPOLYLINEDATA20 sizeof(POLYLINEDATA)


//Version 1.0 Polyline Structure
typedef struct __far tagPOLYLINEDATA10
    {
    WORD        wVerMaj;                //Major version number.
    WORD        wVerMin;                //Minor version number.
    WORD        cPoints;                //Number of points.
    BOOL        fDrawEntire;            //Flag to draw entire figure.
    RECT        rc;                     //Rectangle of this figure (parent)
    POINT       rgpt[CPOLYLINEPOINTS];  //Array of points scaled to rc
    } POLYLINEDATA10, FAR *LPPOLYLINEDATA10;

#define CBPOLYLINEDATA10 sizeof(POLYLINEDATA10)


//POLYWIN.CPP
LRESULT __export FAR PASCAL PolylineWndProc(HWND, UINT, WPARAM, LPARAM);



class __far CPolyline : public CWindow
    {
    friend LRESULT __export FAR PASCAL PolylineWndProc(HWND, UINT, WPARAM, LPARAM);

    private:
        POLYLINEDATA   m_pl;

        class CPolylineAdviseSink FAR * m_pAdv;

    private:
        void      PointScale(LPRECT, LPPOINT, BOOL);
        void      Draw(HDC, BOOL, BOOL);
        void      RectConvertMappings(LPRECT, BOOL);

    public:
        CPolyline(HINSTANCE);
        ~CPolyline(void);

        BOOL      FInit(HWND, LPRECT, DWORD, UINT, class CPolylineAdviseSink FAR *);

        void      New(void);
        BOOL      Undo(void);

        //File functions
        LONG      ReadFromStorage(LPSTORAGE);
        LONG      WriteToStorage(LPSTORAGE, LONG);
        LONG      ReadFromFile(LPSTR);
        LONG      WriteToFile(LPSTR, LONG);

        //Data transfer functions
        LONG      DataSet(LPPOLYLINEDATA, BOOL, BOOL);
        LONG      DataGet(LPPOLYLINEDATA, LONG);
        LONG      DataSetMem(HGLOBAL, BOOL, BOOL, BOOL);
        LONG      DataGetMem(LONG, HGLOBAL FAR *);
        HBITMAP   RenderBitmap(void);
        HMETAFILE RenderMetafile(void);
        HGLOBAL   RenderMetafilePict(void);

        void      RectGet(LPRECT);
        void      SizeGet(LPRECT);
        void      RectSet(LPRECT, BOOL);
        void      SizeSet(LPRECT, BOOL);
        COLORREF  ColorSet(UINT, COLORREF);
        COLORREF  ColorGet(UINT);
        UINT      LineStyleSet(UINT);
        UINT      LineStyleGet(void);
    };

typedef CPolyline FAR * LPCPolyline;


//Error values for data transfer functions
#define POLYLINE_E_NONE                    0
#define POLYLINE_E_UNSUPPORTEDVERSION      -1
#define POLYLINE_E_INVALIDPOINTER          -2
#define POLYLINE_E_READFAILURE             -3
#define POLYLINE_E_WRITEFAILURE            -4




class __far CPolylineAdviseSink
    {
    private:
        LPVOID      m_pv;                       //Customizable structure

    public:
        CPolylineAdviseSink(LPVOID);
        ~CPolylineAdviseSink(void);

        void OnPointChange(void);
        void OnSizeChange(void);
        void OnDataChange(void);
        void OnColorChange(void);
        void OnLineStyleChange(void);
    };

typedef CPolylineAdviseSink FAR * LPCPolylineAdviseSink;


//Color indices for color messages
#define POLYLINECOLOR_BACKGROUND    0
#define POLYLINECOLOR_LINE          1



#endif  //_POLYLINE_H_
