/*
 * SCHMOO.H
 * Chapter 13 Modifications
 *
 * Single include file that pulls in everything needed for other source
 * files in the Schmoo application.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _SCHMOO_H_
#define _SCHMOO_H_

#include <windows.h>
#include <memory.h>
#include <ole2.h>   //Required for storage use
#include <ole2ver.h>
#include <ole2ui.h>
#include <bookguid.h>

//These include files reference DLLs that don't have extern "C" already
extern "C"
    {
    #include <commdlg.h>
    }

#include <classlib.h>
#include "resource.h"


//Get the editor window information.
#include "polyline.h"


//SCHMOO.CPP:  Frame object that creates a main window

class __far CSchmooFrame : public CFrame
    {
    friend class CFigureClassFactory;
    friend class CFigure;   //For UI purposes.

    private:
        HBITMAP         m_hBmpLines[5];     //Menu item bitmaps
        BOOL            m_fInitialized;     //Did OleInitalize work?

        BOOL            m_fEmbedding;       //-Embedding on command line?
        DWORD           m_dwRegCO;          //From CoRegisterClassObject
        LPCLASSFACTORY  m_pIClassFactory;

    protected:
        //Overridable for creating a CClient for this frame
        virtual LPCClient CreateCClient(void);

        virtual BOOL      FRegisterAllClasses(void);
        virtual BOOL      FPreShowInit(void);
        virtual void      ParseCommandLine(void);
        virtual UINT      CreateGizmos(void);
        virtual LRESULT   OnCommand(HWND, WPARAM, LPARAM);
        virtual void      OnDocumentDataChange(LPCDocument);
        virtual void      OnDocumentActivate(LPCDocument);

        //New for this class
        virtual void      CreateLineMenu(void);

    public:
        CSchmooFrame(HINSTANCE, HINSTANCE, LPSTR, int);
        virtual ~CSchmooFrame(void);

        //Overrides
        virtual BOOL      FInit(LPFRAMEINIT);
        virtual void      UpdateMenus(HMENU, UINT);
        virtual void      UpdateGizmos(void);

        //New for this class
        virtual void      CheckLineSelection(UINT);
        virtual void      UpdateEmbeddingUI(BOOL, LPCDocument, LPCSTR, LPCSTR);
    };


typedef CSchmooFrame FAR * LPCSchmooFrame;





//CLIENT.CPP

/*
 * The only reason we have a derived class here is to override
 * CreateCDocument so we can create our own type as well as
 * overriding NewDocument to perform one other piece of work once the
 * document's been created.
 */

class __far CSchmooClient : public CClient
    {
    protected:
        //Overridable for creating a new CDocument
        virtual LPCDocument CreateCDocument();

    public:
        CSchmooClient(HINSTANCE);
        virtual ~CSchmooClient(void);

        virtual LPCDocument NewDocument(BOOL, LPCDocumentAdviseSink);
    };


typedef CSchmooClient FAR * LPCSchmooClient;






//DOCUMENT.CPP

//Constant ID for the window polyline that lives in a document window
#define ID_POLYLINE         10

class __far CSchmooDoc : public CDocument
    {
    friend class CPolylineAdviseSink;

    //These need access to FQueryPasteFromData, FPasteFromData
    friend class CDropTarget;
    friend class CDropSource;

    friend class CFigureClassFactory;
    friend class CFigure;

    protected:
        UINT            m_uPrevSize;        //Last WM_SIZE wParam
        LONG            m_lVer;             //Loaded Polyline version

        LPCPolyline             m_pPL;      //Polyline Editor window in us.
        LPCPolylineAdviseSink   m_pPLAdv;   //Advises from Polyline

        class CDropTarget FAR  *m_pDropTarget;  //Registered target.

        BOOL            m_fDragSource;          //Drag-drop source==target

        UINT            m_cfEmbedSource;        //Compound Doc format.
        UINT            m_cfObjectDescriptor;   //Compound Doc format.

        class CFigure FAR      *m_pFigure;      //The object in us.

        //CHAPTER13MOD
        LPMONIKER               m_pMoniker;     //The moniker for our file
        DWORD                   m_dwRegROT;     //From IRunningObjectTable::Register

        UINT                    m_cfLinkSource;
        UINT                    m_cfLinkSrcDescriptor;
        //End CHAPTER13MOD

    protected:
        virtual BOOL    FMessageHook(HWND, UINT, WPARAM, LPARAM, LRESULT FAR *);
        void            DropSelectTargetWindow(void);

    public:
        CSchmooDoc(HINSTANCE);
        virtual ~CSchmooDoc(void);

        virtual BOOL     FInit(LPDOCUMENTINIT);
        virtual void     Clear();

        virtual BOOL     FDirtySet(BOOL);
        virtual BOOL     FDirtyGet(void);
        virtual UINT     ULoad(BOOL, LPSTR);
        virtual UINT     USave(UINT, LPSTR);
        //CHAPTER13MOD
        void             Rename(LPSTR);
        //End CHAPTER13MOD

        virtual void     Undo(void);
        virtual BOOL     FClip(HWND, BOOL);
        virtual HGLOBAL  RenderFormat(UINT);
        virtual BOOL     FRenderMedium(UINT, LPSTGMEDIUM);
        virtual BOOL     FQueryPaste(void);
        virtual BOOL     FPaste(HWND);

        //These were protected.  Now for IOleObject, should be public.
        virtual BOOL    FQueryPasteFromData(LPDATAOBJECT);
        virtual BOOL    FPasteFromData(LPDATAOBJECT);
        LPDATAOBJECT    TransferObjectCreate(BOOL);

        virtual COLORREF ColorSet(UINT, COLORREF);
        virtual COLORREF ColorGet(UINT);

        virtual UINT     LineStyleSet(UINT);
        virtual UINT     LineStyleGet();
    };

typedef CSchmooDoc FAR * LPCSchmooDoc;


//These color indices wrap the polyline definitions
#define DOCCOLOR_BACKGROUND             POLYLINECOLOR_BACKGROUND
#define DOCCOLOR_LINE                   POLYLINECOLOR_LINE



//Drag-drop interfaces we need in the document
class __far CDropTarget : public IDropTarget
    {
    protected:
        ULONG               m_cRef;      //Interface reference count.
        LPCSchmooDoc        m_pDoc;      //Back pointer to the document

        LPDATAOBJECT        m_pIDataObject;  //Data object from DragEnter

    public:
        CDropTarget(LPCSchmooDoc);
        ~CDropTarget(void);

        //IDropTarget interface members
        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        STDMETHODIMP DragEnter(LPDATAOBJECT, DWORD, POINTL, LPDWORD);
        STDMETHODIMP DragOver(DWORD, POINTL, LPDWORD);
        STDMETHODIMP DragLeave(void);
        STDMETHODIMP Drop(LPDATAOBJECT, DWORD, POINTL, LPDWORD);
    };


typedef CDropTarget FAR * LPCDropTarget;


class __far CDropSource : public IDropSource
    {
    protected:
        ULONG               m_cRef;      //Interface reference count.
        LPCSchmooDoc        m_pDoc;      //Back pointer to the document

    public:
        CDropSource(LPCSchmooDoc);
        ~CDropSource(void);

        //IDropSource interface members
        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        STDMETHODIMP QueryContinueDrag(BOOL, DWORD);
        STDMETHODIMP GiveFeedback(DWORD);
    };


typedef CDropSource FAR * LPCDropSource;



//Include classes necessary to become an OLE 2.0 server.
#include "schmoole.h"


#endif //_SCHMOO_H_
