/*
 * ICLASSF.CPP
 *
 * Implementation of an IClassFactory interface for Patron to enable
 * linking to its embedded objects.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#include "patron.h"



/*
 * CLinkClassFactory::CLinkClassFactory
 * CLinkClassFactory::~CLinkClassFactory
 *
 * Constructor Parameters:
 *  pFR             LPCLinkFrame that can create documents.
 */

CLinkClassFactory::CLinkClassFactory(LPCPatronFrame pFR)
    {
    m_cRef=0L;
    m_pFR=pFR;
    return;
    }


CLinkClassFactory::~CLinkClassFactory(void)
    {
    return;
    }






/*
 * CLinkClassFactory::QueryInterface
 * CLinkClassFactory::AddRef
 * CLinkClassFactory::Release
 */

STDMETHODIMP CLinkClassFactory::QueryInterface(REFIID riid, LPVOID FAR *ppv)
    {
    *ppv=NULL;

    //Any interface on this object is the object pointer.
    if (IsEqualIID(riid, IID_IUnknown) || IsEqualIID(riid, IID_IClassFactory))
        *ppv=(LPVOID)this;

    /*
     * If we actually assign an interface to ppv we need to AddRef it
     * since we're returning a new pointer.
     */
    if (NULL!=*ppv)
        {
        ((LPUNKNOWN)*ppv)->AddRef();
        return NOERROR;
        }

    return ResultFromScode(E_NOINTERFACE);
    }


STDMETHODIMP_(ULONG) CLinkClassFactory::AddRef(void)
    {
    return ++m_cRef;
    }


STDMETHODIMP_(ULONG) CLinkClassFactory::Release(void)
    {
    ULONG           cRefT;

    cRefT=--m_cRef;

    if (0L==m_cRef)
        delete this;

    return cRefT;
    }







/*
 * CLinkClassFactory::CreateInstance
 *
 * Purpose:
 *  Instantiates a Figure object that supports embedding.
 *
 * Parameters:
 *  punkOuter       LPUNKNOWN to the controlling IUnknown if we are
 *                  being used in an aggregation.
 *  riid            REFIID identifying the interface the caller desires
 *                  to have for the new object.
 *  ppvObj          LPVOID FAR * in which to store the desired interface
 *                  pointer for the new object.
 *
 * Return Value:
 *  HRESULT         NOERROR if successful, otherwise contains E_NOINTERFACE
 *                  if we cannot support the requested interface.
 */

STDMETHODIMP CLinkClassFactory::CreateInstance(LPUNKNOWN punkOuter
    , REFIID riid, LPVOID FAR *ppvObj)
    {
    LPCPatronDoc        pDoc;
    HRESULT             hr;

    *ppvObj=NULL;

    hr=ResultFromScode(E_OUTOFMEMORY);

    //We don't support aggregation
    if (NULL!=punkOuter)
        return ResultFromScode(CLASS_E_NOAGGREGATION);

    //If NewDocument fails the doc destructor calls ObjectDestroyed.
    //g_cObj++;

    //Try creating a new document, which creates the object.
    pDoc=(LPCPatronDoc)m_pFR->m_pCL->NewDocument(TRUE, m_pFR->m_pAdv);

    //ObjectDestroyed has already been called.
    if (NULL==pDoc)
        {
        g_cObj++;
        ObjectDestroyed();
        return hr;
        }

    /*
     * We don't want to do any file initialization here because we want
     * to wait for IPersistFile calls.  If we called ULoad(NULL) we'd
     * create storages and whatnot that we don't want in this case.
     */

    hr=pDoc->QueryInterface(riid, ppvObj);

    if (FAILED(hr))
        {
        m_pFR->m_pCL->CloseDocument(pDoc);
        g_cObj++;
        ObjectDestroyed();
        return hr;
        }

    return NOERROR;
    }






/*
 * CLinkClassFactory::LockServer
 *
 * Purpose:
 *  Increments or decrements the lock count of the serving IClassFactory
 *  object.  When the number of locks goes to zero and the number of
 *  objects is zero, we shut down the application.
 *
 * Parameters:
 *  fLock           BOOL specifying whether to increment or decrement the
 *                  lock count.
 *
 * Return Value:
 *  HRESULT         NOERROR always.
 */

STDMETHODIMP CLinkClassFactory::LockServer(BOOL fLock)
    {
    if (fLock)
        g_cLock++;
    else
        {
        g_cLock--;

        /*
         * To centralize shutdown, we'll artificially increase the object
         * count here and call ObjectDestroyed, which will decrement the
         * count, see that there are no objects or locks, then shut down.
         */
        g_cObj++;
        ObjectDestroyed();
        }

    return NOERROR;
    }
