/*
 * PATRON.H
 * Modifications for Chapter 14
 *
 * Single include file that pulls in everything needed for other source
 * files in the application.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _PATRON_H_
#define _PATRON_H_

#include <windows.h>

#include <ole2.h>
#include <ole2ver.h>
#include <ole2ui.h>
#include <bookguid.h>

extern "C"
    {
    #include <commdlg.h>
    #include <print.h>
    }

#include <classlib.h>
#include "resource.h"
#include "pages.h"


//PATRON.CPP:  Frame object that creates a main window

class __far CPatronFrame : public CFrame
    {
    //For access to m_pCL for document creation
    friend class CLinkClassFactory;

    private:
        BOOL            m_fInitialized;     //OleInitialize worked
        BOOL            m_fEmbedding;       //-Embedding on command line?
        DWORD           m_dwRegCO;          //From CoRegisterClassObject
        LPCLASSFACTORY  m_pIClassFactory;

    protected:
        //Overridable for creating a CPatronClient
        virtual LPCClient CreateCClient(void);

        virtual BOOL      FMessageHook(HWND, UINT, WPARAM, LPARAM, LRESULT FAR *);
        virtual BOOL      FRegisterAllClasses(void);

        virtual BOOL      FPreShowInit(void);
        virtual void      ParseCommandLine(void);

        virtual UINT      CreateGizmos(void);
        virtual LRESULT   OnCommand(HWND, WPARAM, LPARAM);

    public:
        CPatronFrame(HINSTANCE, HINSTANCE, LPSTR, int);
        virtual ~CPatronFrame(void);

        //Overrides
        BOOL FInit(LPFRAMEINIT);

        virtual void     UpdateMenus(HMENU, UINT);
        virtual void     UpdateGizmos(void);

    };


typedef CPatronFrame FAR * LPCPatronFrame;



//These are global for simplification of object implementation.
extern ULONG g_cObj;
extern ULONG g_cLock;
extern HWND  g_hWnd;

//Type for an object-destroyed callback
typedef void (FAR PASCAL *LPFNDESTROYED)(void);

//Function for the object to notify on destruction.
void FAR PASCAL ObjectDestroyed(void);


//ICLASSF.CPP

class __far CLinkClassFactory : public IClassFactory
    {
    protected:
        ULONG           m_cRef;
        LPCPatronFrame  m_pFR;          //For document creation.

    public:
        CLinkClassFactory(LPCPatronFrame);
        ~CLinkClassFactory(void);

        //IUnknown members
        STDMETHODIMP         QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //IClassFactory members
        STDMETHODIMP         CreateInstance(LPUNKNOWN, REFIID, LPVOID FAR *);
        STDMETHODIMP         LockServer(BOOL);
    };

typedef CLinkClassFactory FAR * LPCLinkClassFactory;





//CLIENT.CPP

/*
 * The only reason we have a derived class here is to override
 * CreateCDocument so we can create our own type as well as
 * overriding NewDocument to perform one other piece of work once the
 * document's been created.
 */

class __far CPatronClient : public CClient
    {
    protected:
        //Overridable for creating a new CDocument
        virtual LPCDocument CreateCDocument();

    public:
        CPatronClient(HINSTANCE);
        virtual ~CPatronClient(void);
    };

typedef CPatronClient FAR * LPCPatronClient;



//DOCUMENT.CPP

//Constant ID for the pages window that lives in a document window
#define ID_PAGES            723

/*
 * To support linking to embeddings, the document needs to have
 * IPersistFile and IOleItemContainer interfaces, so we multiply
 * inherit from IUnknown and provide two interface implementations.
 */

class __far CPatronDoc : public CDocument, public IUnknown
    {
    //These need access to FQueryPasteFromData, FPasteFromData
    friend class CDropTarget;
    friend class CDropSource;

    friend class CImpIPersistFile;
    friend class CImpIOleItemContainer;

    protected:
        LONG            m_lVer;         //Loaded data version
        LPCPages        m_pPG;          //Pages window in us.
        LPSTORAGE       m_pIStorage;    //Root storage for document.
        BOOL            m_fPrintSetup;  //Enable printer setup if no tenants.

        class CDropTarget FAR *m_pDropTarget;   //Registered target.

        UINT            m_cfEmbeddedObject;     //Clipboard formats
        UINT            m_cfObjectDescriptor;
        UINT            m_cfLinkSource;
        UINT            m_cfLinkSrcDescriptor;
        BOOL            m_fShowTypes;           //Show Objects active?

        ULONG               m_cRef;
        BOOL                m_fRename;          //Rename on USave?
        LPPERSISTFILE       m_pIPersistFile;
        LPOLEITEMCONTAINER  m_pIOleItemContainer;

    protected:
        virtual BOOL     FMessageHook(HWND, UINT, WPARAM, LPARAM, LRESULT FAR *);
        BOOL             FQueryPasteFromData(LPDATAOBJECT, LPFORMATETC, LPTENANTTYPE);
        BOOL             FQueryPasteLinkFromData(LPDATAOBJECT, LPFORMATETC, LPTENANTTYPE);
        BOOL             FPasteFromData(LPDATAOBJECT, LPFORMATETC, TENANTTYPE
                             , LPPATRONOBJECT, DWORD, BOOL);

    public:
        CPatronDoc(HINSTANCE);
        virtual ~CPatronDoc(void);

        //We now need our ubiquitous set of IUnknown members.
        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        virtual BOOL     FInit(LPDOCUMENTINIT);
        virtual void     Clear(void);

        virtual BOOL     FDirtyGet(void);
        virtual void     Delete(void);
        virtual BOOL     FQueryPrinterSetup(void);
        virtual BOOL     FQueryObjectSelected(HMENU);

        virtual UINT     ULoad(BOOL, LPSTR);
        virtual UINT     USave(UINT, LPSTR);

        virtual BOOL     Print(HWND);
        virtual UINT     PrinterSetup(HWND, BOOL);

        virtual BOOL     FClip(HWND, BOOL);
        virtual BOOL     FQueryPaste(void);
        virtual BOOL     FPaste(HWND);
        virtual BOOL     FPasteSpecial(HWND);
        virtual BOOL     FQueryEnableEditLinks(void);
        virtual BOOL     FEditLinks(HWND);
        virtual BOOL     FShowOrQueryObjectTypes(BOOL, BOOL);

        //CHAPTER14MOD
        virtual BOOL     FConvertObject(HWND);
        //End CHAPTER14MOD

        virtual UINT     NewPage(void);
        virtual UINT     DeletePage(void);
        virtual UINT     NextPage(void);
        virtual UINT     PreviousPage(void);
        virtual UINT     FirstPage(void);
        virtual UINT     LastPage(void);
        virtual void     Rename(LPSTR);
        virtual BOOL     FInsertObject(HWND);
        virtual void     ActivateObject(UINT);
    };

typedef CPatronDoc FAR * LPCPatronDoc;



//IPersistFile implementation for CPatronDoc

class __far CImpIPersistFile : public IPersistFile
    {
    protected:
        ULONG               m_cRef;      //Interface reference count.
        LPCPatronDoc        m_pDoc;      //Back pointer to the object.
        LPUNKNOWN           m_punkOuter; //Controlling unknown for delegation.

    public:
        CImpIPersistFile(LPCPatronDoc, LPUNKNOWN);
        ~CImpIPersistFile(void);

        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        STDMETHODIMP GetClassID(LPCLSID);

        STDMETHODIMP IsDirty(void);
        STDMETHODIMP Load(LPCSTR, DWORD);
        STDMETHODIMP Save(LPCSTR, BOOL);
        STDMETHODIMP SaveCompleted(LPCSTR);
        STDMETHODIMP GetCurFile(LPSTR FAR *);
    };



/*
 * IOleItemContainer implementation for both CPatronDoc and CPage, therefore
 * we use LPVOID as the back pointer.
 */

class __far CImpIOleItemContainer : public IOleItemContainer
    {
    protected:
        ULONG               m_cRef;      //Interface reference count.
        class CPage FAR    *m_pPage;     //Back pointer to the object,
        LPCPatronDoc        m_pDoc;      //Convenient naming & types
        LPUNKNOWN           m_punkOuter; //Controlling unknown for delegation.
        BOOL                m_fDoc;      //Document or page?

    private:
        BOOL         FTenantFromName(LPSTR, LPTENANT FAR *);

    public:
        CImpIOleItemContainer(LPVOID, LPUNKNOWN, BOOL);
        ~CImpIOleItemContainer(void);

        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        STDMETHODIMP ParseDisplayName(LPBC, LPSTR, ULONG FAR *, LPMONIKER FAR *);
        STDMETHODIMP EnumObjects(DWORD, LPENUMUNKNOWN FAR *);
        STDMETHODIMP LockContainer(BOOL);
        STDMETHODIMP GetObject(LPSTR, DWORD, LPBINDCTX, REFIID, LPVOID FAR *);
        STDMETHODIMP GetObjectStorage(LPSTR, LPBINDCTX, REFIID, LPVOID FAR *);
        STDMETHODIMP IsRunning(LPSTR);
    };







//Drag-drop *objects* we need in the document

class __far CDropTarget : public IDropTarget
    {
    protected:
        ULONG               m_cRef;      //Interface reference count.
        LPCPatronDoc        m_pDoc;      //Back pointer to the document

        LPDATAOBJECT        m_pIDataObject;  //Data object from DragEnter
        BOOL                m_fPendingRepaint;
        POINTL              m_ptPick;        //Pick-up offsets
        POINTL              m_ptLast;        //Last drag point
        SIZEL               m_szl;           //Object size
        BOOL                m_fFeedback;     //Draw feedback?
        FORMATETC           m_fe;            //Real dropping format.

    public:
        CDropTarget(LPCPatronDoc);
        ~CDropTarget(void);

        //IDropTarget interface members
        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        STDMETHODIMP DragEnter(LPDATAOBJECT, DWORD, POINTL, LPDWORD);
        STDMETHODIMP DragOver(DWORD, POINTL, LPDWORD);
        STDMETHODIMP DragLeave(void);
        STDMETHODIMP Drop(LPDATAOBJECT, DWORD, POINTL, LPDWORD);
    };


typedef CDropTarget FAR * LPCDropTarget;


class __far CDropSource : public IDropSource
    {
    protected:
        ULONG               m_cRef;      //Interface reference count.

    public:
        CDropSource(void);
        ~CDropSource(void);

        //IDropSource interface members
        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        STDMETHODIMP QueryContinueDrag(BOOL, DWORD);
        STDMETHODIMP GiveFeedback(DWORD);
    };


typedef CDropSource FAR * LPCDropSource;






#endif //_PATRON_H_
