/*
 * SCHMOOLE.H
 * Chapter 14 Modifications
 *
 * Include file containing all compound document related definitions.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _SCHMOOLE_H_
#define _SCHMOOLE_H_


//These are global for simplification of object implementation.
extern ULONG g_cObj;
extern ULONG g_cLock;
extern HWND  g_hWnd;

//Type for an object-destroyed callback
typedef void (FAR PASCAL *LPFNDESTROYED)(void);

//Function for the object to notify on destruction.
void FAR PASCAL ObjectDestroyed(void);


//ICLASSF.CPP
class __far CFigureClassFactory : public IClassFactory
    {
    protected:
        ULONG           m_cRef;         //Reference count on class object
        LPCSchmooFrame  m_pFR;          //For document creation.
        BOOL            m_fCreated;     //Have we created one object yet?

    public:
        CFigureClassFactory(LPCSchmooFrame);
        ~CFigureClassFactory(void);

        //IUnknown members
        STDMETHODIMP         QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //IClassFactory members
        STDMETHODIMP         CreateInstance(LPUNKNOWN, REFIID, LPVOID FAR *);
        STDMETHODIMP         LockServer(BOOL);
    };

typedef CFigureClassFactory FAR * LPCFigureClassFactory;


//FIGURE.CPP
//This is what the class factory creates

#define CFORMATETCGET   5   //Private, Embed Source, Obj Descript, MF, Bmp.

class __far CFigure : public IUnknown
    {
    friend class CImpIPersistStorage;
    friend class CImpIDataObject;
    friend class CImpIOleObject;
    friend class CImpIPersistFile;

    protected:
        ULONG               m_cRef;
        LPCSchmooFrame      m_pFR;          //Frame (for UI manipulation)
        LPCSchmooDoc        m_pDoc;         //What holds the real polyline
        LPCPolyline         m_pPL;          //Copy of m_pDoc->m_pPL

        BOOL                m_fEmbedded;    //TRUE on IOleObject::SetHostNames

        LPFNDESTROYED       m_pfnDestroy;   //Function to call on closure.
        LPPERSISTSTORAGE    m_pIPersistStorage;

        //Things for IDataObject
        LPDATAOBJECT        m_pIDataObject;         //Implemented
        LPDATAADVISEHOLDER  m_pIDataAdviseHolder;   //Used

        UINT                m_cf;                   //Copy of pDoc->m_cf
        ULONG               m_cfeGet;
        FORMATETC           m_rgfeGet[CFORMATETCGET];

        //Things for IOleObject
        LPOLEOBJECT         m_pIOleObject;          //Implemented
        LPOLEADVISEHOLDER   m_pIOleAdviseHolder;    //Used
        LPOLECLIENTSITE     m_pIOleClientSite;      //Used

        LPMONIKER           m_pMoniker;             //Copy of m_pDoc->m_pMoniker
        DWORD               m_dwRegROT;             //For IOleObject::SetMoniker
        LPPERSISTFILE       m_pIPersistFile;

    public:
        CFigure(LPFNDESTROYED, LPCSchmooDoc);
        ~CFigure(void);

        //Non-delegating IUnknown:  we don't support aggregation here.
        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        BOOL FInit(void);
        void FrameSet(LPCSchmooFrame);
        BOOL FIsDirty(void);
        BOOL FIsEmbedded(void);
        void SendAdvise(UINT);
    };

typedef CFigure * LPCFigure;

//Codes for CFigure::SendAdvise
//......Code........................... Method called in CFigureSendAdvise...
#define OBJECTCODE_SAVED          0     //IOleAdviseHolder::SendOnSave
#define OBJECTCODE_CLOSED         1     //IOleAdviseHolder::SendOnClose
#define OBJECTCODE_RENAMED        2     //IOleAdviseHolder::SendOnRename
#define OBJECTCODE_SAVEOBJECT     3     //IOleClientSite::SaveObject
#define OBJECTCODE_DATACHANGED    4     //IDataAdviseHolder::SendOnDataChange
#define OBJECTCODE_SHOWWINDOW     5     //IOleClientSite::OnShowWindow(TRUE)
#define OBJECTCODE_HIDEWINDOW     6     //IOleClientSite::OnShowWindow(FALSE)
#define OBJECTCODE_SHOWOBJECT     7    //IOleClientSite::ShowObject


//IPERSTOR.CPP

class __far CImpIPersistStorage : public IPersistStorage
    {
    protected:
        ULONG               m_cRef;      //Interface reference count.
        LPCFigure           m_pObj;      //The CFigure we work with.
        LPUNKNOWN           m_punkOuter; //Controlling unknown for delegation.
        //CHAPTER14MOD
        BOOL                m_fConvert;  //Are we Converting?
        CLSID               m_clsID;     //CLSID for GetClassID
        //End CHAPTER14MOD

    public:
        CImpIPersistStorage(LPCFigure, LPUNKNOWN);
        ~CImpIPersistStorage(void);

        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        STDMETHODIMP GetClassID(LPCLSID);

        STDMETHODIMP IsDirty(void);
        STDMETHODIMP InitNew(LPSTORAGE);
        STDMETHODIMP Load(LPSTORAGE);
        STDMETHODIMP Save(LPSTORAGE, BOOL);
        STDMETHODIMP SaveCompleted(LPSTORAGE);
        STDMETHODIMP HandsOffStorage(void);
    };



//IDATAOBJ.CPP
class __far CImpIDataObject : public IDataObject
    {
    private:
        ULONG           m_cRef;         //Interface reference count.
        LPCFigure       m_pObj;         //Back pointer to the object.
        LPUNKNOWN       m_punkOuter;    //Controlling unknown for delegation

    public:
        CImpIDataObject(LPCFigure, LPUNKNOWN);
        ~CImpIDataObject(void);

        //IUnknown members that delegate to m_punkOuter.
        STDMETHODIMP         QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //IDataObject members
        STDMETHODIMP GetData(LPFORMATETC, LPSTGMEDIUM);
        STDMETHODIMP GetDataHere(LPFORMATETC, LPSTGMEDIUM);
        STDMETHODIMP QueryGetData(LPFORMATETC);
        STDMETHODIMP GetCanonicalFormatEtc(LPFORMATETC, LPFORMATETC);
        STDMETHODIMP SetData(LPFORMATETC, STGMEDIUM FAR *, BOOL);
        STDMETHODIMP EnumFormatEtc(DWORD, LPENUMFORMATETC FAR *);
        STDMETHODIMP DAdvise(FORMATETC FAR *, DWORD,  LPADVISESINK, DWORD FAR *);
        STDMETHODIMP DUnadvise(DWORD);
        STDMETHODIMP EnumDAdvise(LPENUMSTATDATA FAR *);
    };


//IOLEOBJ.CPP
class __far CImpIOleObject : public IOleObject
    {
    private:
        ULONG           m_cRef;         //Interface reference count.
        LPCFigure       m_pObj;         //Back pointer to the object.
        LPUNKNOWN       m_punkOuter;    //Controlling unknown for delegation

    public:
        CImpIOleObject(LPCFigure, LPUNKNOWN);
        ~CImpIOleObject(void);

        //IUnknown members that delegate to m_punkOuter.
        STDMETHODIMP         QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //IOleObject members
        STDMETHODIMP SetClientSite(LPOLECLIENTSITE);
        STDMETHODIMP GetClientSite(LPOLECLIENTSITE FAR *);
        STDMETHODIMP SetHostNames(LPCSTR, LPCSTR);
        STDMETHODIMP Close(DWORD);
        STDMETHODIMP SetMoniker(DWORD, LPMONIKER);
        STDMETHODIMP GetMoniker(DWORD, DWORD, LPMONIKER FAR *);
        STDMETHODIMP InitFromData(LPDATAOBJECT, BOOL, DWORD);
        STDMETHODIMP GetClipboardData(DWORD, LPDATAOBJECT FAR *);
        STDMETHODIMP DoVerb(LONG, LPMSG, LPOLECLIENTSITE, LONG, HWND, LPCRECT);
        STDMETHODIMP EnumVerbs(LPENUMOLEVERB FAR *);
        STDMETHODIMP Update(void);
        STDMETHODIMP IsUpToDate(void);
        STDMETHODIMP GetUserClassID(CLSID FAR *);
        STDMETHODIMP GetUserType(DWORD, LPSTR FAR *);
        STDMETHODIMP SetExtent(DWORD, LPSIZEL);
        STDMETHODIMP GetExtent(DWORD, LPSIZEL);
        STDMETHODIMP Advise(LPADVISESINK, DWORD FAR *);
        STDMETHODIMP Unadvise(DWORD);
        STDMETHODIMP EnumAdvise(LPENUMSTATDATA FAR *);
        STDMETHODIMP GetMiscStatus(DWORD, DWORD FAR *);
        STDMETHODIMP SetColorScheme(LPLOGPALETTE);
    };



class __far CImpIPersistFile : public IPersistFile
    {
    protected:
        ULONG               m_cRef;      //Interface reference count.
        LPCFigure           m_pObj;      //Back pointer to the object.
        LPUNKNOWN           m_punkOuter; //Controlling unknown for delegation.

    public:
        CImpIPersistFile(LPCFigure, LPUNKNOWN);
        ~CImpIPersistFile(void);

        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        STDMETHODIMP GetClassID(LPCLSID);

        STDMETHODIMP IsDirty(void);
        STDMETHODIMP Load(LPCSTR, DWORD);
        STDMETHODIMP Save(LPCSTR, BOOL);
        STDMETHODIMP SaveCompleted(LPCSTR);
        STDMETHODIMP GetCurFile(LPSTR FAR *);
    };


#endif _SCHMOOLE_H_
