/*
 * SCHMOO.H
 * Chapter 8 Modification
 *
 * Single include file that pulls in everything needed for other source
 * files in the Schmoo application.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _SCHMOO_H_
#define _SCHMOO_H_

#include <windows.h>
#include <memory.h>
#include <ole2.h>   //Required for storage use
#include <ole2ver.h>
#include <bookguid.h>

//These include files reference DLLs that don't have extern "C" already
extern "C"
    {
    #include <commdlg.h>
    }

#include <classlib.h>
#include "resource.h"


//Get the editor window information.
#include "polyline.h"



//SCHMOO.CPP:  Frame object that creates a main window

class __far CSchmooFrame : public CFrame
    {
    private:
        HBITMAP         m_hBmpLines[5];     //Menu item bitmaps
        BOOL            m_fInitialized;     //Did CoInitalize work?

    protected:
        //Overridable for creating a CClient for this frame
        virtual LPCClient CreateCClient(void);

        virtual BOOL      FRegisterAllClasses(void);
        virtual BOOL      FPreShowInit(void);
        virtual UINT      CreateGizmos(void);

        virtual LRESULT   OnCommand(HWND, WPARAM, LPARAM);
        virtual void      OnDocumentDataChange(LPCDocument);
        virtual void      OnDocumentActivate(LPCDocument);

        //New for this class
        virtual void      CreateLineMenu(void);

    public:
        CSchmooFrame(HINSTANCE, HINSTANCE, LPSTR, int);
        virtual ~CSchmooFrame(void);

        //Overrides
        virtual BOOL      FInit(LPFRAMEINIT);
        virtual void      UpdateMenus(HMENU, UINT);
        virtual void      UpdateGizmos(void);

        //New for this class
        virtual void      CheckLineSelection(UINT);
    };


typedef CSchmooFrame FAR * LPCSchmooFrame;





//CLIENT.CPP

/*
 * The only reason we have a derived class here is to override
 * CreateCDocument so we can create our own type as well as
 * overriding NewDocument to perform one other piece of work once the
 * document's been created.
 */

class __far CSchmooClient : public CClient
    {
    protected:
        //Overridable for creating a new CDocument
        virtual LPCDocument CreateCDocument();

    public:
        CSchmooClient(HINSTANCE);
        virtual ~CSchmooClient(void);

        virtual LPCDocument NewDocument(BOOL, LPCDocumentAdviseSink);
    };


typedef CSchmooClient FAR * LPCSchmooClient;






//DOCUMENT.CPP

//Constant ID for the window polyline that lives in a document window
#define ID_POLYLINE         10

class __far CSchmooDoc : public CDocument
    {
    friend class CPolylineAdviseSink;

    //CHAPTER8MOD
    //These need access to FQueryPasteFromData, FPasteFromData
    friend class CDropTarget;
    friend class CDropSource;
    //End CHAPTER8MOD

    protected:
        UINT            m_uPrevSize;        //Last WM_SIZE wParam
        LONG            m_lVer;             //Loaded Polyline version

        LPCPolyline             m_pPL;      //Polyline Editor window in us.
        LPCPolylineAdviseSink   m_pPLAdv;   //Advises from Polyline

        //CHAPTER8MOD
        class CDropTarget FAR *m_pDropTarget;  //Registered target.

        BOOL            m_fDragSource;      //Drag-drop source==target
        //End CHAPTER8MOD

    protected:
        virtual BOOL    FMessageHook(HWND, UINT, WPARAM, LPARAM, LRESULT FAR *);

        virtual BOOL    FQueryPasteFromData(LPDATAOBJECT);
        virtual BOOL    FPasteFromData(LPDATAOBJECT);
        LPDATAOBJECT    TransferObjectCreate(void);

        //CHAPTER8MOD
        void            DropSelectTargetWindow(void);
        //End CHAPTER8MOD

    public:
        CSchmooDoc(HINSTANCE);
        virtual ~CSchmooDoc(void);

        virtual BOOL     FInit(LPDOCUMENTINIT);
        virtual void     Clear();

        virtual UINT     ULoad(BOOL, LPSTR);
        virtual UINT     USave(UINT, LPSTR);

        virtual void     Undo(void);
        virtual BOOL     FClip(HWND, BOOL);
        virtual HGLOBAL  RenderFormat(UINT);
        virtual BOOL     FQueryPaste(void);
        virtual BOOL     FPaste(HWND);

        virtual COLORREF ColorSet(UINT, COLORREF);
        virtual COLORREF ColorGet(UINT);

        virtual UINT     LineStyleSet(UINT);
        virtual UINT     LineStyleGet();
    };

typedef CSchmooDoc FAR * LPCSchmooDoc;


//These color indices wrap the polyline definitions
#define DOCCOLOR_BACKGROUND             POLYLINECOLOR_BACKGROUND
#define DOCCOLOR_LINE                   POLYLINECOLOR_LINE



//CHAPTER8MOD
//Drag-drop interfaces we need in the document
class __far CDropTarget : public IDropTarget
    {
    protected:
        ULONG               m_cRef;      //Interface reference count.
        LPCSchmooDoc        m_pDoc;      //Back pointer to the document

        LPDATAOBJECT        m_pIDataObject;  //Data object from DragEnter

    public:
        CDropTarget(LPCSchmooDoc);
        ~CDropTarget(void);

        //IDropTarget interface members
        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        STDMETHODIMP DragEnter(LPDATAOBJECT, DWORD, POINTL, LPDWORD);
        STDMETHODIMP DragOver(DWORD, POINTL, LPDWORD);
        STDMETHODIMP DragLeave(void);
        STDMETHODIMP Drop(LPDATAOBJECT, DWORD, POINTL, LPDWORD);
    };


typedef CDropTarget FAR * LPCDropTarget;


class __far CDropSource : public IDropSource
    {
    protected:
        ULONG               m_cRef;      //Interface reference count.
        LPCSchmooDoc        m_pDoc;      //Back pointer to the document

    public:
        CDropSource(LPCSchmooDoc);
        ~CDropSource(void);

        //IDropSource interface members
        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        STDMETHODIMP QueryContinueDrag(BOOL, DWORD);
        STDMETHODIMP GiveFeedback(DWORD);
    };


typedef CDropSource FAR * LPCDropSource;

//End CHAPTER8MOD


#endif //_SCHMOO_H_
