/*
 * HSCHMOO.H
 * Schmoo Figure Handler Chapter 11
 *
 * Definitions and function prototypes for the Schmoo Handler.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _HSCHMOO_H_
#define _HSCHMOO_H_

#include <windows.h>
#include <ole2.h>
#include <classlib.h>
#include <bookguid.h>
#include <ipoly6.h>      //For POLYLINEDATA definitions


#define HIMETRIC_PER_INCH           2540

//DLLSCHM.CPP
class __far CFigureClassFactory : public IClassFactory
    {
    protected:
        ULONG           m_cRef;         //Reference count on object

    public:
        CFigureClassFactory(void);
        ~CFigureClassFactory(void);

        //IUnknown members
        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //IClassFactory members
        STDMETHODIMP         CreateInstance(LPUNKNOWN, REFIID, LPVOID FAR *);
        STDMETHODIMP         LockServer(BOOL);
    };

typedef CFigureClassFactory FAR * LPCFigureClassFactory;


//Type for an object-destroyed callback
typedef void (FAR PASCAL *LPFNDESTROYED)(void);


//Some magic number to add to aspects for returns from IViewObject::Freeze
#define FREEZE_KEY_OFFSET       0x0723


//HSCHMOO.CPP
class __far CFigure : public IUnknown
    {
    //Make any contained interfaces your friends so they can get at privates
    friend class CImpIOleObject;
    friend class CImpIViewObject;
    friend class CImpIPersistStorage;
    friend class CImpIDataObject;
    friend class CImpIAdviseSink;

    protected:
        ULONG               m_cRef;         //Object reference count.
        LPUNKNOWN           m_punkOuter;    //Controlling Unknown for aggregation
        LPFNDESTROYED       m_pfnDestroy;   //Function to call on closure.

        POLYLINEDATA        m_pl;           //Our actual data.
        UINT                m_cf;           //Object clipboard format.
        CLSID               m_clsID;        //Current CLSID

        //These are default handler interfaces we use
        LPUNKNOWN           m_pDefIUnknown;
        LPOLEOBJECT         m_pDefIOleObject;
        LPVIEWOBJECT        m_pDefIViewObject;
        LPPERSISTSTORAGE    m_pDefIPersistStorage;
        LPDATAOBJECT        m_pDefIDataObject;

        //Implemented interfaces
        LPOLEOBJECT         m_pIOleObject;
        LPVIEWOBJECT        m_pIViewObject;
        LPPERSISTSTORAGE    m_pIPersistStorage;
        LPADVISESINK        m_pIAdviseSink;

        //Advise sink we get in IViewObject
        LPADVISESINK        m_pIAdvSinkView;
        DWORD               m_dwAdviseFlags;
        DWORD               m_dwAdviseAspects;
        DWORD               m_dwFrozenAspects;

        //Copies of frozen aspects
        POLYLINEDATA        m_plContent;
        POLYLINEDATA        m_plThumbnail;


    protected:
        void      Draw(HDC, LPRECT, DWORD, DVTARGETDEVICE FAR *, HDC, LPPOLYLINEDATA);
        void      PointScale(LPRECT, LPPOINT, BOOL);

    public:
        CFigure(LPUNKNOWN, LPFNDESTROYED, HINSTANCE);
        ~CFigure(void);

        BOOL      FInit(void);

        //Non-delegating object IUnknown
        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);
    };

typedef CFigure FAR * LPCFigure;



class __far CImpIPersistStorage : public IPersistStorage
    {
    protected:
        ULONG               m_cRef;      //Interface reference count.
        LPCFigure           m_pObj;      //Back pointer to the object.
        LPUNKNOWN           m_punkOuter; //Controlling unknown for delegation.

    public:
        CImpIPersistStorage(LPCFigure, LPUNKNOWN);
        ~CImpIPersistStorage(void);

        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        STDMETHODIMP GetClassID(LPCLSID);

        STDMETHODIMP IsDirty(void);
        STDMETHODIMP InitNew(LPSTORAGE);
        STDMETHODIMP Load(LPSTORAGE);
        STDMETHODIMP Save(LPSTORAGE, BOOL);
        STDMETHODIMP SaveCompleted(LPSTORAGE);
        STDMETHODIMP HandsOffStorage(void);
    };



class __far CImpIOleObject : public IOleObject
    {
    private:
        ULONG           m_cRef;         //Interface reference count.
        LPCFigure       m_pObj;         //Back pointer to the object.
        LPUNKNOWN       m_punkOuter;    //Controlling unknown for delegation

    public:
        CImpIOleObject(LPCFigure, LPUNKNOWN);
        ~CImpIOleObject(void);

        //IUnknown members that delegate to m_punkOuter.
        STDMETHODIMP         QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //IOleObject members
        STDMETHODIMP SetClientSite(LPOLECLIENTSITE);
        STDMETHODIMP GetClientSite(LPOLECLIENTSITE FAR *);
        STDMETHODIMP SetHostNames(LPCSTR, LPCSTR);
        STDMETHODIMP Close(DWORD);
        STDMETHODIMP SetMoniker(DWORD, LPMONIKER);
        STDMETHODIMP GetMoniker(DWORD, DWORD, LPMONIKER FAR *);
        STDMETHODIMP InitFromData(LPDATAOBJECT, BOOL, DWORD);
        STDMETHODIMP GetClipboardData(DWORD, LPDATAOBJECT FAR *);
        STDMETHODIMP DoVerb(LONG, LPMSG, LPOLECLIENTSITE, LONG, HWND, LPCRECT);
        STDMETHODIMP EnumVerbs(LPENUMOLEVERB FAR *);
        STDMETHODIMP Update(void);
        STDMETHODIMP IsUpToDate(void);
        STDMETHODIMP GetUserClassID(CLSID FAR *);
        STDMETHODIMP GetUserType(DWORD, LPSTR FAR *);
        STDMETHODIMP SetExtent(DWORD, LPSIZEL);
        STDMETHODIMP GetExtent(DWORD, LPSIZEL);
        STDMETHODIMP Advise(LPADVISESINK, DWORD FAR *);
        STDMETHODIMP Unadvise(DWORD);
        STDMETHODIMP EnumAdvise(LPENUMSTATDATA FAR *);
        STDMETHODIMP GetMiscStatus(DWORD, DWORD FAR *);
        STDMETHODIMP SetColorScheme(LPLOGPALETTE);
    };


class __far CImpIViewObject : public IViewObject
    {
    private:
        ULONG           m_cRef;         //Interface reference count.
        LPCFigure       m_pObj;         //Back pointer to the object.
        LPUNKNOWN       m_punkOuter;    //Controlling unknown for delegation

    public:
        CImpIViewObject(LPCFigure, LPUNKNOWN);
        ~CImpIViewObject(void);

        //IUnknown members that delegate to m_punkOuter.
        STDMETHODIMP         QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //IViewObject members
        STDMETHODIMP Draw(DWORD, LONG, LPVOID, DVTARGETDEVICE FAR *, HDC, HDC
            , const LPRECTL, const LPRECTL, BOOL (CALLBACK *)(DWORD), DWORD);
        STDMETHODIMP GetColorSet(DWORD, LONG, LPVOID, DVTARGETDEVICE FAR *
            , HDC, LPLOGPALETTE FAR *);
        STDMETHODIMP Freeze(DWORD, LONG, LPVOID, LPDWORD);
        STDMETHODIMP Unfreeze(DWORD);
        STDMETHODIMP SetAdvise(DWORD, DWORD, LPADVISESINK);
        STDMETHODIMP GetAdvise(LPDWORD, LPDWORD, LPADVISESINK FAR *);
    };


class __far CImpIAdviseSink : public IAdviseSink
    {
    protected:
        ULONG           m_cRef;         //Interface reference count.
        LPCFigure       m_pObj;         //Back pointer to the object.
        LPUNKNOWN       m_punkOuter;    //Controlling unknown for delegation.

    public:
        CImpIAdviseSink(LPCFigure, LPUNKNOWN);
        ~CImpIAdviseSink(void);

        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        STDMETHODIMP_(void)  OnDataChange(LPFORMATETC, LPSTGMEDIUM);
        STDMETHODIMP_(void)  OnViewChange(DWORD, LONG);
        STDMETHODIMP_(void)  OnRename(LPMONIKER);
        STDMETHODIMP_(void)  OnSave(void);
        STDMETHODIMP_(void)  OnClose(void);
    };


#endif  //_HSCHMOO_H_
