/*
 * IDROPSRC.CPP
 *
 * Template implementation of a DropSource object.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#include "idropsrc.h"



/*
 * CDropSource::CDropSource
 * CDropSource::~CDropSource
 *
 * Constructor Parameters:
 *  pObj            LPVOID back pointer to whatever we live with.
 */

CDropSource::CDropSource(LPVOID pBack)
    {
    m_cRef=0;
    m_pBack=pBack;
    return;
    }


CDropSource::~CDropSource(void)
    {
    return;
    }




/*
 * CDropSource::QueryInterface
 * CDropSource::AddRef
 * CDropSource::Release
 *
 * Purpose:
 *  IUnknown members for CDropSource object.
 */

STDMETHODIMP CDropSource::QueryInterface(REFIID riid, LPVOID FAR *ppv)
    {
    *ppv=NULL;

    //Any interface on this object is the object pointer.
    if (IsEqualIID(riid, IID_IUnknown) || IsEqualIID(riid, IID_IDropSource))
        *ppv=(LPVOID)this;

    /*
     * If we actually assign an interface to ppv we need to AddRef it
     * since we're returning a new pointer.
     */
    if (NULL!=*ppv)
        {
        ((LPUNKNOWN)*ppv)->AddRef();
        return NOERROR;
        }

    return ResultFromScode(E_NOINTERFACE);
    }


STDMETHODIMP_(ULONG) CDropSource::AddRef(void)
    {
    return ++m_cRef;
    }

STDMETHODIMP_(ULONG) CDropSource::Release(void)
    {
    ULONG   cRefT;

    cRefT=--m_cRef;

    if (0==m_cRef)
        delete this;

    return cRefT;
    }





/*
 * CDropSource::QueryDragContinue
 *
 * Purpose:
 *  Determines whether to continue a drag operation or cancel it.
 *
 * Parameters:
 *  fEsc            BOOL indicating that the ESC key was pressed.
 *  grfKeyState     DWORD providing states of keys and mouse buttons.
 *
 * Return Value:
 *  SCODE           DRAGDROP_S_CANCEL to stop the drag, DRAGDROP_S_DROP
 *                  to drop the data where it is, or NOERROR to continue.
 */

STDMETHODIMP CDropSource::QueryContinueDrag(BOOL fEsc, DWORD grfKeyState)
    {
    /*
     *  1.  If fEsc is TRUE, you'll generally cancel the operation,
     *      so return DRAGDROP_S_CANCEL.  Any other similar condition
     *      should return the same value.
     *
     *  2.  Test the opposite condition of what you started dragging on,
     *      usually a left mouse button click.  On this, cause a drop
     *      by returning DRAGDROP_S_DROP.
     *
     *  3.  Otherwise continue dragging by returning NOERROR.
     */

    if (fEsc)
        return ResultFromScode(DRAGDROP_S_CANCEL);

    if (!(grfKeyState & MK_LBUTTON))
        return ResultFromScode(DRAGDROP_S_DROP);

    return NOERROR;
    }






/*
 * CDropSource::GiveFeedback
 *
 * Purpose:
 *  Provides cursor feedback to the user since the source task
 *  always has the mouse capture.  We can also provide any other
 *  type of feedback above cursors if we so desire.
 *
 * Parameters:
 *  dwEffect        DWORD effect flags returned from the last target.
 *
 * Return Value:
 *  SCODE           NOERROR if you set a cursor yourself or
 *                  DRAGDROP_S_USEDEFAULTCURSORS to let OLE do the work.
 */

STDMETHODIMP CDropSource::GiveFeedback(DWORD dwEffect)
    {
    /*
     * Implementation:
     *  1.  If you want to control the cursor, case out each effect flag
     *      of interest in dwEffect and SetCursor to the desired cursor,
     *      then return NOERROR.
     *  2.  If you do not specifically SetCursor, return
     *      DRAGDROP_S_USEDEFAULTCURSORS.
     */

    return ResultFromScode(DRAGDROP_S_USEDEFAULTCURSORS);
    }
