/*
 * STATINT.C
 * StatStrip Version 1.00, March 1993
 *
 * Internal definitions and function prototypes for the StatStrip
 * control.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#include <win1632.h>
#include "stastrip.h"


//For loading the RCDATA mapping menu item IDs to string IDs
typedef struct tagSTATMESSAGEMAP
    {
    UINT        uID;
    UINT        idsMsg;
    } STATMESSAGEMAP, FAR *LPSTATMESSAGEMAP;

//Array mapping menu handles to menu item IDs
typedef struct tagPOPUPMENUMAP
    {
    HMENU       hMenu;
    UINT        uID;
    } POPUPMENUMAP, * PPOPUPMENUMAP, FAR *LPPOPUPMENUMAP;




typedef struct tagSTATSTRIP
    {
    HFONT               hFont;      //Current control font
    BOOL                fMyFont;

    BOOL                fMapped;    //Has StatStripMessageMap been called?
    HWND                hWndOwner;

    UINT                cMessages;  //Total number of messages we hold
    UINT                idsMin;     //Starting string ID
    UINT                idsMax;

    UINT                uIDStatic;  //Quiescent message ID
    UINT                uIDBlank;   //Blank message ID
    UINT                uIDSysMenu; //System menu message ID

    HGLOBAL             hMemSMM;    //Handle to STATMESSAGEMAP data
    LPSTATMESSAGEMAP    pSMM;       //Points to memory holding STATMESSAGEMAP

    HGLOBAL             hMemSzStat; //Memory for Stat strings
    LPSTR *             ppsz;       //Stat string pointers

    UINT                cPopups;
    UINT                uIDPopupMin;
    UINT                uIDPopupMax;
    PPOPUPMENUMAP       pPMM;
    } STATSTRIP, FAR *LPSTATSTRIP;


#define CBSTATSTRIP             sizeof(STATSTRIP)

#define CBWINDOWEXTRA           sizeof(LPSTATSTRIP)
#define STATWL_STRUCTURE        0


//STASTRIP.C
LRESULT FAR PASCAL  StatStripWndProc(HWND, UINT, WPARAM, LPARAM);
static void         StatStripPaint(HWND, LPSTATSTRIP);
static UINT         IDFromHMenu(LPSTATSTRIP, HMENU);
static UINT         IStringFromID(LPSTATMESSAGEMAP, UINT, UINT);

//INIT.C
void                StatStripClean(LPSTATSTRIP, BOOL);
static BOOL         FRegisterControl(HINSTANCE);
static HGLOBAL      HStringCache(HINSTANCE, UINT, UINT, UINT, LPSTR FAR *);
static void         HStringCacheFree(HGLOBAL);
static void         StatMessageMapSort(LPSTATMESSAGEMAP, UINT);
