/*
 * WIN1632.H
 *
 * Macros and other definitions that assist in porting between Win16
 * and Win32 applications.  Define WIN32 to enable 32-bit versions.
 *
 * Copyright (c)1993 Microsoft Corporation, All Right Reserved,
 * as applied to redistribution of this source code in source form
 * License is granted to use of compiled code in shipped binaries.
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 * One Microsoft Way
 * Redmond, WA  98052
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _WIN1632_H_
#define _WIN1632_H_

//Macros to handle control message packing between Win16 and Win32
#ifdef WIN32

#ifndef COMMANDPARAMS
#define COMMANDPARAMS(wID, wCode, hWndMsg)                      \
    WORD        wID     = LOWORD(wParam);                       \
    WORD        wCode   = HIWORD(wParam);                       \
    HWND        hWndMsg = (HWND)(UINT)lParam;
#endif  //COMMANDPARAMS

#ifndef SendCommand
#define SendCommand(hWnd, wID, wCode, hControl)                 \
            SendMessage(hDlg, WM_COMMAND, MAKELONG(wID, wCode)  \
                        , (LONG)hControl)
#endif  //SendCommand

#ifndef MENUSELECTPARAMS
#define MENUSELECTPARAMS(wID, wFlags, hMenu)                    \
    WORD        wID     = LOWORD(wParam);                       \
    WORD        wFlags  = HIWORD(wParam);                       \
    HMENU       hMenu   = (HMENU)lParam;
#endif  //MENUSELECTPARAMS

#else   //WIN32

#ifndef COMMANDPARAMS
#define COMMANDPARAMS(wID, wCode, hWndMsg)                      \
    WORD        wID     = LOWORD(wParam);                       \
    WORD        wCode   = HIWORD(lParam);                       \
    HWND        hWndMsg = (HWND)(UINT)lParam;
#endif  //COMMANDPARAMS

#ifndef SendCommand
#define SendCommand(hDlg, wID, wCode, hControl)                 \
            SendMessage(hDlg, WM_COMMAND, wID                   \
                        , MAKELONG(hControl, wCode))
#endif  //SendCommand

#ifndef MENUSELECTPARAMS
#define MENUSELECTPARAMS(wID, wFlags, hMenu)                    \
    WORD        wID     = (WORD)wParam;                         \
    WORD        wFlags  = LOWORD(lParam);                       \
    HMENU       hMenu   = (HMENU)HIWORD(lParam);
#endif  //MENUSELECTPARAMS

#endif  //WIN32

#endif  //_WIN1632_H_
