//
//  Ole2Test application
//
//  app.cpp - CApplication methods
//
//  Copyright 1993 Macromedia, Inc.
//
//  Initial Version:
//      J. Paul Kase, 5/23/93
//

#define LOCAL_APP
 
#include "ole2test.h"

#include <ole2.h>
#include <stdio.h>
extern "C" {
#include <ole2ui.h>
};

#include "app.hpp"
#include "ole2test.hpp"

char *gFilterString = "Ole2Test Files (*.O2T)\000*.o2t\000All files (*.*)\000*.*\000";
char gFileName[64] = "";

CApplication::CApplication ()
{
    this->hMainWnd = NULL;
    this->hInst = NULL;
    this->pDoc = NULL;
    this->pActiveObject = NULL;
    this->pInPlaceObject = NULL;
    this->rcBorder.left = this->rcBorder.top =
        this->rcBorder.right = this->rcBorder.bottom = 0;
}

BOOL CApplication::Init (HANDLE hInstance, int nCmdShow)
{
    WNDCLASS  wc;

    wc.style =          NULL;                    
    wc.lpfnWndProc =    (WNDPROC)MainWndProc;  
    wc.cbClsExtra =     0;                  
    wc.cbWndExtra =     0;
    wc.hInstance =      hInstance;           
    wc.hIcon =          LoadIcon(NULL, IDI_APPLICATION);
    wc.hCursor =        LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground =  GetStockObject(LTGRAY_BRUSH); 
    wc.lpszMenuName =   "OLE2TESTMenu";   
    wc.lpszClassName =  "ole2testWClass";

    RegisterClass (&wc);

    this->hInst = hInstance;

    OleInitialize (NULL);
        
    if (!(hMainWnd = CreateWindow ("ole2testWClass", "OLE2 Test Shell", 
                                   WS_OVERLAPPEDWINDOW, 
                                   CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, 
                                   NULL, NULL, hInstance, NULL)))
        return FALSE;
                                               
    this->NewDocument ();
    
    this->m_cfEmbedSource =         RegisterClipboardFormat(CF_EMBEDSOURCE);
    this->m_cfEmbeddedObject =      RegisterClipboardFormat(CF_EMBEDDEDOBJECT);
    this->m_cfLinkSource =          RegisterClipboardFormat(CF_LINKSOURCE);
    this->m_cfFileName =            RegisterClipboardFormat(CF_FILENAME);
    this->m_cfObjectDescriptor =    RegisterClipboardFormat(CF_OBJECTDESCRIPTOR); 
    this->m_cfLinkSrcDescriptor =   RegisterClipboardFormat(CF_LINKSRCDESCRIPTOR);
    
    this->fClipboardPriority[0].etc.cfFormat =  this->m_cfEmbedSource;
    this->fClipboardPriority[0].etc.ptd =       NULL;
    this->fClipboardPriority[0].etc.dwAspect =  DVASPECT_CONTENT;
    this->fClipboardPriority[0].etc.tymed =     TYMED_ISTORAGE;
    this->fClipboardPriority[0].etc.lindex =    -1;
    this->fClipboardPriority[0].bIsLink =       FALSE;
                                               
    this->fClipboardPriority[1].etc.cfFormat =  this->m_cfEmbeddedObject;
    this->fClipboardPriority[1].etc.ptd =       NULL;
    this->fClipboardPriority[1].etc.dwAspect =  DVASPECT_CONTENT;
    this->fClipboardPriority[1].etc.tymed =     TYMED_ISTORAGE;
    this->fClipboardPriority[1].etc.lindex =    -1;
    this->fClipboardPriority[1].bIsLink =       FALSE;
                                               
    this->fClipboardPriority[2].etc.cfFormat =  this->m_cfLinkSource;
    this->fClipboardPriority[2].etc.ptd =       NULL;
    this->fClipboardPriority[2].etc.dwAspect =  DVASPECT_CONTENT;
    this->fClipboardPriority[2].etc.tymed =     TYMED_ISTREAM;
    this->fClipboardPriority[2].etc.lindex =    -1;
    this->fClipboardPriority[2].bIsLink =       TRUE;
                                               
    this->fClipboardPriority[3].etc.cfFormat =  CF_TEXT;
    this->fClipboardPriority[3].etc.ptd =       NULL;
    this->fClipboardPriority[3].etc.dwAspect =  DVASPECT_CONTENT;
    this->fClipboardPriority[3].etc.tymed =     TYMED_HGLOBAL;
    this->fClipboardPriority[3].etc.lindex =    -1;
    this->fClipboardPriority[3].bIsLink =       FALSE;
                                               
    this->numClipFormats = 4;

    this->pUnknown = new CAppUnknown ();
    this->pInPlaceSite = new CAppInPlaceSite ();
    this->pInPlaceFrame = new CAppInPlaceFrame ();

    ShowWindow (this->hMainWnd, nCmdShow);
    UpdateWindow (this->hMainWnd);
    
    return TRUE;
}

CApplication::~CApplication (void) 
{
    delete this->pUnknown;
    delete this->pInPlaceSite;
    delete this->pInPlaceFrame;
}

LONG CApplication::MessageHandler (HWND hWnd, unsigned message, WORD wParam, LONG lParam)
{
    FARPROC lpProcAbout;          

    switch (message) {
      case WM_COMMAND:     
        switch (wParam) {
          case ID_HELP_ABOUT:
            lpProcAbout = MakeProcInstance ((FARPROC)About, this->GetHInst ());
            DialogBox (this->GetHInst (), "AboutBox", hWnd, lpProcAbout);
            FreeProcInstance (lpProcAbout);
            break;
                      
          case ID_FILE_NEW:
            this->pDoc->Clear ();
            break;

          case ID_FILE_SAVE:
            if (gFileName[0]) {
                this->pDoc->Save (gFileName);
                break;
            }
            // else, fall through

          case ID_FILE_SAVEAS:
            this->SaveAsDocument (hWnd);
            break;

          case ID_FILE_OPEN:
            this->OpenDocument (hWnd);
            break;

          case ID_OBJECT_INSERTOBJECT:
            this->InsertObjectDialog (hWnd);
            break;
            
          case ID_OBJECT_DEACTIVATE:
            pActiveObject->Deactivate ();
            break;

          case ID_EDIT_PASTELINK:
            this->PasteLink ();
            break;

          case ID_EDIT_PASTE:
            this->PasteObject ();
            break;

          case ID_EDIT_COPY:
            this->CopyObject ();
            break;

          case ID_NEW_TEXT:
            this->NewObject (OBJ_TEXT);
            break;
          case ID_NEW_RECTANGLE:
            this->NewObject (OBJ_RECT);
            break;
          case ID_NEW_ELLIPSE:
            this->NewObject (OBJ_ELLIPSE);
            break;
            
          case ID_FILE_EXIT:
            this->CloseDocument ();
            DestroyWindow (hWnd);
            break;
            
          case ID_EDIT_UNDO:
          case ID_EDIT_CUT:
            ErrorMessage ("Menu Item not yet implemented");
            break;

          default:
            if (wParam >= ID_OBJECT_VERB1 && wParam <= ID_OBJECT_VERBLAST) {
                this->DoVerb (wParam - ID_OBJECT_VERB1);
                break;
            }
            return DefWindowProc (hWnd, message, wParam, lParam);
        }
        break;

      case WM_CLOSE:
        this->CloseDocument ();
        break;
      
      case WM_SHOWWINDOW:
        if (wParam) {
            RegisterDragDrop (hWnd, this->pDoc->GetDropTarget ());
            CoLockObjectExternal ((IUnknown *)this->pDoc->GetDropTarget (),
                                  TRUE, FALSE);
        } else {
            RevokeDragDrop (hWnd);
            CoLockObjectExternal ((IUnknown *)this->pDoc->GetDropTarget (),
                                  FALSE, FALSE);
        }
        break;
          
      case WM_DESTROY:
        PostQuitMessage (0);
        break;

      case WM_PAINT:
      {
        PAINTSTRUCT ps;
        RECT rcTemp;

        BeginPaint (hWnd, &ps);
        
        ::GetClientRect (hWnd, &rcTemp);
        rcTemp.left += this->rcBorder.left;
        rcTemp.top += this->rcBorder.top;
        rcTemp.right -= this->rcBorder.right;
        rcTemp.bottom -= this->rcBorder.bottom;
        
        ::SetViewportOrg (ps.hdc, this->rcBorder.left, this->rcBorder.top);
            
        this->Update (ps.hdc);
        EndPaint (hWnd, &ps);
      }
       break;
        
      case WM_INITMENUPOPUP:
        if (wParam == GetSubMenu (GetMenu (hWnd), LOWORD(lParam)))
            this->InitMenuPopup (wParam, LOWORD(lParam));
        break;                 
        
      default:
        return DefWindowProc (hWnd, message, wParam, lParam);
    }
    return NULL;
}

void CApplication::InitObjectMenu (HMENU hObjectMenu)
{
    // the Object Menu may be displayed, so add the
    // DoVerb's for the last created object
    //
    HMENU           hDoVerbMenu, hOldMenu;
    CDrawnObject    *pDrawnObject;
    IOleObject      *pOleObject;
    IEnumOLEVERB    *pEnumOleVerb;
    OLEVERB         oleVerb;
    short           i;
    
    if (pDrawnObject = this->pDoc->FindLast ()) {
        if (pOleObject = pDrawnObject->GetOLEObject ()) {
            if (pOleObject->EnumVerbs (&pEnumOleVerb) == NOERROR) {
                hDoVerbMenu = CreatePopupMenu ();
                for (i=0; ; i++) {
                    if (pEnumOleVerb->Next (1, &oleVerb, NULL) != NOERROR)
                        break;
                    InsertMenu (hDoVerbMenu, (UINT)-1, 
                                MF_BYPOSITION | (UINT)oleVerb.fuFlags,
                                ID_OBJECT_VERB1 + i, oleVerb.lpszVerbName);
                }

                if (hOldMenu = GetSubMenu (hObjectMenu, ID_OBJECT_DOVERB - ID_OBJECT_INSERTOBJECT))
                    DestroyMenu (hOldMenu);
                                  
                RemoveMenu (hObjectMenu, ID_OBJECT_DOVERB - ID_OBJECT_INSERTOBJECT,
                            MF_BYPOSITION);                  
                InsertMenu (hObjectMenu, 
                            ID_OBJECT_DOVERB - ID_OBJECT_INSERTOBJECT,
                            MF_BYPOSITION | MF_POPUP, 
                            hDoVerbMenu,
                            "Do Verb");
            } else {
                pOleObject->Release ();
                goto disable_item;
            }    
            pOleObject->Release ();
        } else
            goto disable_item;
    } else 
        goto disable_item;
    
    return;
    
disable_item:    
    EnableMenuItem (hObjectMenu, ID_OBJECT_DOVERB - ID_OBJECT_INSERTOBJECT,
                    MF_BYPOSITION | MF_DISABLED | MF_GRAYED);
}

void CApplication::DoVerb (short index)
{
    CDrawnObject    *pDrawnObject;
    IOleObject      *pOleObject;
    IOleClientSite  *pClientSite;
    RECT            rcTemp;

    if (pDrawnObject = this->pDoc->FindLast ()) 
        if (pOleObject = pDrawnObject->GetOLEObject ()) {
            pDrawnObject->GetRect (&rcTemp);
            if (((COLEObject *)pDrawnObject)->QueryInterface (IID_IOleClientSite, 
                                                              (LPVOID *)&pClientSite) == NOERROR) {
                pOleObject->DoVerb (index, NULL, pClientSite,
                                    -1, this->hMainWnd, &rcTemp);
                pClientSite->Release ();
            }                          
            pOleObject->Release ();
        }
}

void CApplication::ResizeFrame (void)
{
    IOleInPlaceActiveObject *pInPlaceActiveObject;
    RECT rcPos, rcClient, rcClip;

    if (this->pActiveObject) {
        if (this->pInPlaceObject) {
            ::GetClientRect (this->hMainWnd, &rcClient);
            this->pActiveObject->GetRect (&rcPos);
            rcPos.left += this->rcBorder.left;
            rcPos.top += this->rcBorder.top;
            rcPos.right += this->rcBorder.left;
            rcPos.bottom += this->rcBorder.top;
            ::IntersectRect (&rcClip, &rcPos, &rcClient);

            this->pInPlaceObject->SetObjectRects (&rcPos, &rcClip);
            
            if (this->pActiveObject->QueryInterface (IID_IOleInPlaceActiveObject, (LPVOID *)&pInPlaceActiveObject) == NOERROR) {
                pInPlaceActiveObject->ResizeBorder (&rcClient, this->pInPlaceFrame, TRUE);
                pInPlaceActiveObject->Release ();
            }    
        }
    }
}

BOOL _export FAR PASCAL About (HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{
    switch (message) {
      case WM_INITDIALOG:
        return TRUE;

      case WM_COMMAND:
        if (wParam == IDOK || wParam == IDCANCEL) {
            EndDialog(hDlg, TRUE);
            return TRUE;
        }
        break;
    }
    return FALSE;
}

void CApplication::NewDocument (void)
{
    char buff[100];
    
    this->CloseDocument ();
    
    if (this->pDoc = new CDocument (this->hMainWnd))
        this->pDoc->AddRef ();
                
    sprintf (buff, "OLE2 Test Shell -- %s", this->pDoc->GetTitle ());
    ::SetWindowText (this->hMainWnd, buff);
}

BOOL CApplication::OpenDocument (HWND hWnd)
{
    OPENFILENAME ofn;
    char szFileName[256];

    _fmemset (&ofn, 0, sizeof(OPENFILENAME));

    szFileName[0]='\0';

    ofn.lStructSize =   sizeof(OPENFILENAME);
    ofn.hwndOwner =     hWnd;
    ofn.lpstrFilter =   gFilterString;
    ofn.lpstrFile =     szFileName;
    ofn.nMaxFile =      sizeof(szFileName);
    ofn.Flags =         OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
    ofn.lpstrDefExt =   "O2T";

    if (::GetOpenFileName (&ofn)) {
        this->pDoc->Clear ();
        strcpy (gFileName, szFileName);
        this->pDoc->Load (gFileName);
    }
    return TRUE;
}

BOOL CApplication::SaveAsDocument (HWND hWnd)
{
    OPENFILENAME ofn;
    char szFileName[256]="";

    _fmemset((LPOPENFILENAME)&ofn,0,sizeof(OPENFILENAME));

    ofn.lStructSize =   sizeof(OPENFILENAME);
    ofn.hwndOwner =     hWnd;
    ofn.lpstrFilter =   gFilterString;
    ofn.lpstrFile =     szFileName;
    ofn.nMaxFile =      sizeof(szFileName);

    ofn.Flags =         OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY;
    ofn.lpstrDefExt =   "O2T";

    if (::GetSaveFileName (&ofn)) {
        strcpy (gFileName, szFileName);
        this->pDoc->Save (gFileName);
    }
    return TRUE;
}

BOOL CApplication::InsertObjectDialog (HWND hWnd)
{
    OLEUIINSERTOBJECT io;
    char szFile[OLEUI_CCHPATHMAX];
    DWORD dwOleCreateType;

    _fmemset (szFile, 0, OLEUI_CCHPATHMAX);
    _fmemset (&io, 0, sizeof(io));
    
    io.cbStruct=sizeof(io);
    io.dwFlags=IOF_SELECTCREATENEW | IOF_SHOWHELP;
    io.hWndOwner=this->hMainWnd;

    io.lpszFile=(LPSTR)szFile;
    io.cchFile=sizeof(szFile);

    if (OleUIInsertObject (&io) == OLEUI_OK) {

        // Only try to create new objects IF Create New was selected
        //
        if ((io.dwFlags & IOF_SELECTCREATENEW)) 
            dwOleCreateType = IOF_SELECTCREATENEW;
        else
            {
            if ((io.dwFlags & IOF_SELECTCREATEFROMFILE))
                dwOleCreateType = IOF_SELECTCREATEFROMFILE;

            if ((io.dwFlags & IOF_CHECKLINK))
                dwOleCreateType = IOF_CHECKLINK;
            }
    }
    return TRUE;
}

BOOL CApplication::CloseDocument (void)
{
    if (this->pDoc)
        return !!this->pDoc->Release ();  // close that puppy
        
    return FALSE;
}

void CApplication::Terminate (void)
{
    this->CloseDocument ();    

    OleUninitialize ();
}

void CApplication::NewObject (short type)
{
    if (this->pDoc) {
        this->pDoc->NewObject (type, NULL);
        ::InvalidateRect (this->hMainWnd, NULL, FALSE);
    }
}

void CApplication::Update (HDC hDC)
{
    if (this->pDoc)
        this->pDoc->Update (hDC);
}

void CApplication::InitMenuPopup (HMENU hMenu, short whichMenu)
{
    switch (whichMenu) {
      case FILE_MENU:
        break;
      case EDIT_MENU:
        EnableMenuItem (hMenu, ID_EDIT_UNDO, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
        EnableMenuItem (hMenu, ID_EDIT_CUT, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
        EnableMenuItem (hMenu, ID_EDIT_COPY, MF_BYCOMMAND | 
                        ((!!this->pDoc->FindLast ()) ? MF_ENABLED : (MF_DISABLED | MF_GRAYED)));
        EnableMenuItem (hMenu, ID_EDIT_PASTE, MF_BYCOMMAND | 
                        ((this->CanEnablePaste (FALSE) != -1) ? MF_ENABLED : (MF_DISABLED | MF_GRAYED)));
        EnableMenuItem (hMenu, ID_EDIT_PASTELINK, MF_BYCOMMAND | 
                        ((this->CanEnablePaste (TRUE) != -1) ? MF_ENABLED : (MF_DISABLED | MF_GRAYED)));
        break;     
      case OBJECT_MENU:
        this->InitObjectMenu (hMenu);
        EnableMenuItem (hMenu, ID_OBJECT_DEACTIVATE, (this->pActiveObject ? 
                        (MF_BYCOMMAND | MF_ENABLED) : (MF_BYCOMMAND | MF_DISABLED | MF_GRAYED)));
        break;
      case NEW_MENU:
        break;
      case HELP_MENU:
        break;
    }
}

short CApplication::CanEnablePaste (BOOL bLink)
{
    IDataObject     *pClipboardDataObj;
    short           answer = -1;

    if (IsClipboardFormatAvailable (RegisterClipboardFormat ("Ole2Test")) &&
        !bLink)
        return TRUE;

    if (OleGetClipboard (&pClipboardDataObj) == NOERROR) {
        answer = this->pDoc->CanAccept (pClipboardDataObj, bLink);
        pClipboardDataObj->Release ();
    }
    return answer;
}

void CApplication::PasteLink ()
{
    IDataObject *pClipboardDataObj;

    if (OleGetClipboard (&pClipboardDataObj) == NOERROR) {
        this->pDoc->NewObject (OBJ_LINK, pClipboardDataObj);
        pClipboardDataObj->Release ();
    }
}

void CApplication::PasteObject ()
{
    IDataObject *pClipboardDataObj;
    CDrawnObject *pObj, *pLastObject;
    ClipboardObject *pClip;
    HANDLE hMem;

    if (IsClipboardFormatAvailable (RegisterClipboardFormat ("Ole2Test"))) {

        OpenClipboard (hMainWnd);
        hMem = GetClipboardData (RegisterClipboardFormat ("Ole2Test"));
        pClip = new ClipboardObject (hMem);
        CloseClipboard ();

        pObj = CDrawnObject::Read (pClip, this->pDoc);
        this->pDoc->SetObjectToNextOffset (pObj);

        delete pClip;

        pObj->SetNext (NULL);
        if (pLastObject = this->pDoc->FindLast ()) 
            pLastObject->SetNext (pObj);
        else
            this->pDoc->SetObjectHead (pObj);

        ::InvalidateRect (this->hMainWnd, NULL, FALSE);
        
    } else if (OleGetClipboard (&pClipboardDataObj) == NOERROR) {
        this->pDoc->NewObject (OBJ_EMBED, pClipboardDataObj);
        pClipboardDataObj->Release ();
    }
}

void CApplication::CopyObject (void)
{
    CDrawnObject    *pDrawnObject;
    ClipboardObject *pClip;

    if (pDrawnObject = this->pDoc->FindLast ()) {

        pClip = new ClipboardObject;

        pDrawnObject->Write (pClip);

        OpenClipboard (hMainWnd);
        SetClipboardData (RegisterClipboardFormat ("Ole2Test"), pClip->GetHandle ());
        CloseClipboard ();

        delete pClip;
    }
}

void ErrorMessage (char *message)
{
    MessageBox (NULL, message, "Dude", MB_OK);
}

HRESULT CApplication::QueryInterface (REFIID riid, LPVOID FAR *ppvObj)
{
    SCODE sc = S_OK;                                
    
    *ppvObj = NULL;
                    
    if (IsEqualIID (riid, IID_IUnknown)) {
        *ppvObj = (LPVOID)this->pUnknown;
        this->pUnknown->AddRef ();
    } else if (IsEqualIID (riid, IID_IOleInPlaceSite) ||
               IsEqualIID (riid, IID_IOleWindow)) {
        if (*ppvObj = (LPVOID)this->pInPlaceSite)
            this->pInPlaceSite->AddRef ();
        else
            sc = S_FALSE;
    } else if (IsEqualIID (riid, IID_IOleInPlaceFrame) ||
               IsEqualIID (riid, IID_IOleInPlaceUIWindow)) {
        if (*ppvObj = (LPVOID)this->pInPlaceFrame)
            this->pInPlaceFrame->AddRef ();
        else
            sc = S_FALSE;
    } else {
#ifdef DEBUG
        char buff[60];
        sprintf (buff, "CApp::QI FAILED looking for %lx\n", riid.Data1);
        OutputDebugString (buff);
#endif
        sc = S_FALSE;
    }
        
    return ResultFromScode (sc);
}

HRESULT CApplication::GetWindow (HWND FAR* lphwnd)
{
    *lphwnd = this->hMainWnd;

    return NOERROR;
}

HRESULT CApplication::ContextSensitiveHelp (BOOL fEnterMode)
{
    ErrorMessage ("CApplication::ContextSensitiveHelp: NYI");
    return NOERROR;
}

HRESULT CApplication::CanInPlaceActivate (void)
{
//    ErrorMessage ("CApplication::CanInPlaceActivate: NYI");
    return NOERROR; // say, "Yes"
}

HRESULT CApplication::OnInPlaceActivate (void)
{
    IOleObject *pOleObject;
    CDrawnObject *pObject;
    SCODE sc = S_FALSE;

    if (pObject = this->pDoc->FindLast ()) 
        if (pOleObject = pObject->GetOLEObject ()) {
            if (pOleObject->QueryInterface (IID_IOleInPlaceObject, 
                (LPVOID *)&this->pInPlaceObject) == NOERROR) {
                sc = S_OK;
            }    
            pOleObject->Release ();
        } 
    
    return ResultFromScode (sc);
}

HRESULT CApplication::OnUIActivate (void)
{
    IOleObject *pOleObject;
    CDrawnObject *pObject;

    if (pObject = this->pDoc->FindLast ())
        if (pOleObject = pObject->GetOLEObject ()) {
            this->pActiveObject = (COLEObject *)pObject;
            pOleObject->Release ();
        }
            
    return NOERROR;
}

HRESULT CApplication::GetWindowContext (IOleInPlaceFrame **lplpFrame, IOleInPlaceUIWindow **lplpDoc, RECT *lprcPosRect, RECT *lprcClipRect, LPOLEINPLACEFRAMEINFO lpFrameInfo)
{
    CDrawnObject *pObject;

    this->QueryInterface (IID_IOleInPlaceFrame, (void **)lplpFrame);

    *lplpDoc  = NULL;

    if (pObject = this->pDoc->FindLast ())
        pObject->GetRect (lprcPosRect);
        
    *lprcClipRect = *lprcPosRect;

    lpFrameInfo->hwndFrame =        this->pDoc->GetHWnd ();
    lpFrameInfo->fMDIApp =          FALSE;
    lpFrameInfo->haccel =           LoadAccelerators (gApplication.GetHInst (), "OLETestAccel");
    lpFrameInfo->cAccelEntries =    4;

    return NOERROR;
}

HRESULT CApplication::Scroll (SIZE scrollExtent)
{
    ErrorMessage ("CApplication::Scroll: NYI");
    return NOERROR;
}

HRESULT CApplication::OnUIDeactivate (BOOL fUndoable)
{
    this->pActiveObject = NULL;
    return NOERROR;
}

HRESULT CApplication::OnInPlaceDeactivate (void)
{
    this->pInPlaceObject->Release ();
    this->pInPlaceObject = NULL;
    return NOERROR;
}

HRESULT CApplication::DiscardUndoState (void)
{
    ErrorMessage ("CApplication::DiscardUndoState: NYI");
    return NOERROR;
}

HRESULT CApplication::DeactivateAndUndo (void)
{
    ErrorMessage ("CApplication::DeactivateAndUndo: NYI");
    return NOERROR;
}

HRESULT CApplication::OnPosRectChange (LPCRECT lprcPosRect)
{
    ErrorMessage ("CApplication::OnPosRectChange: NYI");
    return NOERROR;
}

HRESULT CApplication::GetBorder (LPRECT lprectBorder)
{
    ::GetClientRect (this->hMainWnd, lprectBorder);
    return NOERROR;
}

HRESULT CApplication::RequestBorderSpace (LPCBORDERWIDTHS lpborderwidths)
{
//    ErrorMessage ("CApplication::RequestBorderSpace: NYI");

    return NOERROR; // respond, "OK"
}

HRESULT CApplication::SetBorderSpace (LPCBORDERWIDTHS lpborderwidths)
{
    if (lpborderwidths)
        this->rcBorder = *lpborderwidths;
    else
        this->rcBorder.left = this->rcBorder.top =
            this->rcBorder.right = this->rcBorder.bottom = 0;

    this->ResizeFrame ();
    ::InvalidateRect (this->hMainWnd, NULL, TRUE);

    return NOERROR;
}

HRESULT CApplication::SetActiveObject (IOleInPlaceActiveObject *lpActiveObject, LPCSTR lpszObjName)
{
    if (!lpActiveObject) {
        this->rcBorder.left = this->rcBorder.top =
            this->rcBorder.right = this->rcBorder.bottom = 0;
        this->ResizeFrame ();
    }
    
//    this->pInPlaceActiveObject = lpActiveObject;
    return NOERROR;
}

HRESULT CApplication::InsertMenus (HMENU hMenuShared, LPOLEMENUGROUPWIDTHS lpMenuWidths)
{
    AppendMenu (hMenuShared, MF_POPUP, GetSubMenu (::GetMenu (this->hMainWnd), FILE_MENU), "&File");
    AppendMenu (hMenuShared, MF_POPUP, GetSubMenu (::GetMenu (this->hMainWnd), OBJECT_MENU), "&Object");
//  AppendMenu (hMenuShared, MF_POPUP, GetSubMenu (::GetMenu (this->hMainWnd), HELP_MENU), "&Help");
    lpMenuWidths->width[0] = 1L;
    lpMenuWidths->width[2] = 1L;
    lpMenuWidths->width[4] = 1L;
    
    return NOERROR;
}

HRESULT CApplication::SetMenu (HMENU hMenuShared, HOLEMENU hOleMenu, HWND hwndActiveObject)
{
    HMENU   hMenu = ::GetMenu (this->hMainWnd);

    if (hOleMenu)
        hMenu = hMenuShared;

    ::SetMenu (this->hMainWnd, hMenu);
    
    return OleSetMenuDescriptor (hOleMenu, this->hMainWnd,
                                 hwndActiveObject, NULL, NULL);
}

HRESULT CApplication::RemoveMenus (HMENU hMenu)
{
//    ErrorMessage ("CApplication::RemoveMenus: NYI");

    while (GetMenuItemCount (hMenu))
        RemoveMenu (hMenu, 0, MF_BYPOSITION);

    return NOERROR;
}

HRESULT CApplication::SetStatusText (LPCSTR lpszStatusText)
{
//    ErrorMessage ("CApplication::SetStatusText: NYI");
    return NOERROR;
}

HRESULT CApplication::EnableModeless (BOOL fEnable)
{
    ErrorMessage ("CApplication::EnableModeless: NYI");
    return NOERROR;
}

HRESULT CApplication::TranslateAccelerator (LPMSG lpmsg, WORD wID)
{
    ErrorMessage ("CApplication::TranslateAccelerator: NYI");
    return NOERROR;
}

HRESULT STDMETHODCALLTYPE CAppUnknown::QueryInterface (REFIID riid, LPVOID FAR *ppvObj)
{
    return gApplication.QueryInterface (riid, ppvObj);
}

ULONG STDMETHODCALLTYPE CAppUnknown::AddRef (void)
{
    return ++(this->fRefCount);
}

ULONG STDMETHODCALLTYPE CAppUnknown::Release (void)
{
    if (--(this->fRefCount) <= 0) {
        delete this;
        return 0;
    }
    return this->fRefCount;
}
    
HRESULT STDMETHODCALLTYPE CAppInPlaceSite::QueryInterface (REFIID riid, LPVOID FAR *ppvObj)
{
    return gApplication.QueryInterface (riid, ppvObj);
}

ULONG STDMETHODCALLTYPE CAppInPlaceSite::AddRef (void)
{
    return ++(this->fRefCount);
}

ULONG STDMETHODCALLTYPE CAppInPlaceSite::Release (void)
{
    if (--(this->fRefCount) <= 0) {
        delete this;
        return 0;
    }
    return this->fRefCount;
}
    
HRESULT STDMETHODCALLTYPE CAppInPlaceSite::GetWindow (HWND FAR* lphwnd)
{
    return gApplication.GetWindow (lphwnd);
}

HRESULT STDMETHODCALLTYPE CAppInPlaceSite::ContextSensitiveHelp (BOOL fEnterMode)
{
    return gApplication.ContextSensitiveHelp (fEnterMode);
}

HRESULT STDMETHODCALLTYPE CAppInPlaceSite::CanInPlaceActivate (void)
{
    return gApplication.CanInPlaceActivate ();
}

HRESULT STDMETHODCALLTYPE CAppInPlaceSite::OnInPlaceActivate (void)
{
    return gApplication.OnInPlaceActivate ();
}

HRESULT STDMETHODCALLTYPE CAppInPlaceSite::OnUIActivate (void)
{
    return gApplication.OnUIActivate ();
}

HRESULT STDMETHODCALLTYPE CAppInPlaceSite::GetWindowContext (IOleInPlaceFrame **lplpFrame, IOleInPlaceUIWindow **lplpDoc, RECT *lprcPosRect, RECT *lprcClipRect, LPOLEINPLACEFRAMEINFO lpFrameInfo)
{
    return gApplication.GetWindowContext (lplpFrame, lplpDoc, lprcPosRect, lprcClipRect, lpFrameInfo);
}

HRESULT STDMETHODCALLTYPE CAppInPlaceSite::Scroll (SIZE scrollExtent)
{
    return gApplication.Scroll (scrollExtent);
}

HRESULT STDMETHODCALLTYPE CAppInPlaceSite::OnUIDeactivate (BOOL fUndoable)
{
    return gApplication.OnUIDeactivate (fUndoable);
}

HRESULT STDMETHODCALLTYPE CAppInPlaceSite::OnInPlaceDeactivate (void)
{
    return gApplication.OnInPlaceDeactivate ();
}

HRESULT STDMETHODCALLTYPE CAppInPlaceSite::DiscardUndoState (void)
{
    return gApplication.DiscardUndoState ();
}

HRESULT STDMETHODCALLTYPE CAppInPlaceSite::DeactivateAndUndo (void)
{
    return gApplication.DeactivateAndUndo ();
}

HRESULT STDMETHODCALLTYPE CAppInPlaceSite::OnPosRectChange (LPCRECT lprcPosRect)
{
    return gApplication.OnPosRectChange (lprcPosRect);
}

HRESULT STDMETHODCALLTYPE CAppInPlaceFrame::QueryInterface (REFIID riid, LPVOID FAR *ppvObj)
{
    return gApplication.QueryInterface (riid, ppvObj);
}

ULONG STDMETHODCALLTYPE CAppInPlaceFrame::AddRef (void)
{
    return ++(this->fRefCount);
}

ULONG STDMETHODCALLTYPE CAppInPlaceFrame::Release (void)
{
    if (--(this->fRefCount) <= 0) {
        delete this;
        return 0;
    }
    return this->fRefCount;
}
    
HRESULT STDMETHODCALLTYPE CAppInPlaceFrame::GetWindow (HWND FAR* lphwnd)
{
    return gApplication.GetWindow (lphwnd);
}

HRESULT STDMETHODCALLTYPE CAppInPlaceFrame::ContextSensitiveHelp (BOOL fEnterMode)
{
    return gApplication.ContextSensitiveHelp (fEnterMode);
}

HRESULT STDMETHODCALLTYPE CAppInPlaceFrame::GetBorder (LPRECT lprectBorder)
{
    return gApplication.GetBorder (lprectBorder);
}

HRESULT STDMETHODCALLTYPE CAppInPlaceFrame::RequestBorderSpace (LPCBORDERWIDTHS lpborderwidths)
{
    return gApplication.RequestBorderSpace (lpborderwidths);
}

HRESULT STDMETHODCALLTYPE CAppInPlaceFrame::SetBorderSpace (LPCBORDERWIDTHS lpborderwidths)
{
    return gApplication.SetBorderSpace (lpborderwidths);
}

HRESULT STDMETHODCALLTYPE CAppInPlaceFrame::SetActiveObject (IOleInPlaceActiveObject *lpActiveObject, LPCSTR lpszObjName)
{
    return gApplication.SetActiveObject (lpActiveObject, lpszObjName);
}

HRESULT STDMETHODCALLTYPE CAppInPlaceFrame::InsertMenus (HMENU hmenuShared, LPOLEMENUGROUPWIDTHS lpMenuWidts)
{
    return gApplication.InsertMenus (hmenuShared, lpMenuWidts);
}

HRESULT STDMETHODCALLTYPE CAppInPlaceFrame::SetMenu (HMENU hmenuShared, HOLEMENU holemenu, HWND hwndActiveObject)
{
    return gApplication.SetMenu (hmenuShared, holemenu, hwndActiveObject);
}

HRESULT STDMETHODCALLTYPE CAppInPlaceFrame::RemoveMenus (HMENU hmenuShared)
{
    return gApplication.RemoveMenus (hmenuShared);
}

HRESULT STDMETHODCALLTYPE CAppInPlaceFrame::SetStatusText (LPCSTR lpszStatusText)
{
    return gApplication.SetStatusText (lpszStatusText);
}

HRESULT STDMETHODCALLTYPE CAppInPlaceFrame::EnableModeless (BOOL fEnable)
{
    return gApplication.EnableModeless (fEnable);
}

HRESULT STDMETHODCALLTYPE CAppInPlaceFrame::TranslateAccelerator (LPMSG lpmsg, WORD wID)
{
    return gApplication.TranslateAccelerator (lpmsg, wID);
}

