#ifndef __app__
#define __app__
                  
#include "doc.hpp"

class COLEObject;
class CInPlaceSite;
class CAppUnknown;
class CAppInPlaceSite;
class CAppInPlaceFrame;
                  
class CApplication {
  public:
    CApplication (void);      
    ~CApplication (void);
    
    BOOL    Init (HANDLE hInstance, int nCmdShow);
    LONG    MessageHandler (HWND hWnd, unsigned message, WORD wParam, LONG lParam);
    void    NewDocument (void);
    BOOL    OpenDocument (HWND hWnd);
    BOOL    SaveAsDocument (HWND hWnd);
    BOOL    InsertObjectDialog (HWND hWnd);
    BOOL    CloseDocument (void);
    void    Terminate (void);
    
    void    NewObject (short type);
    void    Update (HDC hDC);
                         
    void    InitObjectMenu (HMENU hObjectMenu);
    void    InitMenuPopup (HMENU hMenu, short whichMenu);
    void    DoVerb (short index);
    void    ResizeFrame (void);
    
    void    CopyObject (void);
    void    PasteLink (void);
    void    PasteObject (void);
    
    HWND    GetHMainWnd (void) { return this->hMainWnd; }
    void    SetHMainWnd (HWND hWnd) { this->hMainWnd = hWnd; }
    
    HANDLE  GetHInst (void) { return this->hInst; }
    void    SetHInst (HANDLE hInstance) { this->hInst = hInstance; }
    
    struct xxxClipPriority {
        FORMATETC etc;
        BOOL bIsLink;
    } fClipboardPriority[8];
    
    short   numClipFormats;

    HRESULT     QueryInterface (REFIID riid, LPVOID FAR *ppvObj);
    ULONG       AddRef (void);
    ULONG       Release (void);
    
    HRESULT     SaveObject (void);
    HRESULT     GetMoniker (DWORD dwAssign, DWORD dwWhichMoniker, IMoniker **ppmk);
    HRESULT     GetContainer (IOleContainer **ppContainer);
    HRESULT     ShowObject (void);
    HRESULT     OnShowWindow (BOOL fShow);
    HRESULT     RequestNewObjectLayout (void);
    
    void        OnDataChange (FORMATETC *pFormatEtc, STGMEDIUM *pStgMed);
    void        OnViewChange (DWORD dwAspect, LONG lindex);
    void        OnRename (IMoniker *pmk);
    void        OnSave (void);
    void        OnClose (void);
    
    HRESULT     GetWindow (HWND FAR* lphwnd);
    HRESULT     ContextSensitiveHelp (BOOL fEnterMode);

    HRESULT     CanInPlaceActivate (void);
    HRESULT     OnInPlaceActivate (void);
    HRESULT     OnUIActivate (void);    
    HRESULT     GetWindowContext (IOleInPlaceFrame **lplpFrame, IOleInPlaceUIWindow **lplpDoc, RECT *lprcPosRect, RECT *lprcClipRect, LPOLEINPLACEFRAMEINFO lpFrameInfo);
    HRESULT     Scroll (SIZE scrollExtent);       
    HRESULT     OnUIDeactivate (BOOL fUndoable);      
    HRESULT     OnInPlaceDeactivate (void);
    HRESULT     DiscardUndoState (void);
    HRESULT     DeactivateAndUndo (void);
    HRESULT     OnPosRectChange (LPCRECT lprcPosRect); 

    HRESULT     GetBorder (LPRECT lprectBorder);
    HRESULT     RequestBorderSpace (LPCBORDERWIDTHS lpborderwidths);
    HRESULT     SetBorderSpace (LPCBORDERWIDTHS lpborderwidths);
    HRESULT     SetActiveObject (IOleInPlaceActiveObject *lpActiveObject, LPCSTR lpszObjName); 
    
    HRESULT     InsertMenus (HMENU hmenuShared, LPOLEMENUGROUPWIDTHS lpMenuWidts);
    HRESULT     SetMenu (HMENU hmenuShared, HOLEMENU holemenu, HWND hwndActiveObject);
    HRESULT     RemoveMenus (HMENU hmenuShared);
    HRESULT     SetStatusText (LPCSTR lpszStatusText);    
    HRESULT     EnableModeless (BOOL fEnable);
    HRESULT     TranslateAccelerator (LPMSG lpmsg, WORD wID);

  private:
    short   CanEnablePaste (BOOL bLink);
    
    HWND    hMainWnd;
    HANDLE  hInst;
    RECT    rcBorder;   // the inplace border (for the server's tools)
    
    // clipboard formats   
    UINT    m_cfEmbedSource;
    UINT    m_cfEmbeddedObject;
    UINT    m_cfLinkSource;
    UINT    m_cfFileName;
    UINT    m_cfObjectDescriptor; 
    UINT    m_cfLinkSrcDescriptor; 
    
    CAppUnknown *pUnknown;
    CAppInPlaceSite *pInPlaceSite;
    CAppInPlaceFrame *pInPlaceFrame;
    CDocument *pDoc;
    COLEObject *pActiveObject;
    IOleInPlaceObject *pInPlaceObject;
};

// voodoo follows
//
#ifdef LOCAL_APP
#include "initguid.h"           // forces our GUIDs to be initialized
#endif

DEFINE_OLEGUID(OLE2TEST_CLSID, 0x00000500, 0, 0);   // I made this up


class CAppUnknown : public IUnknown {
  public:
        CAppUnknown (void)
            { this->fRefCount = 1; }
        
    virtual HRESULT STDMETHODCALLTYPE QueryInterface (REFIID riid, LPVOID FAR *ppvObj);
    virtual ULONG   STDMETHODCALLTYPE AddRef (void);
    virtual ULONG   STDMETHODCALLTYPE Release (void);
    
  private:
     short      fRefCount;
};

class CAppInPlaceSite : public IOleInPlaceSite {
  public:
        CAppInPlaceSite (void)
            { this->fRefCount = 1; }
        
    virtual HRESULT STDMETHODCALLTYPE QueryInterface (REFIID riid, LPVOID FAR *ppvObj);
    virtual ULONG   STDMETHODCALLTYPE AddRef (void);
    virtual ULONG   STDMETHODCALLTYPE Release (void);
    
    virtual HRESULT STDMETHODCALLTYPE GetWindow (HWND FAR* lphwnd);
    virtual HRESULT STDMETHODCALLTYPE ContextSensitiveHelp (BOOL fEnterMode);

    virtual HRESULT STDMETHODCALLTYPE CanInPlaceActivate (void);
    virtual HRESULT STDMETHODCALLTYPE OnInPlaceActivate (void);
    virtual HRESULT STDMETHODCALLTYPE OnUIActivate (void);    
    virtual HRESULT STDMETHODCALLTYPE GetWindowContext (IOleInPlaceFrame **lplpFrame, IOleInPlaceUIWindow **lplpDoc, RECT *lprcPosRect, RECT *lprcClipRect, LPOLEINPLACEFRAMEINFO lpFrameInfo);
    virtual HRESULT STDMETHODCALLTYPE Scroll (SIZE scrollExtent);       
    virtual HRESULT STDMETHODCALLTYPE OnUIDeactivate (BOOL fUndoable);      
    virtual HRESULT STDMETHODCALLTYPE OnInPlaceDeactivate (void);
    virtual HRESULT STDMETHODCALLTYPE DiscardUndoState (void);
    virtual HRESULT STDMETHODCALLTYPE DeactivateAndUndo (void);
    virtual HRESULT STDMETHODCALLTYPE OnPosRectChange (LPCRECT lprcPosRect); 

  private:
     short      fRefCount;
};

class CAppInPlaceFrame : public IOleInPlaceFrame {
  public:
        CAppInPlaceFrame (void)
            { this->fRefCount = 1; }
        
    virtual HRESULT STDMETHODCALLTYPE QueryInterface (REFIID riid, LPVOID FAR *ppvObj);
    virtual ULONG   STDMETHODCALLTYPE AddRef (void);
    virtual ULONG   STDMETHODCALLTYPE Release (void);
    
    virtual HRESULT STDMETHODCALLTYPE GetWindow (HWND FAR* lphwnd);
    virtual HRESULT STDMETHODCALLTYPE ContextSensitiveHelp (BOOL fEnterMode);

    virtual HRESULT STDMETHODCALLTYPE GetBorder (LPRECT lprectBorder);
    virtual HRESULT STDMETHODCALLTYPE RequestBorderSpace (LPCBORDERWIDTHS lpborderwidths);
    virtual HRESULT STDMETHODCALLTYPE SetBorderSpace (LPCBORDERWIDTHS lpborderwidths);
    virtual HRESULT STDMETHODCALLTYPE SetActiveObject (IOleInPlaceActiveObject *lpActiveObject, LPCSTR lpszObjName); 
    
    virtual HRESULT STDMETHODCALLTYPE InsertMenus (HMENU hmenuShared, LPOLEMENUGROUPWIDTHS lpMenuWidts);
    virtual HRESULT STDMETHODCALLTYPE SetMenu (HMENU hmenuShared, HOLEMENU holemenu, HWND hwndActiveObject);
    virtual HRESULT STDMETHODCALLTYPE RemoveMenus (HMENU hmenuShared);
    virtual HRESULT STDMETHODCALLTYPE SetStatusText (LPCSTR lpszStatusText);    
    virtual HRESULT STDMETHODCALLTYPE EnableModeless (BOOL fEnable);
    virtual HRESULT STDMETHODCALLTYPE TranslateAccelerator (LPMSG lpmsg, WORD wID);

  private:
     short      fRefCount;
};

void ErrorMessage (char *message);
                               
extern CApplication gApplication;

#ifdef LOCAL_APP

CApplication gApplication;

#endif

#endif
