//
//  Ole2Test application
//
//  doc.cpp - CDocument methods
//
//  Copyright 1993 Macromedia, Inc.
//
//  Initial Version:
//      J. Paul Kase, 5/23/93
//

#define LOCAL_DOC

#include "ole2test.h" 
#include <stdio.h>

#include <ole2.h>

#include "doc.hpp"
#include "app.hpp"
#include "io.hpp"

CDocument::CDocument (HWND itsWnd)
{ 
    this->pUnknown =        NULL;
    this->pDropTarget =     NULL;
    this->fRegistration =   NULL;
    this->fRefCount =       0L;
    this->bDirty =          TRUE;   // this flag is cleared after loading, 
                                    // but init's to TRUE for untitled docs
    this->fNextOffset =     0;
    this->fObjectList =     NULL;
    this->fNextDrawnObjectIndex = 0;
    this->fNextLinkObjectIndex = 0;
    this->fNextEmbeddedObjectIndex = 0;
    
    this->hWnd =            itsWnd;

    strcpy (this->title, "Untitled");

    this->Init ();
}                                                           

CDocument::~CDocument ()
{
    HRESULT hResult;
    IRunningObjectTable *pROT;
    
    if (this->fRegistration) {
        hResult = GetRunningObjectTable (NULL, &pROT);
    
        if (hResult == NOERROR) {
            pROT->Revoke (this->fRegistration);
            pROT->Release ();
        }
    }
    
    // delete the objects in the list
    //
    CDrawnObject *pObject, *pNextObject;
    
    for (pObject = this->fObjectList; pObject; pObject = pNextObject) {
        pNextObject = pObject->Next ();
        delete pObject;
    }
        
    if (this->pUnknown)
        this->pUnknown->Release ();
        
    if (this->pDropTarget)
        this->pDropTarget->Release ();
}
                 
HRESULT CDocument::Init (void)
{
    this->pDropTarget = new CDropTarget (this);
    this->pUnknown = new CDocUnknown (this);

    return NOERROR;
}

ULONG CDocument::AddRef (void)
{
    return ++(this->fRefCount);
}

ULONG CDocument::Release (void)
{
    if (!--(this->fRefCount)) {
        delete this;
        return 0L;
    }
        
    return this->fRefCount;
}

CDrawnObject *CDocument::NewObject (short type, IDataObject *pDataObj)
{
    CDrawnObject *pNewObject = NULL;
    CDrawnObject *pLastObj;
    char        buff[32];

    switch (type) {
      case OBJ_TEXT:
        sprintf (buff, "Drawn%i", ++(this->fNextDrawnObjectIndex));
        pNewObject = new CTextObject (this, this->fNextOffset, buff);
        break;                                         
      case OBJ_RECT:
        sprintf (buff, "Drawn%i", ++(this->fNextDrawnObjectIndex));
        pNewObject = new CRectObject (this, this->fNextOffset, buff);
        break;
      case OBJ_ELLIPSE:
        sprintf (buff, "Drawn%i", ++(this->fNextDrawnObjectIndex));
        pNewObject = new CEllipseObject (this, this->fNextOffset, buff);
        break;
      case OBJ_LINK:
        sprintf (buff, "Link%i", ++(this->fNextLinkObjectIndex));
        pNewObject = new CLinkObject (this, this->fNextOffset, buff);
        ::InvalidateRect (gApplication.GetHMainWnd (), NULL, FALSE);     // sledgehammer coding
        break;
      case OBJ_EMBED:
        sprintf (buff, "Embed%i", ++(this->fNextEmbeddedObjectIndex));
        pNewObject = new CEmbeddedObject (this, this->fNextOffset, buff);
        ::InvalidateRect (gApplication.GetHMainWnd (), NULL, FALSE);     // sledgehammer coding
    }                                       
    if (!pNewObject)
        return NULL;
        
    if (!pNewObject->Init (pDataObj)) {
        delete pNewObject;
        return NULL;
    }
        
    this->fNextOffset += 40;
    
    pNewObject->SetNext (NULL);
                                     
    if (!(pLastObj = this->FindLast ()))
        this->fObjectList = pNewObject;
    else
        pLastObj->SetNext (pNewObject);
    
    this->bDirty = TRUE;

    return pNewObject;
}                 

void CDocument::SetObjectToNextOffset (CDrawnObject *pObj)
{
    pObj->posX = pObj->posY = this->fNextOffset;

    this->fNextOffset += 40;
}

CDrawnObject *CDocument::FindLast (void)
{
    CDrawnObject *pObj = this->fObjectList;
    CDrawnObject *pLastObj = NULL;
        
    while (pObj) {
        pLastObj = pObj;
        pObj = pObj->Next ();
    }
    return pLastObj;
}

void CDocument::Update (HDC hDC)
{
    CDrawnObject *pObj = this->fObjectList;
    
    while (pObj) {
        pObj->Draw (hDC);
        pObj = pObj->Next ();
    }
}

void CDocument::Save (char *fileName)
{
    CDrawnObject *pObj;
    short count, i;
    OFSTRUCT of;
    HFILE hfFile;
    FileObject *pFile;
    
    for (pObj = this->fObjectList, count = 0; pObj; count++) 
        pObj = pObj->Next ();

    if ((hfFile = OpenFile (fileName, &of, OF_READWRITE | OF_CREATE)) == HFILE_ERROR) {
        MessageBox (NULL, "Error Creating Output File", "Ole2Test", MB_OK);
        return;
    }

    pFile = new FileObject (hfFile);

    pFile->WriteBytes ((char *)&count, sizeof(count));

    for (i = 0, pObj = this->fObjectList; i < count; i++, pObj=pObj->Next ()) 
        pObj->Write (pFile);

    delete pFile;

    _lclose (hfFile);

    strcpy (this->title, fileName);
}

// Clear cheats -- instead of deleting the doc and creating a new one,
// it kills all the objects, init's some instance variables and redraws
// the empty doc.
//
void CDocument::Clear (void)
{
    CDrawnObject *pObj = this->fObjectList, *pNext;
    
    while (pObj) {
        pNext = pObj->Next ();
        delete pObj;
        pObj = pNext;
    }
    this->fObjectList = NULL;

    this->fNextOffset =     0;
    this->fObjectList =     NULL;
    this->fNextDrawnObjectIndex = 0;
    this->fNextLinkObjectIndex = 0;
    this->fNextEmbeddedObjectIndex = 0;

    ::InvalidateRect (gApplication.GetHMainWnd (), NULL, TRUE);     // sledgehammer coding
}

void CDocument::Load (char *fileName)
{
    CDrawnObject *pObj, *pLastObj;
    short count, i;
    OFSTRUCT of;
    HFILE hfFile;
    FileObject *pFile;
    
    if ((hfFile = OpenFile (fileName, &of, OF_READ)) == HFILE_ERROR) {
        MessageBox (NULL, "Error Opening Input File", "Ole2Test", MB_OK);
        return;
    }

    pFile = new FileObject (hfFile);

    pFile->ReadBytes ((char *)&count, sizeof(count));

    for (i = 0; i < count; i++) {
        pObj = CDrawnObject::Read (pFile, this);

        if (!i)
            this->fObjectList = pObj;
        else
            pLastObj->SetNext (pObj);

        pObj->SetNext (NULL);

        pLastObj = pObj;
    }

    delete pFile;

    _lclose (hfFile);

    ::InvalidateRect (gApplication.GetHMainWnd (), NULL, TRUE);     // sledgehammer coding
}

short CDocument::CanAccept (IDataObject *pDataObj, BOOL bLink)
{
    FORMATETC       FmtEtc;
    IEnumFORMATETC  *pEnumFmtEtc = NULL;
    short           bFound = -1;
    short           i;

    if (pDataObj->EnumFormatEtc (DATADIR_GET, &pEnumFmtEtc) == NOERROR) {
        while (bFound == -1) {
            if (pEnumFmtEtc->Next (1, &FmtEtc, NULL) != NOERROR)
                break;
                
            for (i=0; i < gApplication.numClipFormats; i++)
                if (FmtEtc.cfFormat == 
                    gApplication.fClipboardPriority[i].etc.cfFormat && 
                    FmtEtc.tymed == 
                    gApplication.fClipboardPriority[i].etc.tymed && 
                    (!bLink || gApplication.fClipboardPriority[i].bIsLink)) {
                    bFound = i;
                    break;
                }    
        }
        pEnumFmtEtc->Release ();
    }
    return bFound;
}

HRESULT CDocument::QueryInterface (REFIID riid, LPVOID FAR *ppvObj)
{
    SCODE sc = S_OK;                                
    
    *ppvObj = NULL;
                    
    if (IsEqualIID (riid, IID_IDropTarget)) {
        *ppvObj = (LPVOID)this->pDropTarget;
        this->pDropTarget->AddRef ();
    } else if (IsEqualIID (riid, IID_IUnknown)) {
        *ppvObj = (LPVOID)this->pUnknown;
        this->pUnknown->AddRef ();
    } else
        return gApplication.QueryInterface (riid, ppvObj);
        
    return ResultFromScode (sc);
}

HRESULT CDocument::ParseDisplayName (IBindCtx *pbc, LPSTR lpszDisplayName, ULONG *pchEaten, IMoniker **ppmk)
{
    ErrorMessage ("CDocument::ParseDisplayName: NYI");
    return NOERROR;
}

HRESULT CDocument::EnumObjects (DWORD grfFlags, IEnumUnknown **ppEnumUnk)
{
    ErrorMessage ("CDocument::ParseDisplayName: NYI");
    return NOERROR;
}

HRESULT CDocument::LockContainer (BOOL bLock)
{
//    ErrorMessage ("CDocument::LockContainer: NYI");
    return NOERROR;
}

HRESULT CDocument::GetObject (char *name, DWORD dwSpeedNeeded, IBindCtx *pbc, REFIID riid, LPVOID *ppvObject)
{
    ErrorMessage ("CDocument::GetObject1: NYI");
    return NOERROR;
}

HRESULT CDocument::GetObjectStorage (char *name, IBindCtx *pbc, REFIID riid, LPVOID *ppvStorage)
{
    ErrorMessage ("CDocument::GetObjectStorage: NYI");
    return NOERROR;
}

HRESULT CDocument::IsRunning (char *name)
{
    ErrorMessage ("CDocument::IsRunning: NYI");
    return NOERROR;
}

HRESULT CDocument::GetObject (char *name, REFIID riid, LPVOID *pObject)
{
    ErrorMessage ("CDocument::GetObject2: NYI");
    return NOERROR;
}
    
HRESULT STDMETHODCALLTYPE CDocUnknown::QueryInterface (REFIID riid, LPVOID FAR *ppvObj)
{
    return this->pDoc->QueryInterface (riid, ppvObj);
}

ULONG STDMETHODCALLTYPE CDocUnknown::AddRef (void)
{
    return ++(this->fRefCount);
}

ULONG STDMETHODCALLTYPE CDocUnknown::Release (void)
{
    if (--(this->fRefCount) <= 0) {
        delete this;
        return 0;
    }
    return this->fRefCount;
}


