#ifndef __doc__
#define __doc__
                
#include <ole2.h>
#include "drawobj.hpp"
#include "drop.hpp"

class CDocUnknown;
                 
class CDocument {
  public:
                CDocument (HWND hWnd);
                ~CDocument (void);
                
    HRESULT     Init (void);   
    
    CDrawnObject *NewObject (short type, IDataObject *pDataObj);
    CDrawnObject *FindLast (void);

    void        SetObjectToNextOffset (CDrawnObject *pObj);
    
    void        Update (HDC hDC);

    void        Save (char *fileName);
    void        Clear (void);
    void        Load (char *fileName);

    BOOL        IsDirty (void) { return this->bDirty; }
    void        SetDirty (BOOL bIs) { this->bDirty = bIs; }
    
    char        *GetTitle (void) { return this->title; }
    
    short       CanAccept (IDataObject *pDataObj, BOOL bLink);
    IStorage    *CreateChildStorage (char *name);
    
    // Doc methods that support the interfaces
    //
    HRESULT     QueryInterface (REFIID riid, LPVOID FAR *ppvObj);
    ULONG       AddRef (void);
    ULONG       Release (void);
    
    HRESULT     ParseDisplayName (IBindCtx *pbc, LPSTR lpszDisplayName, ULONG *pchEaten, IMoniker **ppmk);
    
    HRESULT     EnumObjects (DWORD grfFlags, IEnumUnknown **ppEnumUnk);
    HRESULT     LockContainer (BOOL bLock);
                                                                 
    HRESULT     GetObject (char *name, DWORD dwSpeedNeeded, IBindCtx *pbc, REFIID riid, LPVOID *ppvObject);
    HRESULT     GetObjectStorage (char *name, IBindCtx *pbc, REFIID riid, LPVOID *ppvStorage);
    HRESULT     IsRunning (char *name);

    HRESULT     GetObject (char *name, REFIID riid, LPVOID *pObject);

    CDropTarget *GetDropTarget (void) { return this->pDropTarget; }
    
    HWND        GetHWnd (void) { return this->hWnd; }

    void        SetObjectHead (CDrawnObject *pObj) { this->fObjectList = pObj; }

  private:
    char        title[128];
    DWORD       fRegistration;  // ROT entry   
    CDocUnknown *pUnknown;
    CDropTarget *pDropTarget;
    
    ULONG       fRefCount;
    BOOL        bDirty;
    
    short       fNextOffset;
    short       fNextDrawnObjectIndex;
    short       fNextLinkObjectIndex;
    short       fNextEmbeddedObjectIndex;
    
    HWND        hWnd;

    CDrawnObject *fObjectList;
};
 
class CDocUnknown : public IUnknown {
  public:
        CDocUnknown (CDocument *itsDoc) : IUnknown () 
            { this->pDoc = itsDoc; this->fRefCount = 1; }
        
    virtual HRESULT STDMETHODCALLTYPE QueryInterface (REFIID riid, LPVOID FAR *ppvObj);
    virtual ULONG   STDMETHODCALLTYPE AddRef (void);
    virtual ULONG   STDMETHODCALLTYPE Release (void);
    
  private:
     CDocument *pDoc;
     short      fRefCount;
};

#endif
