//
//  Ole2Test application
//
//  drawobj.cpp - CDrawnObject methods
//
//  Copyright 1993 Macromedia, Inc.
//
//  Initial Version:
//      J. Paul Kase, 5/23/93
//

#define LOCAL_DRAWOBJ

#include "ole2test.h"
#include <stdio.h>
#include <ole2.h>
#include <moniker.h>

#include "DrawObj.hpp"
#include "doc.hpp"
#include "app.hpp"
#include "io.hpp"

CDrawnObject::CDrawnObject (CDocument *pParentDoc, short offset, char *name)
{
    this->posX = this->posY = offset;
    this->extX = 200;
    this->extY = 100;
    this->pNext = NULL;
    strcpy (this->fName, name);
    this->pDoc = pParentDoc;
}

void CDrawnObject::Write (InputOutput *pIOObject)
{
    short type;

    type = this->GetType ();

    pIOObject->WriteBytes ((char *)&type, sizeof(type));
    pIOObject->WriteBytes ((char *)this->fName, sizeof(this->fName));
    pIOObject->WriteBytes ((char *)&this->posX, sizeof(this->posX));
    pIOObject->WriteBytes ((char *)&this->posY, sizeof(this->posY));
    pIOObject->WriteBytes ((char *)&this->extX, sizeof(this->extX));
    pIOObject->WriteBytes ((char *)&this->extY, sizeof(this->extY));
}

CDrawnObject *CDrawnObject::Read (InputOutput *pIOObject, CDocument *pDoc)
{
    CDrawnObject *pObj;
    short type;
    char name[32];

    pIOObject->ReadBytes ((char *)&type, sizeof(type));
    pIOObject->ReadBytes ((char *)name, sizeof(name));

    switch (type) {
      case DT_TEXT:
        pObj = new CTextObject (pDoc, 0, name);
        break;
      case DT_RECT:
        pObj = new CRectObject (pDoc, 0, name);
        break;
      case DT_ELLIPSE:
        pObj = new CEllipseObject (pDoc, 0, name);
        break;
      case DT_LINK:
        pObj = new CLinkObject (pDoc, 0, name);
        break;
      case DT_EMBEDDED:
        pObj = new CEmbeddedObject (pDoc, 0, name);
        break;
    }

    pObj->ReadData (pIOObject);

    return pObj;
}

void CDrawnObject::ReadData (InputOutput *pIOObject)
{
    pIOObject->ReadBytes ((char *)&this->posX, sizeof(this->posX));
    pIOObject->ReadBytes ((char *)&this->posY, sizeof(this->posY));
    pIOObject->ReadBytes ((char *)&this->extX, sizeof(this->extX));
    pIOObject->ReadBytes ((char *)&this->extY, sizeof(this->extY));
}

void CTextObject::Draw (HDC hDC)
{
    DWORD dwTemp;
    
    TextOut (hDC, this->posX, this->posY, fName, strlen (fName));
    dwTemp = GetTextExtent (hDC, fName, strlen (fName));
    this->extX = LOWORD(dwTemp);
    this->extY = HIWORD(dwTemp);
}

void CRectObject::Draw (HDC hDC)
{
    Rectangle (hDC, this->posX, this->posY, this->posX + this->extX, this->posY + this->extY);
}

void CEllipseObject::Draw (HDC hDC)
{
    Ellipse (hDC, this->posX, this->posY, this->posX + this->extX, this->posY + this->extY);
}

void ConvertHimetricToPixels (HDC hDC, SIZEL *pSource, SIZEL *pDest)
{
    LONG lPixPerInchX, lPixPerInchY;
    
    lPixPerInchX = GetDeviceCaps (hDC, LOGPIXELSX);
    lPixPerInchY = GetDeviceCaps (hDC, LOGPIXELSY);
    pDest->cx = (pSource->cx * lPixPerInchX) / 2540L;
    pDest->cy = (pSource->cy * lPixPerInchY) / 2540L;
}

COLEObject::COLEObject (CDocument *pDoc, short offset, char *name) : 
                        CDrawnObject (pDoc, offset, name) 
{
    this->bMonikerAssigned = FALSE;
    this->pUnknown =        NULL;
    this->pStorage =        NULL;
    this->pLockBytes =      NULL;
    this->pOleObject =      NULL;
    this->pOleClientSite =  NULL; 
    this->pAdviseSink =     NULL;
}

COLEObject::~COLEObject ()
{
    if (this->pUnknown)
        this->pUnknown->Release ();
    if (this->pStorage)
        this->pStorage->Release ();
    if (this->pLockBytes)
        this->pLockBytes->Release ();
    if (this->pOleObject)
        this->pOleObject->Release ();
    if (this->pOleClientSite)
        this->pOleClientSite->Release ();
    if (this->pAdviseSink)
        this->pAdviseSink->Release ();
}

void COLEObject::Draw (HDC hDC)
{
    RECTL       rclTemp;
    IViewObject *pViewObj;
    
    rclTemp.right = (rclTemp.left = this->posX) + this->extX;
    rclTemp.bottom = (rclTemp.top = this->posY) + this->extY;
//    OleDraw (this->pOleObject, DVASPECT_CONTENT, hDC, &rcTemp);
    if (this->pOleObject->QueryInterface (IID_IViewObject, (void **)&pViewObj) == NOERROR) {
        pViewObj->Draw (DVASPECT_CONTENT, -1L, NULL, NULL, NULL, hDC,
                        &rclTemp, &rclTemp, NULL, 0);
        pViewObj->Release ();
    }
}

void COLEObject::ReadData (InputOutput *pIOObject)
{
    DWORD size;
    HANDLE hMem;

    CDrawnObject::ReadData (pIOObject);

    pIOObject->ReadBytes ((char *)&size, sizeof(size));
    if (!(hMem = GlobalAlloc (GMEM_MOVEABLE | GMEM_NODISCARD, size)))
        return;

    pIOObject->ReadBytes (GlobalLock (hMem), size);
    GlobalUnlock (hMem);

    if (CreateILockBytesOnHGlobal (hMem, FALSE, &this->pLockBytes) != NOERROR)
        return;

    if (StgOpenStorageOnILockBytes (this->pLockBytes, NULL, 
                                    STGM_READ | STGM_TRANSACTED | 
                                    STGM_SHARE_EXCLUSIVE, NULL, NULL, 
                                    &this->pStorage) != NOERROR) {
        this->pLockBytes->Release ();
        this->pLockBytes = NULL;
        return;
    }

// get the object ready
    IViewObject     *pViewObject;
    DWORD           dwTemp;
    HRESULT         hResult;
    SCODE           sc;
    char            buff[32];

    this->pOleClientSite = new CDrawnObjectOleClientSite (this);
    this->pAdviseSink = new CDrawnObjectAdviseSink (this);
    this->pUnknown = new CDrawnObjectUnknown (this);
    
    if ((hResult = OleLoad (this->pStorage, IID_IOleObject,
                            this->pOleClientSite,
                            (LPVOID FAR *)&this->pOleObject)) != NOERROR) {
        sc = GetScode (hResult);
        sprintf (buff, "OleLoad failed: %lx", sc);
        ErrorMessage (buff);
        goto error;
    }    
    
    // now setup the advisee and the advisor
    if (this->pOleObject->QueryInterface (IID_IViewObject, (LPVOID FAR *)&pViewObject) == NOERROR) {
        pViewObject->SetAdvise (DVASPECT_CONTENT, 0, this->pAdviseSink);
        pViewObject->Release ();
    }
    this->pOleObject->Advise (pAdviseSink, (DWORD FAR *)&dwTemp);
    this->pOleObject->SetHostNames ("container", "object");
    OleSetContainedObject ((IUnknown *)(this->pOleObject), TRUE);
//

    SIZEL   slTemp;
    HDC     hDC;

    this->pOleObject->GetExtent (DVASPECT_CONTENT, &slTemp);
    ConvertHimetricToPixels (hDC=GetDC (gApplication.GetHMainWnd ()), &slTemp, &slTemp);
    ReleaseDC (gApplication.GetHMainWnd (), hDC);
    this->extX = (short)slTemp.cx;
    this->extY = (short)slTemp.cy;

error:
    ;
}

void COLEObject::Write (InputOutput *pIOObject)
{
    ILockBytes *pLockBytes;
    IStorage *pStorageOut;
    IPersistStorage *pSource;
    DWORD size, grfFlag;
    HANDLE hMem;

    CDrawnObject::Write (pIOObject);

    if (CreateILockBytesOnHGlobal (NULL, TRUE, &pLockBytes) != NOERROR)
        return;

    grfFlag = STGM_READWRITE | STGM_CREATE | STGM_TRANSACTED | STGM_SHARE_EXCLUSIVE;
    if (StgCreateDocfileOnILockBytes (pLockBytes, grfFlag, NULL, &pStorageOut) != NOERROR) {
        pLockBytes->Release ();
        return;
    }

    if (this->pOleObject) {
        if (this->pOleObject->QueryInterface (IID_IPersistStorage, (void **)&pSource) == NOERROR) {
            OleSave (pSource, pStorageOut, FALSE);
            pSource->Release ();
        }
    }

    GetHGlobalFromILockBytes (pLockBytes, &hMem);

    GlobalFlags (hMem);

    size = GlobalSize (hMem);

    pIOObject->WriteBytes ((char *)&size, sizeof(size));
    pIOObject->WriteBytes (GlobalLock (hMem), size);

    GlobalUnlock (hMem);

    pStorageOut->Release ();
    pLockBytes->Release ();
}

BOOL CLinkObject::Init (IDataObject *pDataObj)
{
    IViewObject     *pViewObject;
    DWORD           dwTemp;
    HRESULT         hResult;
    SCODE           sc;
    char            buff[32];

    if (CreateILockBytesOnHGlobal (NULL, TRUE, &this->pLockBytes) != NOERROR)
        return FALSE;

    if (StgCreateDocfileOnILockBytes (this->pLockBytes, 
                                      STGM_READWRITE | STGM_CREATE | 
                                      STGM_TRANSACTED | STGM_SHARE_EXCLUSIVE, 
                                      NULL, &this->pStorage) != NOERROR) {
//        this->pLockBytes->Release (); // the assumption is that the pLockBytes is still valid
        return FALSE;
    }

    this->pOleClientSite = new CDrawnObjectOleClientSite (this);
    this->pAdviseSink = new CDrawnObjectAdviseSink (this);
    this->pUnknown = new CDrawnObjectUnknown (this);
    
    if ((hResult = OleCreateLinkFromData (pDataObj, IID_IOleObject,
                               OLERENDER_DRAW,
                               NULL,
                               this->pOleClientSite,
                               this->pStorage,
                               (LPVOID FAR *)&this->pOleObject)) != NOERROR) {
        sc = GetScode (hResult);
        sprintf (buff, "Create Link failed: %lx", sc);
        ErrorMessage (buff);
        return FALSE;
    }    
    
    // now setup the advisee and the advisor
    if (this->pOleObject->QueryInterface (IID_IViewObject, (LPVOID FAR *)&pViewObject) == NOERROR) {
        pViewObject->SetAdvise (DVASPECT_CONTENT, 0, this->pAdviseSink);
        pViewObject->Release ();
    }
    this->pOleObject->Advise (pAdviseSink, (DWORD FAR *)&dwTemp);
    this->pOleObject->SetHostNames ("container", "object");
    OleSetContainedObject ((IUnknown *)(this->pOleObject), TRUE);

    SIZEL   slTemp;
    HDC     hDC;

    this->pOleObject->GetExtent (DVASPECT_CONTENT, &slTemp);
    ConvertHimetricToPixels (hDC=GetDC (gApplication.GetHMainWnd ()), &slTemp, &slTemp);
    ReleaseDC (gApplication.GetHMainWnd (), hDC);
    this->extX = (short)slTemp.cx;
    this->extY = (short)slTemp.cy;

    return TRUE;
}

BOOL CEmbeddedObject::Init (IDataObject *pDataObj)
{
    IViewObject     *pViewObject;
    DWORD           dwTemp;
    HRESULT         hResult;
    SCODE           sc;
    char            buff[32];

    if (CreateILockBytesOnHGlobal (NULL, TRUE, &this->pLockBytes) != NOERROR)
        return FALSE;

    if (StgCreateDocfileOnILockBytes (this->pLockBytes, 
                                      STGM_READWRITE | STGM_CREATE | 
                                      STGM_TRANSACTED | STGM_SHARE_EXCLUSIVE, 
                                      NULL, &this->pStorage) != NOERROR) {
//        this->pLockBytes->Release (); // the assumption is that the pLockBytes is still valid
        return FALSE;
    }

    this->pOleClientSite = new CDrawnObjectOleClientSite (this);
    this->pAdviseSink = new CDrawnObjectAdviseSink (this);
    this->pUnknown = new CDrawnObjectUnknown (this);
    
    if ((hResult = OleCreateFromData (pDataObj, IID_IOleObject,
                               OLERENDER_DRAW,
                               NULL,
                               this->pOleClientSite,
                               this->pStorage,
                               (LPVOID FAR *)&this->pOleObject)) != NOERROR) {
        sc = GetScode (hResult);
        sprintf (buff, "Create failed: %lx", sc);
        ErrorMessage (buff);
        return FALSE;
    }    
    
    // now setup the advisee and the advisor
    if (this->pOleObject->QueryInterface (IID_IViewObject, (LPVOID FAR *)&pViewObject) == NOERROR) {
        pViewObject->SetAdvise (DVASPECT_CONTENT, 0, this->pAdviseSink);
        pViewObject->Release ();
    }
    this->pOleObject->Advise (pAdviseSink, (DWORD FAR *)&dwTemp);
    this->pOleObject->SetHostNames ("container", "object");
    OleSetContainedObject ((IUnknown *)(this->pOleObject), TRUE);

    SIZEL   slTemp;
    HDC     hDC;

    this->pOleObject->GetExtent (DVASPECT_CONTENT, &slTemp);
    ConvertHimetricToPixels (hDC=GetDC (gApplication.GetHMainWnd ()), &slTemp, &slTemp);
    ReleaseDC (gApplication.GetHMainWnd (), hDC);
    this->extX = (short)slTemp.cx;
    this->extY = (short)slTemp.cy;

    return TRUE;
}

HRESULT COLEObject::QueryInterface (REFIID riid, LPVOID FAR *ppvObj)
{
    SCODE sc = S_OK;                                
    
    *ppvObj = NULL;
                    
    if (IsEqualIID (riid, IID_IStorage)) {
        *ppvObj = (LPVOID)this->pStorage;
        this->pStorage->AddRef ();
    } else if (IsEqualIID (riid, IID_IOleObject)) {
        *ppvObj = (LPVOID)this->pOleObject;
        this->pOleObject->AddRef ();
    } else if (IsEqualIID (riid, IID_IOleClientSite)) {
        *ppvObj = (LPVOID)this->pOleClientSite;
        this->pOleClientSite->AddRef ();
    } else if (IsEqualIID (riid, IID_IAdviseSink)) {
        *ppvObj = (LPVOID)this->pAdviseSink;
        this->pAdviseSink->AddRef ();
    } else if (IsEqualIID (riid, IID_IUnknown)) {
        *ppvObj = (LPVOID)this->pUnknown;
        this->pUnknown->AddRef ();
    } else if (IsEqualIID (riid, IID_IOleInPlaceObject)) {
        return this->pOleObject->QueryInterface (riid, ppvObj);
    } else if (IsEqualIID (riid, IID_IPersist) ||
               IsEqualIID (riid, IID_IPersistStorage) ||
               IsEqualIID (riid, IID_IPersistFile) ||
               IsEqualIID (riid, IID_IPersistStream)) {
        return this->pOleObject->QueryInterface (riid, ppvObj);
    } else
        return this->pDoc->QueryInterface (riid, ppvObj);
        
    return ResultFromScode (sc);
}
             
HRESULT COLEObject::SaveObject (void)
{
//    ErrorMessage ("COLEObject::SaveObject: NYI");
    return NOERROR;
}

IMoniker *COLEObject::GetItemMoniker (DWORD dwAssign)
{
    IMoniker *pmkTemp = NULL;
    
    switch (dwAssign) {
      case OLEGETMONIKER_FORCEASSIGN:
        CreateItemMoniker ("!", this->fName, &pmkTemp);
        this->bMonikerAssigned = TRUE;
        if (this->pOleObject)
            this->pOleObject->SetMoniker (OLEWHICHMK_OBJREL, pmkTemp);
        break;
      case OLEGETMONIKER_ONLYIFTHERE:
        if (this->bMonikerAssigned)
            CreateItemMoniker ("!", this->fName, &pmkTemp);
        break;
      case OLEGETMONIKER_TEMPFORUSER:
        CreateItemMoniker ("!", this->fName, &pmkTemp);
        break;
      case OLEGETMONIKER_UNASSIGN:
        this->bMonikerAssigned = FALSE;
    }
    return pmkTemp;
}

HRESULT COLEObject::GetMoniker (DWORD dwAssign, DWORD dwWhichMoniker, IMoniker **ppmk)
{
    switch (dwWhichMoniker) {
      case OLEWHICHMK_CONTAINER:
        return this->pDoc->QueryInterface (IID_IMoniker, (LPVOID *)ppmk);
      case OLEWHICHMK_OBJREL:
        *ppmk = this->GetItemMoniker (dwAssign);
        break;
      case OLEWHICHMK_OBJFULL:
        IMoniker *pDocMoniker, *pItemMoniker;
        
        if (this->pDoc->QueryInterface (IID_IMoniker, (LPVOID *)pDocMoniker) == NOERROR) {
            if (pItemMoniker = this->GetItemMoniker (dwAssign)) {
                CreateGenericComposite (pDocMoniker, pItemMoniker, ppmk);
                pItemMoniker->Release ();
            }
            pDocMoniker->Release ();
        }
        break;
    }
    if (*ppmk)
        return NOERROR;
    return ResultFromScode(E_FAIL);
}

HRESULT COLEObject::GetContainer (IOleContainer **ppContainer)
{
    return this->pDoc->QueryInterface (IID_IOleContainer, (LPVOID *)ppContainer);
}

HRESULT COLEObject::ShowObject (void)
{
//    ErrorMessage ("COLEObject::ShowObject: NYI");
    return NOERROR;
}

HRESULT COLEObject::OnShowWindow (BOOL fShow)
{
//    ErrorMessage ("COLEObject::OnShowWindow: NYI");
    return NOERROR;
}

HRESULT COLEObject::RequestNewObjectLayout (void)
{
//    ErrorMessage ("COLEObject::RequestNewObjectLayout: NYI");
    return NOERROR;
}

void COLEObject::OnDataChange (FORMATETC *pFormatEtc, STGMEDIUM *pStgMed)
{
    RECT rcTemp;
    
    rcTemp.right = (rcTemp.left = this->posX) + this->extX;
    rcTemp.bottom = (rcTemp.top = this->posY) + this->extY;
    ::InvalidateRect (this->pDoc->GetHWnd (), &rcTemp, TRUE);
}

void COLEObject::OnViewChange (DWORD dwAspect, LONG lindex)
{
    RECT rcTemp;
    
    rcTemp.right = (rcTemp.left = this->posX) + this->extX;
    rcTemp.bottom = (rcTemp.top = this->posY) + this->extY;
    ::InvalidateRect (this->pDoc->GetHWnd (), &rcTemp, TRUE);
}

void COLEObject::OnRename (IMoniker *pmk)
{
//    ErrorMessage ("COLEObject::OnRename: NYI");
}

void COLEObject::OnSave (void)
{
//    ErrorMessage ("COLEObject::OnSave: NYI");
}

void COLEObject::OnClose (void)
{
//    ErrorMessage ("COLEObject::OnClose: NYI");
}

IOleObject *COLEObject::GetOLEObject (void)
{
    IOleObject *pOleObject;
    
    if (this->QueryInterface (IID_IOleObject, (LPVOID *)&pOleObject) == NOERROR)
        return pOleObject;
        
    return NULL;
}

void COLEObject::Deactivate (void)
{
    IOleInPlaceObject *pActiveObject;
    
    if (this->QueryInterface (IID_IOleInPlaceObject, (LPVOID *)&pActiveObject) == NOERROR) {
        pActiveObject->UIDeactivate ();
        OleSetMenuDescriptor (NULL, gApplication.GetHMainWnd (),
                              gApplication.GetHMainWnd (), NULL, NULL);
        ::SetMenu (gApplication.GetHMainWnd (), 
                   ::LoadMenu (gApplication.GetHInst (), "OLE2TESTMENU"));
        pActiveObject->InPlaceDeactivate ();
        pActiveObject->Release ();
    }
}

HRESULT STDMETHODCALLTYPE CDrawnObjectUnknown::QueryInterface (REFIID riid, LPVOID FAR *ppvObj)
{
    return ((COLEObject *)this->pDrawnObject)->QueryInterface (riid, ppvObj);
}

ULONG STDMETHODCALLTYPE CDrawnObjectUnknown::AddRef (void)
{
    return ++(this->fRefCount);
}

ULONG STDMETHODCALLTYPE CDrawnObjectUnknown::Release (void)
{
    if (--(this->fRefCount) <= 0) {
        delete this;
        return 0;
    }
    return this->fRefCount;
}

HRESULT STDMETHODCALLTYPE CDrawnObjectOleClientSite::QueryInterface (REFIID riid, LPVOID FAR *ppvObj)
{
    return ((COLEObject *)this->pDrawnObject)->QueryInterface (riid, ppvObj);
}

ULONG STDMETHODCALLTYPE CDrawnObjectOleClientSite::AddRef (void)
{
    return ++(this->fRefCount);
}

ULONG STDMETHODCALLTYPE CDrawnObjectOleClientSite::Release (void)
{
    if (--(this->fRefCount) <= 0) {
        delete this;
        return 0;
    }
    return this->fRefCount;
}
    
HRESULT STDMETHODCALLTYPE CDrawnObjectOleClientSite::SaveObject (void)
{
    return ((COLEObject *)this->pDrawnObject)->SaveObject ();
}

HRESULT STDMETHODCALLTYPE CDrawnObjectOleClientSite::GetMoniker (DWORD dwAssign, DWORD dwWhichMoniker, IMoniker **ppmk)
{
    return ((COLEObject *)this->pDrawnObject)->GetMoniker (dwAssign, dwWhichMoniker, ppmk);
}

HRESULT STDMETHODCALLTYPE CDrawnObjectOleClientSite::GetContainer (IOleContainer **ppContainer)
{
    return ((COLEObject *)this->pDrawnObject)->GetContainer (ppContainer);
}

HRESULT STDMETHODCALLTYPE CDrawnObjectOleClientSite::ShowObject (void)
{
    return ((COLEObject *)this->pDrawnObject)->ShowObject ();
}

HRESULT STDMETHODCALLTYPE CDrawnObjectOleClientSite::OnShowWindow (BOOL fShow)
{
    return ((COLEObject *)this->pDrawnObject)->OnShowWindow (fShow);
}

HRESULT STDMETHODCALLTYPE CDrawnObjectOleClientSite::RequestNewObjectLayout (void)
{
    return ((COLEObject *)this->pDrawnObject)->RequestNewObjectLayout ();
}

HRESULT STDMETHODCALLTYPE CDrawnObjectAdviseSink::QueryInterface (REFIID riid, LPVOID FAR *ppvObj)
{
    return ((COLEObject *)this->pDrawnObject)->QueryInterface (riid, ppvObj);
}

ULONG STDMETHODCALLTYPE CDrawnObjectAdviseSink::AddRef (void)
{
    return ++(this->fRefCount);
}

ULONG STDMETHODCALLTYPE CDrawnObjectAdviseSink::Release (void)
{
    if (--(this->fRefCount) <= 0) {
        delete this;
        return 0;
    }
    return this->fRefCount;
}
    
void STDMETHODCALLTYPE CDrawnObjectAdviseSink::OnDataChange (FORMATETC *pFormatEtc, STGMEDIUM *pStgMed)
{
    ((COLEObject *)this->pDrawnObject)->OnDataChange (pFormatEtc, pStgMed);
}

void STDMETHODCALLTYPE CDrawnObjectAdviseSink::OnViewChange (DWORD dwAspect, LONG lindex)
{
    ((COLEObject *)this->pDrawnObject)->OnViewChange (dwAspect, lindex);
}

void STDMETHODCALLTYPE CDrawnObjectAdviseSink::OnRename (IMoniker *pmk)
{
    ((COLEObject *)this->pDrawnObject)->OnRename (pmk);
}                                                

void STDMETHODCALLTYPE CDrawnObjectAdviseSink::OnSave (void)
{
    ((COLEObject *)this->pDrawnObject)->OnSave ();
}                                                   

void STDMETHODCALLTYPE CDrawnObjectAdviseSink::OnClose (void)
{
    ((COLEObject *)this->pDrawnObject)->OnClose ();
}

