#ifndef __drawobj__
#define __drawobj__

#include "io.hpp"

enum {
    DT_NONE,
    DT_TEXT,
    DT_RECT,
    DT_ELLIPSE,
    DT_LINK,
    DT_EMBEDDED
};

// forward ref city
class CDrawnObject;
class CDocument;
class CDrawnObjectUnknown;
class CDrawnObjectOleClientSite;
class CDrawnObjectAdviseSink;
      
class CDrawnObject {
  public:
                CDrawnObject (CDocument *pDoc, short offset, char *name);
    virtual     ~CDrawnObject (void) {}

    virtual short GetType (void) { return DT_NONE; }

    CDrawnObject *Next (void) { return this->pNext; }
    void        SetNext (CDrawnObject *pObj) { this->pNext = pObj; }
    
    virtual void Draw (HDC hDC) {}
    virtual BOOL Init (IDataObject *pDataObj) { return TRUE; }

    static CDrawnObject *Read (InputOutput *pIOObject, CDocument *pDoc);
    virtual void ReadData (InputOutput *pIOObject);
    virtual void Write (InputOutput *pIOObject);

    virtual IOleObject *GetOLEObject (void) { return NULL; } // this is cheating, from a class sense

    void        GetRect (RECT *pRect) 
    { 
        pRect->right = (pRect->left = this->posX) + this->extX; 
        pRect->bottom = (pRect->top = this->posY) + this->extY; 
    }
    
    short       posX, posY, extX, extY;

  protected:
    CDocument   *pDoc;
    CDrawnObject *pNext;
    char        fName[32];
};

class CTextObject : public CDrawnObject {
  public:
                CTextObject (CDocument *pDoc, short offset, char *name) : 
                    CDrawnObject (pDoc, offset, name) {}

    short GetType (void) { return DT_TEXT; }

    virtual void Draw (HDC hDC);
};

class CRectObject : public CDrawnObject {
  public:
                CRectObject (CDocument *pDoc, short offset, char *name) : 
                    CDrawnObject (pDoc, offset, name) {}

    short GetType (void) { return DT_RECT; }

    virtual void Draw (HDC hDC);
};

class CEllipseObject : public CDrawnObject {
  public:
                CEllipseObject (CDocument *pDoc, short offset, char *name) : 
                    CDrawnObject (pDoc, offset, name) {}

    short GetType (void) { return DT_ELLIPSE; }

    virtual void Draw (HDC hDC);
};

class COLEObject : public CDrawnObject {
  public:
            COLEObject (CDocument *pDoc, short offset, char *name);
            ~COLEObject (void);
        
    void Draw (HDC hDC);
    
    void        Write (InputOutput *pIOObject);
    void        ReadData (InputOutput *pIOObject);

    HRESULT     QueryInterface (REFIID riid, LPVOID FAR *ppvObj);
    ULONG       AddRef (void);
    ULONG       Release (void);
    
    HRESULT     SaveObject (void);
    HRESULT     GetMoniker (DWORD dwAssign, DWORD dwWhichMoniker, IMoniker **ppmk);
    HRESULT     GetContainer (IOleContainer **ppContainer);
    HRESULT     ShowObject (void);
    HRESULT     OnShowWindow (BOOL fShow);
    HRESULT     RequestNewObjectLayout (void);
    
    void        OnDataChange (FORMATETC *pFormatEtc, STGMEDIUM *pStgMed);
    void        OnViewChange (DWORD dwAspect, LONG lindex);
    void        OnRename (IMoniker *pmk);
    void        OnSave (void);
    void        OnClose (void);
    
    IOleObject  *GetOLEObject (void);
    void        Deactivate (void);
    
  protected:
    IMoniker    *GetItemMoniker (DWORD dwAssign);
    
    CDrawnObjectUnknown *pUnknown;
    IStorage    *pStorage;
    ILockBytes  *pLockBytes;
    IOleObject  *pOleObject;
    CDrawnObjectOleClientSite *pOleClientSite;
    CDrawnObjectAdviseSink *pAdviseSink;
    BOOL        bMonikerAssigned;
};

class CLinkObject : public COLEObject {
  public:
                CLinkObject (CDocument *pDoc, short offset, char *name) : 
                    COLEObject (pDoc, offset, name) {}

    short GetType (void) { return DT_LINK; }

    BOOL Init (IDataObject *pDataObj);
};

class CEmbeddedObject : public COLEObject {
  public:
                CEmbeddedObject (CDocument *pDoc, short offset, char *name) : 
                    COLEObject (pDoc, offset, name) {}

    short GetType (void) { return DT_EMBEDDED; }

    BOOL Init (IDataObject *pDataObj);
};

class CDrawnObjectUnknown : public IUnknown {
  public:
        CDrawnObjectUnknown (CDrawnObject *pObject) : IUnknown () 
            { this->pDrawnObject = pObject; this->fRefCount = 1; }
        
    virtual HRESULT STDMETHODCALLTYPE QueryInterface (REFIID riid, LPVOID FAR *ppvObj);
    virtual ULONG   STDMETHODCALLTYPE AddRef (void);
    virtual ULONG   STDMETHODCALLTYPE Release (void);
    
  private:
     CDrawnObject *pDrawnObject;
     short      fRefCount;
};

class CDrawnObjectOleClientSite : public IOleClientSite {
  public:
        CDrawnObjectOleClientSite (CDrawnObject *pObject) : IOleClientSite () 
            { this->pDrawnObject = pObject; this->fRefCount = 1; }
        
    virtual HRESULT STDMETHODCALLTYPE QueryInterface (REFIID riid, LPVOID FAR *ppvObj);
    virtual ULONG   STDMETHODCALLTYPE AddRef (void);
    virtual ULONG   STDMETHODCALLTYPE Release (void);
    
    virtual HRESULT STDMETHODCALLTYPE SaveObject (void);
    virtual HRESULT STDMETHODCALLTYPE GetMoniker (DWORD dwAssign, DWORD dwWhichMoniker, IMoniker **ppmk);
    virtual HRESULT STDMETHODCALLTYPE GetContainer (IOleContainer **ppContainer);
    virtual HRESULT STDMETHODCALLTYPE ShowObject (void);
    virtual HRESULT STDMETHODCALLTYPE OnShowWindow (BOOL fShow);
    virtual HRESULT STDMETHODCALLTYPE RequestNewObjectLayout (void);
    
  private:
     CDrawnObject *pDrawnObject;
     short      fRefCount;
};

class CDrawnObjectAdviseSink : public IAdviseSink {
  public:
        CDrawnObjectAdviseSink (CDrawnObject *pObject) : IAdviseSink () 
            { this->pDrawnObject = pObject; this->fRefCount = 1; }
        
    virtual HRESULT STDMETHODCALLTYPE QueryInterface (REFIID riid, LPVOID FAR *ppvObj);
    virtual ULONG   STDMETHODCALLTYPE AddRef (void);
    virtual ULONG   STDMETHODCALLTYPE Release (void);
    
    virtual void    STDMETHODCALLTYPE OnDataChange (FORMATETC *pFormatEtc, STGMEDIUM *pStgMed);
    virtual void    STDMETHODCALLTYPE OnViewChange (DWORD dwAspect, LONG lindex);
    virtual void    STDMETHODCALLTYPE OnRename (IMoniker *pmk);
    virtual void    STDMETHODCALLTYPE OnSave (void);
    virtual void    STDMETHODCALLTYPE OnClose (void);
    
  private:
     CDrawnObject *pDrawnObject;
     short      fRefCount;
};

#endif
