//
//  Ole2Test application
//
//  drop.cpp - CDropTarget methods
//
//  Copyright 1993 Macromedia, Inc.
//
//  Initial Version:
//      J. Paul Kase, 5/23/93
//

#include "ole2test.h" 
#include <stdio.h>

#include <ole2.h>

#include "drop.hpp"
#include "doc.hpp"
#include "app.hpp"

HRESULT STDMETHODCALLTYPE CDropTarget::QueryInterface (REFIID riid, LPVOID FAR *ppvObj)
{ 
    return this->pDoc->QueryInterface (riid, ppvObj);
}

ULONG STDMETHODCALLTYPE CDropTarget::Release (void)
{
    if (--(this->fRefCount) <= 0) {
        delete this;
        return 0;
    }
    return this->fRefCount;
}

DWORD gCurrentEffect;

HRESULT STDMETHODCALLTYPE CDropTarget::DragEnter (IDataObject *pDataObj, DWORD grfKeyState, POINTL pt, DWORD *pdwEffect)
{
    if (this->pDoc->CanAccept (pDataObj, TRUE) != -1) {
        gCurrentEffect = DROPEFFECT_LINK;
    } else if (this->pDoc->CanAccept (pDataObj, FALSE) != -1) {
        gCurrentEffect = DROPEFFECT_COPY;
    } else
        gCurrentEffect = DROPEFFECT_NONE;

    *pdwEffect = gCurrentEffect;

    return NOERROR;
}

HRESULT STDMETHODCALLTYPE CDropTarget::DragOver (DWORD grfKeyState, POINTL pt, DWORD *pdwEffect)
{
    *pdwEffect = gCurrentEffect;
    return NOERROR;
}

HRESULT STDMETHODCALLTYPE CDropTarget::DragLeave (void)
{
//    ErrorMessage ("CDropTarget::DragLeave: NYI");
    return NOERROR;
}

HRESULT STDMETHODCALLTYPE CDropTarget::Drop (IDataObject *pDataObj, DWORD grfKeyState, POINTL pt, DWORD *pdwEffect)
{
    if (this->pDoc->CanAccept (pDataObj, TRUE) != -1) {
        *pdwEffect = DROPEFFECT_LINK;
        this->pDoc->NewObject (OBJ_LINK, pDataObj);
    } else if (this->pDoc->CanAccept (pDataObj, FALSE) != -1) {
        *pdwEffect = DROPEFFECT_COPY;
        this->pDoc->NewObject (OBJ_EMBED, pDataObj);
    } else
        *pdwEffect = DROPEFFECT_NONE;

    return NOERROR;
}

