//
//  Ole2Test application
//
//  io.cpp - InputOutput methods
//
//  Copyright 1993 Macromedia, Inc.
//
//  Initial Version:
//      J. Paul Kase, 5/23/93
//

#define LOCAL_IO

#include <windows.h>
#include <memory.h>

#include "io.hpp"

ClipboardObject::ClipboardObject (void)
{
    this->hMem = GlobalAlloc (GMEM_MOVEABLE, 1000L);
    this->pCurrent = GlobalLock (this->hMem);
    this->bOpenForRead = FALSE;
    this->dwOffset = 0L;
}

ClipboardObject::ClipboardObject (HANDLE hClipMem)
{
    this->hMem = hClipMem;
    this->pCurrent = GlobalLock (this->hMem);
    this->bOpenForRead = TRUE;
    this->dwOffset = 0L;
}

ClipboardObject::~ClipboardObject (void)
{
    if (this->bOpenForRead)
        GlobalUnlock (this->hMem);
    else
        GlobalReAlloc (this->hMem, this->dwOffset, GMEM_MOVEABLE);

//    GlobalFree (this->hMem);
}

DWORD ClipboardObject::WriteBytes (char *pData, DWORD numBytes)
{
    if (this->dwOffset + numBytes >= GlobalSize (this->hMem)) 
        GlobalReAlloc (this->hMem, this->dwOffset + numBytes + 256L, GMEM_MOVEABLE);

    memcpy (this->pCurrent, pData, (UINT)numBytes);
    this->pCurrent += numBytes;

    return numBytes;
}

DWORD ClipboardObject::ReadBytes (char *pData, DWORD numBytes)
{
    memcpy (pData, this->pCurrent, (UINT)numBytes);
    this->pCurrent += numBytes;

    return numBytes;
}


