#ifndef __io__
#define __io__

class InputOutput {
  public:
    virtual DWORD WriteBytes (char *pData, DWORD numBytes) = 0;
    virtual DWORD ReadBytes (char *pData, DWORD numBytes) = 0;
};

class FileObject : public InputOutput {
  public:
    FileObject (HFILE hFile) { this->fileIndex = hFile; }

    virtual DWORD WriteBytes (char *pData, DWORD numBytes)
        { return _lwrite (this->fileIndex, pData, (UINT)numBytes); }
    virtual DWORD ReadBytes (char *pData, DWORD numBytes)
        { return _lread (this->fileIndex, pData, (UINT)numBytes); }

  private:
    HFILE fileIndex;
};

class ClipboardObject : public InputOutput {
  public:
    ClipboardObject (void);
    ClipboardObject (HANDLE hClipMem);
    ~ClipboardObject (void);

    virtual DWORD WriteBytes (char *pData, DWORD numBytes);
    virtual DWORD ReadBytes (char *pData, DWORD numBytes);

    HANDLE GetHandle (void) { return this->hMem; }

  private:
    HANDLE  hMem;
    char    *pCurrent;
    DWORD   dwOffset;
    BOOL    bOpenForRead;
};

#endif
