/*
 * PATRON.H
 * Original Starter Chapter 2
 *
 * Single include file that pulls in everything needed for other source
 * files in the application.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _PATRON_H_
#define _PATRON_H_

#include <windows.h>

extern "C"
    {
    #include <commdlg.h>
    #include <print.h>
    }

#include <classlib.h>
#include <debug.h>
#include <win1632.h>
#include "resource.h"

//Get editor window information
#include "pages.h"

//PATRON.CPP:  Frame object that creates a main window

class __far CPatronFrame : public CFrame
    {
    protected:
        //Overridable for creating a CPatronClient
        virtual LPCClient CreateCClient(void);

        virtual BOOL      FRegisterAllClasses(void);
        virtual UINT      CreateGizmos(void);
        virtual LRESULT   OnCommand(HWND, WPARAM, LPARAM);

    public:
        CPatronFrame(HINSTANCE, HINSTANCE, LPSTR, int);
        virtual ~CPatronFrame(void);

        //Overrides
        virtual void     UpdateMenus(HMENU, UINT);
        virtual void     UpdateGizmos(void);

    };


typedef CPatronFrame FAR * LPCPatronFrame;





//CLIENT.CPP

/*
 * The only reason we have a derived class here is to override
 * CreateCDocument so we can create our own type as well as
 * overriding NewDocument to perform one other piece of work once the
 * document's been created.
 */

class __far CPatronClient : public CClient
    {
    protected:
        //Overridable for creating a new CDocument
        virtual LPCDocument CreateCDocument();

    public:
        CPatronClient(HINSTANCE);
        virtual ~CPatronClient(void);
    };


typedef CPatronClient FAR * LPCPatronClient;




//DOCUMENT.CPP

//Constant ID for the pages window that lives in a document window
#define ID_PAGES            723


class __far CPatronDoc : public CDocument
    {
    protected:
        LONG            m_lVer;         //Loaded data version
        LPCPages        m_pPG;          //Pages window in us.

    protected:
        virtual BOOL    FMessageHook(HWND, UINT, WPARAM, LPARAM, LRESULT FAR *);

    public:
        CPatronDoc(HINSTANCE);
        virtual ~CPatronDoc(void);

        virtual BOOL     FInit(LPDOCUMENTINIT);
        virtual void     Clear();

        virtual UINT     ULoad(BOOL, LPSTR);

        virtual BOOL     Print(HWND);
        virtual UINT     PrinterSetup(HWND, BOOL);

        virtual UINT     NewPage(void);
        virtual UINT     DeletePage(void);
        virtual UINT     NextPage(void);
        virtual UINT     PreviousPage(void);
        virtual UINT     FirstPage(void);
        virtual UINT     LastPage(void);
    };

typedef CPatronDoc FAR * LPCPatronDoc;




#endif //_PATRON_H_
