/*
 * ENUM.H
 *
 * Definitions, classes, and prototypes for Enumerator interface
 * example implemented in C++.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _ENUM_H_
#define _ENUM_H_


#include <ienum0.h>      //Found in shared include directory.
#include <win1632.h>


//Menu Resource ID and Commands
#define IDR_MENU                    1

#define IDM_ENUMCREATE              100
#define IDM_ENUMRELEASE             101
#define IDM_ENUMRUNTHROUGH          102
#define IDM_ENUMEVERYTHIRD          103
#define IDM_ENUMRESET               104
#define IDM_ENUMEXIT                105



//ENUM.CPP
LRESULT FAR PASCAL __export EnumWndProc(HWND, UINT, WPARAM, LPARAM);

class __far CAppVars
    {
    friend LRESULT FAR PASCAL __export EnumWndProc(HWND, UINT, WPARAM, LPARAM);

    protected:
        HINSTANCE       m_hInst;            //WinMain parameters
        HINSTANCE       m_hInstPrev;
        UINT            m_nCmdShow;

        HWND            m_hWnd;             //Main window handle
        LPENUMRECT      m_pIEnumRect;       //Enumerator interface we have.

    public:
        CAppVars(HINSTANCE, HINSTANCE, UINT);
        ~CAppVars(void);
        BOOL FInit(void);
    };


typedef CAppVars FAR * LPAPPVARS;

#define CBWNDEXTRA          sizeof(LONG)
#define ENUMWL_STRUCTURE    0


//IENUM.CPP

//Number of rectangles that objects with IEnumRECT support (for demo)
#define CRECTS      15

/*
 * A class definition, which OLE doesn't provide, then inherits from
 * whatever interfaces it supports.  Multiple inheritance works fine
 * in this scenario as well as single inheritance shown here.
 */
class __far CImpIEnumRECT : public IEnumRECT
    {
    private:
        DWORD           m_cRef;         //Interface reference count.
        DWORD           m_iCur;         //Current enumeration position
        RECT            m_rgrc[CRECTS]; //Rectangles we contain for enumeration

    public:
        CImpIEnumRECT(void);
        ~CImpIEnumRECT(void);

        virtual DWORD AddRef(void);
        virtual DWORD Release(void);
        virtual BOOL  Next(DWORD, LPRECT, LPDWORD);
        virtual BOOL  Skip(DWORD);
        virtual void  Reset(void);
    };


typedef CImpIEnumRECT FAR * LPIMPIENUMRECT;


//Function that creates one of these objects
BOOL CreateRECTEnumerator(LPENUMRECT FAR *);


#endif //_ENUM_H_
