/*
 * MALLOC.H
 *
 * Definitions for a demonstration of IMalloc.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _MALLOC_H_
#define _MALLOC_H_


//Menu Resource ID and Commands
#define IDR_MENU                        1


#define IDM_IMALLOCCOGETMALLOCTASK      100
#define IDM_IMALLOCCOGETMALLOCSHARED    101
#define IDM_IMALLOCRELEASE              102
#define IDM_IMALLOCALLOC                103
#define IDM_IMALLOCFREE                 104
#define IDM_IMALLOCREALLOC              105
#define IDM_IMALLOCGETSIZE              106
#define IDM_IMALLOCDIDALLOC             107
#define IDM_IMALLOCHEAPMINIMIZE         108
#define IDM_IMALLOCEXIT                 109



//MALLOC.CPP
LRESULT FAR PASCAL __export MallocWndProc(HWND, UINT, WPARAM, LPARAM);


#define CALLOCS 10


/*
 * Application-defined classes and types.
 */

class __far CAppVars
    {
    friend LRESULT FAR PASCAL __export MallocWndProc(HWND, UINT, WPARAM, LPARAM);

    protected:
        HINSTANCE       m_hInst;            //WinMain parameters
        HINSTANCE       m_hInstPrev;
        UINT            m_nCmdShow;

        HWND            m_hWnd;             //Main window handle
        LPMALLOC        m_pIMalloc;         //IMalloc interface we have.
        BOOL            m_fInitialized;     //Did CoInitialize work?

        ULONG           m_rgcb[CALLOCS];    //Array of sizes to allocate
        LPVOID          m_rgpv[CALLOCS];    //Array of allocated pointers

    public:
        CAppVars(HINSTANCE, HINSTANCE, UINT);
        ~CAppVars(void);
        BOOL FInit(void);

        void FreeAllocations(BOOL);
    };


typedef CAppVars FAR * LPAPPVARS;


#define CBWNDEXTRA              sizeof(LONG)
#define MALLOCWL_STRUCTURE      0


#endif //_MALLOC_H_
