/*
 * SCHMOO.H
 *
 * Single include file that pulls in everything needed for other source
 * files in the Schmoo application.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _SCHMOO_H_
#define _SCHMOO_H_

#include <windows.h>
#include <memory.h>
#include <compobj.h>
#include <ole2ver.h>

//Required to happen once and only once.
#ifdef INITCLSID
#include "initguid.h"
#undef INITCLSID
#endif

//These include files reference DLLs that don't have extern "C" already
extern "C"
    {
    #include <commdlg.h>
    }

#include <classlib.h>

#include <debug.h>
#include <win1632.h>
#include "resource.h"


//Get the editor window information.
#include <ipoly4.h>




//SCHMOO.CPP:  Frame object that creates a main window

class __far CSchmooFrame : public CFrame
    {
    private:
        HBITMAP         m_hBmpLines[5];     //Menu item bitmaps
        BOOL            m_fInitialized;     //CoInitialize work?

    protected:
        //Overridable for creating a CClient for this frame
        virtual LPCClient CreateCClient(void);

        virtual BOOL      FPreShowInit(void);
        virtual UINT      CreateGizmos(void);

        virtual LRESULT   OnCommand(HWND, WPARAM, LPARAM);
        virtual void      OnDocumentDataChange(LPCDocument);
        virtual void      OnDocumentActivate(LPCDocument);

        //New for this class
        virtual void      CreateLineMenu(void);

    public:
        //Overrides
        CSchmooFrame(HINSTANCE, HINSTANCE, LPSTR, int);
        ~CSchmooFrame(void);

        virtual BOOL      FInit(LPFRAMEINIT);
        virtual void      UpdateMenus(HMENU, UINT);
        virtual void      UpdateGizmos(void);

        //New for this class
        virtual void      CheckLineSelection(UINT);
    };


typedef CSchmooFrame FAR * LPCSchmooFrame;





//CLIENT.CPP

/*
 * The only reason we have a derived class here is to override
 * CreateCDocument so we can create our own type as well as
 * overriding NewDocument to perform one other piece of work once the
 * document's been created.
 */

class __far CSchmooClient : public CClient
    {
    protected:
        //Overridable for creating a new CDocument
        virtual LPCDocument CreateCDocument();

    public:
        CSchmooClient(HINSTANCE);
        ~CSchmooClient(void);

        virtual LPCDocument NewDocument(BOOL, LPCDocumentAdviseSink);
    };


typedef CSchmooClient FAR * LPCSchmooClient;




//DOCUMENT.CPP

class __far CPolylineAdviseSink : public IPolylineAdviseSink
    {
    private:
        LPVOID      m_pv;                       //Customizable structure
        ULONG       m_cRef;

    public:
        CPolylineAdviseSink(LPVOID);
        ~CPolylineAdviseSink(void);

        //IUnknown members
        STDMETHODIMP         QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //Advise members.
        STDMETHODIMP_(void) OnPointChange(void);
        STDMETHODIMP_(void) OnSizeChange(void);
        STDMETHODIMP_(void) OnDataChange(void);
        STDMETHODIMP_(void) OnColorChange(void);
        STDMETHODIMP_(void) OnLineStyleChange(void);
    };

typedef CPolylineAdviseSink FAR * LPCPolylineAdviseSink;




//Constant ID for the window polyline that lives in a document window
#define ID_POLYLINE         10


class __far CSchmooDoc : public CDocument
    {
    friend class CPolylineAdviseSink;

    protected:
        UINT            m_uPrevSize;        //Last WM_SIZE wParam
        LONG            m_lVer;             //Loaded Polyline version

        LPPOLYLINE              m_pPL;      //Polyline Editor window in us.
        LPPOLYLINEADVISESINK    m_pPLAdv;   //Advises from Polyline

    protected:
        virtual BOOL    FMessageHook(HWND, UINT, WPARAM, LPARAM, LRESULT FAR *);

    public:
        CSchmooDoc(HINSTANCE);
        ~CSchmooDoc(void);

        virtual BOOL     FInit(LPDOCUMENTINIT);

        virtual void     Clear();

        virtual UINT     ULoad(BOOL, LPSTR);
        virtual UINT     USave(UINT, LPSTR);

        virtual BOOL     FClip(BOOL);
        virtual HGLOBAL  RenderFormat(UINT);
        virtual BOOL     FQueryPaste(void);
        virtual BOOL     FPaste(void);
        virtual void     Undo(void);

        virtual COLORREF ColorSet(UINT, COLORREF);
        virtual COLORREF ColorGet(UINT);

        virtual UINT     LineStyleSet(UINT);
        virtual UINT     LineStyleGet();
    };

typedef CSchmooDoc FAR * LPCSchmooDoc;


//These color indices wrap the polyline definitions
#define DOCCOLOR_BACKGROUND             POLYLINECOLOR_BACKGROUND
#define DOCCOLOR_LINE                   POLYLINECOLOR_LINE



#endif //_SCHMOO_H_
