/*
 * COSCHMOO.H
 * Component Schmoo Chapter 5
 *
 * Single include file that pulls in everything needed for other source
 * files in the Schmoo application.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _COSCHMOO_H_
#define _COSCHMOO_H_

#include <windows.h>
#include <memory.h>
//CHAPTER5MOD
#include <ole2.h>
#include <ole2ver.h>
#include <bookguid.h>
#include <ipoly5.h>
//End CHAPTER5MOD

//These include files reference DLLs that don't have extern "C" already
extern "C"
    {
    #include <commdlg.h>
    }

#include <classlib.h>
#include "resource.h"


//COSCHMOO.CPP:  Frame object that creates a main window

class __far CSchmooFrame : public CFrame
    {
    private:
        HBITMAP         m_hBmpLines[5];     //Menu item bitmaps

        BOOL            m_fInitialized;     //CoInitialize work?

    protected:
        //Overridable for creating a CClient for this frame
        virtual LPCClient CreateCClient(void);

        //FRegisterAllClasses override unneccessary with Polyline DLL
        virtual BOOL      FPreShowInit(void);
        virtual UINT      CreateGizmos(void);

        virtual LRESULT   OnCommand(HWND, WPARAM, LPARAM);
        virtual void      OnDocumentDataChange(LPCDocument);
        virtual void      OnDocumentActivate(LPCDocument);

        //New for this class
        virtual void      CreateLineMenu(void);

    public:
        CSchmooFrame(HINSTANCE, HINSTANCE, LPSTR, int);
        virtual ~CSchmooFrame(void);

        //Overrides
        virtual BOOL      FInit(LPFRAMEINIT);
        virtual void      UpdateMenus(HMENU, UINT);
        virtual void      UpdateGizmos(void);

        //New for this class
        virtual void      CheckLineSelection(UINT);
    };


typedef CSchmooFrame FAR * LPCSchmooFrame;





//CLIENT.CPP

/*
 * The only reason we have a derived class here is to override
 * CreateCDocument so we can create our own type as well as
 * overriding NewDocument to perform one other piece of work once the
 * document's been created.
 */

class __far CSchmooClient : public CClient
    {
    protected:
        //Overridable for creating a new CDocument
        virtual LPCDocument CreateCDocument();

    public:
        CSchmooClient(HINSTANCE);
        virtual ~CSchmooClient(void);

        virtual LPCDocument NewDocument(BOOL, LPCDocumentAdviseSink);
    };


typedef CSchmooClient FAR * LPCSchmooClient;




//DOCUMENT.CPP

//Explicit CPolyline moved into Polyline DLL and hidden from us.
class __far CPolylineAdviseSink : public IPolylineAdviseSink5
    {
    private:
        LPVOID      m_pv;                       //Customizable structure
        ULONG       m_cRef;

    public:
        CPolylineAdviseSink(LPVOID);
        ~CPolylineAdviseSink(void);

        //IUnknown members
        STDMETHODIMP         QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //Advise members.
        STDMETHODIMP_(void) OnPointChange(void);
        STDMETHODIMP_(void) OnSizeChange(void);
        STDMETHODIMP_(void) OnDataChange(void);
        STDMETHODIMP_(void) OnColorChange(void);
        STDMETHODIMP_(void) OnLineStyleChange(void);
    };

typedef CPolylineAdviseSink FAR * LPCPolylineAdviseSink;



//Constant ID for the window polyline that lives in a document window
#define ID_POLYLINE         10


class __far CSchmooDoc : public CDocument
    {
    friend class CPolylineAdviseSink;

    protected:
        UINT            m_uPrevSize;        //Last WM_SIZE wParam

        LPPOLYLINE              m_pPL;      //Polyline Editor window in us.
        LPPOLYLINEADVISESINK    m_pPLAdv;   //Advises from Polyline

        //CHAPTER5MOD
        LPPERSISTSTORAGE        m_pIPersistStorage; //Polyline's storage
        //End CHAPTER5MOD

    protected:
        virtual BOOL    FMessageHook(HWND, UINT, WPARAM, LPARAM, LRESULT FAR *);

    public:
        CSchmooDoc(HINSTANCE);
        virtual ~CSchmooDoc(void);

        virtual BOOL     FInit(LPDOCUMENTINIT);

        virtual void     Clear();

        virtual UINT     ULoad(BOOL, LPSTR);
        virtual UINT     USave(UINT, LPSTR);

        virtual void     Undo(void);
        virtual BOOL     FClip(HWND, BOOL);
        virtual HGLOBAL  RenderFormat(UINT);
        virtual BOOL     FQueryPaste(void);
        virtual BOOL     FPaste(HWND);

        virtual COLORREF ColorSet(UINT, COLORREF);
        virtual COLORREF ColorGet(UINT);

        virtual UINT     LineStyleSet(UINT);
        virtual UINT     LineStyleGet();
    };

typedef CSchmooDoc FAR * LPCSchmooDoc;


//These color indices wrap the polyline definitions
#define DOCCOLOR_BACKGROUND             POLYLINECOLOR_BACKGROUND
#define DOCCOLOR_LINE                   POLYLINECOLOR_LINE



#endif //_COSCHMOO_H_
